/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cloudConfig.actions;

import com.intellij.cloudConfig.CloudConfigManager;
import com.intellij.cloudConfig.StatusInfo;
import com.intellij.cloudConfig.StatusInfoDialog;
import com.intellij.icons.AllIcons;
import com.intellij.ide.license.impl.JetprofileSource;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.RightAlignedToolbarAction;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Pair;
import icons.CloudConfigIcons;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StatusInfoAction
extends AnAction
implements RightAlignedToolbarAction,
DumbAware {
    public void update(AnActionEvent e) {
        StatusInfo status = CloudConfigManager.getInstance().getStatusInfo();
        Presentation presentation = e.getPresentation();
        if ("MainMenu".equals(e.getPlace())) {
            if (status == StatusInfo.DISABLED && JetprofileSource.getSharedUserId() == null) {
                status = StatusInfo.JBA_NOT_FOUND;
            }
            presentation.setText("JBA Cloud Config");
            presentation.setVisible(status.ordinal() >= StatusInfo.DISABLED.ordinal());
        } else {
            Pair<Icon, String> info = StatusInfoAction.getStatusInfo(status);
            if (info != null) {
                presentation.setIcon((Icon)info.first);
                presentation.setText((String)info.second);
                presentation.setDescription("JBA Cloud Config");
            }
            presentation.setVisible(info != null);
        }
    }

    @Nullable
    private static Pair<Icon, String> getStatusInfo(@NotNull StatusInfo status) {
        if (status == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "status", "com/intellij/cloudConfig/actions/StatusInfoAction", "getStatusInfo"));
        }
        switch (status) {
            case OFFLINE: 
            case DISABLED: 
            case JBA_NOT_FOUND: {
                return null;
            }
            case JBA_IO_ERROR: {
                return Pair.create((Object)AllIcons.Nodes.PpInvalid, (Object)"Connection error, press to refresh");
            }
            case JBA_NOT_CONNECTED: {
                return Pair.create((Object)CloudConfigIcons.Personal_canceled, (Object)"Add configs to JBA account");
            }
            case JBA_THIS_NOT_CONNECTED: {
                return Pair.create((Object)CloudConfigIcons.Personal_pending, (Object)"Connect this instance to JBA account");
            }
            case JBA_CONNECTED: {
                return Pair.create((Object)CloudConfigIcons.Personal_finished_success2, (Object)"You are connected to JBA account");
            }
        }
        return null;
    }

    public void actionPerformed(AnActionEvent e) {
        CloudConfigManager manager = CloudConfigManager.getInstance();
        StatusInfo status = manager.getStatusInfo();
        if (status == StatusInfo.DISABLED) {
            manager.recalculateInitStatus();
            status = manager.getStatusInfo();
            if (status == StatusInfo.JBA_IO_ERROR) {
                Messages.showErrorDialog((String)"https://config-storage.labs.intellij.net/props not responded", (String)"Connection Error");
                return;
            }
        } else if (status == StatusInfo.JBA_IO_ERROR && (status = manager.updateIO()) == null) {
            return;
        }
        new StatusInfoDialog(StatusInfoAction.getEventProject((AnActionEvent)e), status).showAndHandleResult();
    }
}

