/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.hibernate.actions;

import com.intellij.hibernate.facet.HibernateFacet;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.persistence.PersistenceDataKeys;
import com.intellij.persistence.facet.PersistenceFacet;
import com.intellij.persistence.model.PersistencePackage;
import com.intellij.persistence.util.UnitSettingMapConfigurable;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ClassInheritorsSearch;
import com.intellij.psi.util.PsiClassUtil;
import com.intellij.ui.CollectionComboBoxModel;
import com.intellij.ui.ListCellRendererWrapper;
import com.intellij.util.PlatformIcons;
import java.util.ArrayList;
import java.util.Collections;
import javax.swing.JComboBox;
import javax.swing.JList;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AssignNamingStrategiesAction
extends AnAction {
    private static final String DEFAULT = "<default>";

    public void update(AnActionEvent e) {
        PersistenceFacet facet = (PersistenceFacet)PersistenceDataKeys.PERSISTENCE_FACET.getData(e.getDataContext());
        boolean enabled = facet instanceof HibernateFacet;
        e.getPresentation().setEnabledAndVisible(enabled);
    }

    public void actionPerformed(AnActionEvent e) {
        PersistenceFacet facet = (PersistenceFacet)PersistenceDataKeys.PERSISTENCE_FACET.getData(e.getDataContext());
        if (!(facet instanceof HibernateFacet)) {
            return;
        }
        ShowSettingsUtil.getInstance().editConfigurable(facet.getModule().getProject(), (Configurable)new MyComponent((HibernateFacet)facet, e.getPresentation().getText()));
    }

    private static void initNamingStrategiesComboBox(@NotNull Project project, @NotNull JComboBox comboBox) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/hibernate/actions/AssignNamingStrategiesAction", "initNamingStrategiesComboBox"));
        }
        if (comboBox == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "comboBox", "com/intellij/hibernate/actions/AssignNamingStrategiesAction", "initNamingStrategiesComboBox"));
        }
        GlobalSearchScope searchScope = GlobalSearchScope.allScope((Project)project);
        PsiClass namingStrategyClass = JavaPsiFacade.getInstance((Project)project).findClass("org.hibernate.cfg.NamingStrategy", searchScope);
        if (namingStrategyClass == null) {
            comboBox.setEnabled(false);
            return;
        }
        ArrayList<Object> nameList = new ArrayList<Object>();
        ClassInheritorsSearch.search((PsiClass)namingStrategyClass, (SearchScope)searchScope, (boolean)true, (boolean)true, (boolean)false).forEach(psiClass -> {
            String name;
            if (PsiClassUtil.isRunnableClass((PsiClass)psiClass, (boolean)false, (boolean)true) && !nameList.contains(name = psiClass.getQualifiedName())) {
                nameList.add(name);
            }
            return true;
        });
        Collections.sort(nameList);
        nameList.add(0, null);
        comboBox.setModel(new CollectionComboBoxModel(nameList, null));
        comboBox.setEditable(false);
        comboBox.setRenderer(new ListCellRendererWrapper<String>(){

            public void customize(JList list, String name, int index, boolean selected, boolean hasFocus) {
                this.setIcon(name == null ? null : PlatformIcons.CLASS_ICON);
                this.setText(name == null ? AssignNamingStrategiesAction.DEFAULT : name);
            }
        });
    }

    private static class MyComponent
    extends UnitSettingMapConfigurable<HibernateFacet, String> {
        private final String myTitle;

        public MyComponent(HibernateFacet facet, String title) {
            super((PersistenceFacet)facet);
            this.myTitle = title;
        }

        protected void configureValueEditorCombo(ComboBox comboBox) {
            AssignNamingStrategiesAction.initNamingStrategiesComboBox(((HibernateFacet)this.myFacet).getModule().getProject(), (JComboBox)comboBox);
        }

        @NotNull
        protected String getValueColumnName() {
            if ("Naming Strategy" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/hibernate/actions/AssignNamingStrategiesAction$MyComponent", "getValueColumnName"));
            }
            return "Naming Strategy";
        }

        protected void customizeValueRenderer(ComboBox renderer, String value) {
        }

        @Nullable
        protected String getSettingValue(PersistencePackage unit) {
            return ((HibernateFacet)this.myFacet).getNamingStrategy(unit);
        }

        protected void setSettingValue(PersistencePackage unit, String value) {
            ((HibernateFacet)this.myFacet).setNamingStrategy(unit, value);
        }

        @Nls
        public String getDisplayName() {
            return this.myTitle;
        }

        @Nullable
        public String getHelpTopic() {
            return null;
        }
    }
}

