/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.hibernate.engine;

import com.intellij.credentialStore.Credentials;
import com.intellij.database.DataBus;
import com.intellij.database.access.DatabaseCredentials;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.model.DatabaseSystem;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbPsiFacade;
import com.intellij.database.run.ConsoleRunConfiguration;
import com.intellij.hibernate.engine.HibernateConnectionManager;
import com.intellij.hibernate.facet.HibernateFacet;
import com.intellij.hibernate.facet.HibernateVersion;
import com.intellij.hibernate.model.HibernateDescriptorsConstants;
import com.intellij.hibernate.model.xml.config.HibernateConfiguration;
import com.intellij.hibernate.model.xml.config.SessionFactory;
import com.intellij.hibernate.remote.HibernateFacade;
import com.intellij.hibernate.remote.RemoteConfiguration;
import com.intellij.hibernate.remote.RemoteSession;
import com.intellij.hibernate.remote.RemoteSessionFactory;
import com.intellij.hibernate.util.HibernateUtil;
import com.intellij.ide.fileTemplates.FileTemplate;
import com.intellij.ide.fileTemplates.FileTemplateManager;
import com.intellij.jam.JamElement;
import com.intellij.jpa.engine.JpaEngine;
import com.intellij.jpa.engine.JpaEngineBase;
import com.intellij.jpa.remote.RemoteQuery;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.impl.DirectoryIndex;
import com.intellij.openapi.util.Trinity;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.persistence.facet.PersistenceFacet;
import com.intellij.persistence.model.PersistenceMappings;
import com.intellij.persistence.model.PersistencePackage;
import com.intellij.persistence.model.PersistencePackagePointer;
import com.intellij.persistence.model.PersistentEntity;
import com.intellij.persistence.model.helpers.PersistenceUnitModelHelper;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.xml.XmlFile;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.descriptors.ConfigFileMetaData;
import com.intellij.util.descriptors.ConfigFileUtil;
import com.intellij.util.descriptors.ConfigFileVersion;
import com.intellij.util.xml.DomFileElement;
import com.intellij.util.xml.DomManager;
import com.intellij.util.xml.GenericValue;
import com.intellij.util.xml.ModelMergerUtil;
import java.io.File;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HibernateEngine
extends JpaEngineBase {
    private File myTemporaryHibernateConfig;
    private RemoteSession mySession;
    private HibernateFacade myFacade;
    private RemoteConfiguration myHibernateConfiguration;
    private RemoteSessionFactory mySessionFactory;

    public static boolean isAvailable(Module module) {
        return HibernateEngine.isClassAvailable((Module)module, (String)"org.hibernate.cfg.Configuration");
    }

    public HibernateEngine(DataBus.Producing messageBus, PersistencePackagePointer unitFile, ConsoleRunConfiguration configuration) {
        super(messageBus, unitFile, configuration);
    }

    protected void releaseConnection() {
        this.myFacade = null;
        HibernateConnectionManager.getInstance(this.getProject()).releaseConnection(this.myUnitFile, this.myConfiguration);
        this.removeTemporaryFiles();
    }

    private void ensureInitialized() throws Exception {
        try {
            if (this.myFacade.isClosed()) {
                throw new IllegalStateException();
            }
        }
        catch (Exception e) {
            this.removeTemporaryFiles();
            Trinity<File, Boolean, String> info = this.getHibernateConfig();
            if (info == null) {
                return;
            }
            File config = (File)info.first;
            HibernateFacade facade = HibernateConnectionManager.getInstance(this.myConfiguration.getProject()).getConnection(this.myUnitFile, this.myConfiguration);
            RemoteConfiguration configuration = facade.createConfiguration(((Boolean)info.second).booleanValue());
            configuration.configure(config.getCanonicalPath());
            if (StringUtil.isNotEmpty((String)((String)info.third))) {
                configuration.setNamingStrategy((String)info.third);
            }
            RemoteSessionFactory sessionFactory = configuration.buildSessionFactory();
            RemoteSession session = sessionFactory.openSession();
            this.myFacade = facade;
            this.myHibernateConfiguration = configuration;
            this.mySessionFactory = sessionFactory;
            this.mySession = session;
        }
    }

    private void removeTemporaryFiles() {
        if (this.myTemporaryHibernateConfig != null) {
            this.myTemporaryHibernateConfig.delete();
            this.myTemporaryHibernateConfig = null;
        }
    }

    protected RemoteQuery createQuery(String query) throws Exception {
        this.ensureInitialized();
        return this.mySession.createQuery(query);
    }

    protected String getGeneratedDdlInner() throws Exception {
        this.ensureInitialized();
        String ddl1 = this.myHibernateConfiguration.generateSchemaCreationScript();
        String ddl2 = this.myHibernateConfiguration.generateDropSchemaScript();
        return "-- Create schema script\n" + ddl1 + "\n-- Drop schema script\n" + ddl2;
    }

    protected String getGenerateSqlInner(String hqlQuery) throws Exception {
        this.ensureInitialized();
        return this.mySessionFactory.generateSql(hqlQuery);
    }

    private boolean isAnnoConfiguration() {
        PersistenceFacet facet = this.myUnitFile.getPersistenceFacet();
        PersistencePackage unit = this.myUnitFile.findElement();
        if (facet == null || unit == null) {
            return false;
        }
        if (JavaPsiFacade.getInstance((Project)this.getProject()).findClass("org.hibernate.cfg.AnnotationConfiguration", GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)facet.getModule())) == null) {
            return false;
        }
        PersistenceUnitModelHelper helper = unit.getModelHelper();
        if (!helper.getPackages().isEmpty() || !helper.getClasses().isEmpty()) {
            return true;
        }
        PersistenceMappings mappings = facet.getEntityMappings(unit);
        for (PersistentEntity o : mappings.getModelHelper().getPersistentEntities()) {
            if (ModelMergerUtil.getImplementation((Object)o, JamElement.class) == null) continue;
            return true;
        }
        return false;
    }

    @Nullable
    private Trinity<File, Boolean, String> getHibernateConfig() {
        LocalDataSource dataSource = HibernateEngine.findDataSource((Project)this.getProject(), (PersistencePackagePointer)this.myUnitFile);
        Credentials credentials = dataSource == null ? null : DatabaseCredentials.getInstance().getCredentials((DatabaseSystem)dataSource);
        return (Trinity)DumbService.getInstance((Project)this.getProject()).runReadActionInSmartMode(() -> {
            PersistencePackage unit = this.myUnitFile.findElement();
            PersistenceFacet facet = this.myUnitFile.getPersistenceFacet();
            if (unit == null || facet == null || facet.getModule().isDisposed()) {
                return null;
            }
            this.myTemporaryHibernateConfig = this.createTemporaryHibernateConfig(new JpaEngineBase.GenerationInfo(this.getProject(), facet, unit, dataSource, credentials));
            String namingStrategy = facet instanceof HibernateFacet ? ((HibernateFacet)facet).getNamingStrategy(unit) : null;
            return Trinity.create((Object)this.myTemporaryHibernateConfig, (Object)this.isAnnoConfiguration(), (Object)namingStrategy);
        });
    }

    public static String createHibernateConfigXml(@NotNull PersistenceFacet facet, @NotNull PersistencePackage unit) {
        if (facet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facet", "com/intellij/hibernate/engine/HibernateEngine", "createHibernateConfigXml"));
        }
        if (unit == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "unit", "com/intellij/hibernate/engine/HibernateEngine", "createHibernateConfigXml"));
        }
        Project project = facet.getModule().getProject();
        DbDataSource dbElement = DbPsiFacade.getInstance((Project)project).findDataSource(facet.getDataSourceId(unit));
        DatabaseSystem delegate = dbElement != null ? dbElement.getDelegate() : null;
        LocalDataSource dataSource = delegate instanceof LocalDataSource ? (LocalDataSource)delegate : null;
        Credentials credentials = dataSource == null ? null : DatabaseCredentials.getInstance().getCredentials((DatabaseSystem)dataSource);
        return HibernateEngine.createHibernateConfigXml(new JpaEngineBase.GenerationInfo(project, facet, unit, dataSource, credentials));
    }

    private static String createHibernateConfigXml(@NotNull JpaEngineBase.GenerationInfo info) {
        if (info == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "com/intellij/hibernate/engine/HibernateEngine", "createHibernateConfigXml"));
        }
        HibernateVersion hibernateVersion = HibernateUtil.getHibernateVersion(info.facet.getModule());
        ConfigFileVersion configVersion = ConfigFileUtil.getVersionByName((ConfigFileMetaData)HibernateDescriptorsConstants.HIBERNATE_CONFIGURATION_META_DATA, (String)hibernateVersion.getName());
        configVersion = (ConfigFileVersion)ObjectUtils.chooseNotNull((Object)configVersion, (Object)HibernateDescriptorsConstants.HIBERNATE_CONFIGURATION_META_DATA.getDefaultVersion());
        FileTemplate template = FileTemplateManager.getInstance((Project)info.project).getJ2eeTemplate(configVersion.getTemplateName());
        XmlFile xmlFile = (XmlFile)PsiFileFactory.getInstance((Project)info.project).createFileFromText("a.hbm.xml", (FileType)StdFileTypes.XML, (CharSequence)template.getText());
        DomFileElement fileElement = DomManager.getDomManager((Project)info.project).getFileElement(xmlFile, HibernateConfiguration.class);
        assert (fileElement != null);
        SessionFactory sf = ((HibernateConfiguration)fileElement.getRootElement()).getSessionFactory();
        for (Object value : info.unit.getModelHelper().getPackages()) {
            sf.addMapping().getPackage().setStringValue(value.getStringValue());
        }
        for (Object value : info.unit.getModelHelper().getJarFiles()) {
            sf.addMapping().getJar().setStringValue(value.getStringValue());
        }
        List classes = info.unit.getModelHelper().getClasses();
        for (String name : JpaEngine.getMappedClasses((List)classes, (PersistencePackage)info.unit, (PersistenceFacet)info.facet)) {
            sf.addMapping().getClazz().setStringValue(name);
        }
        for (String resource : HibernateEngine.getResourceMappings(info)) {
            sf.addMapping().getResource().setStringValue(resource);
        }
        Set filteredProperties = (Set)JpaEngine.loadJpaTemplate((String)HibernateEngine.getJpaVersion((HibernateVersion)hibernateVersion)).second;
        if (info.dataSource != null) {
            LinkedHashMap props = ContainerUtil.newLinkedHashMap();
            props.put("connection.driver_class", info.dataSource.getDriverClass());
            props.put("connection.url", info.dataSource.getEffectiveUrl(info.project));
            props.put("connection.username", info.credentials.getUserName());
            props.put("connection.password", info.credentials.getPasswordAsString());
            for (Map.Entry entry : info.dataSource.getDriverProperties().entrySet()) {
                props.put("connection." + (String)entry.getKey(), entry.getValue());
            }
            for (Map.Entry entry : props.entrySet()) {
                String fullPropertyName = HibernateUtil.getFullPropertyName((String)entry.getKey());
                HibernateUtil.setSessionFactoryProperty(sf, fullPropertyName, (String)entry.getValue());
                filteredProperties.add(fullPropertyName);
            }
        }
        Properties properties = info.unit.getModelHelper().getPersistenceUnitProperties();
        for (Object object : properties.keySet()) {
            String name = (String)object;
            if (filteredProperties.contains(HibernateUtil.getFullPropertyName(name))) continue;
            HibernateUtil.setSessionFactoryProperty(sf, name, properties.getProperty(name));
        }
        return xmlFile.getText();
    }

    @NotNull
    private static Set<String> getResourceMappings(@NotNull JpaEngineBase.GenerationInfo info) {
        if (info == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "com/intellij/hibernate/engine/HibernateEngine", "getResourceMappings"));
        }
        HashSet resourceMappings = ContainerUtil.newHashSet();
        ProjectFileIndex index = ProjectRootManager.getInstance((Project)info.project).getFileIndex();
        for (GenericValue value : info.unit.getModelHelper().getMappingFiles(PersistenceMappings.class)) {
            String relativePath;
            PersistenceMappings mappings = (PersistenceMappings)value.getValue();
            if (mappings == null) continue;
            PsiFile containingFile = mappings.getContainingFile();
            assert (containingFile != null);
            VirtualFile virtualFile = containingFile.getVirtualFile();
            VirtualFile sourceRoot = index.getSourceRootForFile(virtualFile);
            if (sourceRoot != null) {
                String pkgName = DirectoryIndex.getInstance((Project)info.project).getPackageName(sourceRoot);
                relativePath = (StringUtil.isEmpty((String)pkgName) ? "" : pkgName.replace('.', '/') + "/") + VfsUtilCore.getRelativePath((VirtualFile)virtualFile, (VirtualFile)sourceRoot, (char)'/');
                ContainerUtil.addIfNotNull((Collection)resourceMappings, (Object)relativePath);
                continue;
            }
            if (virtualFile.getFileSystem() instanceof JarFileSystem) {
                String path = virtualFile.getPath();
                relativePath = path.substring(path.indexOf("!/") + "!/".length());
                ContainerUtil.addIfNotNull((Collection)resourceMappings, (Object)relativePath);
                continue;
            }
            ContainerUtil.addIfNotNull((Collection)resourceMappings, (Object)VfsUtilCore.virtualToIoFile((VirtualFile)virtualFile).getAbsolutePath());
        }
        HashSet hashSet = resourceMappings;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/hibernate/engine/HibernateEngine", "getResourceMappings"));
        }
        return hashSet;
    }

    @NotNull
    private static String getJpaVersion(HibernateVersion hibernateVersion) {
        String string = hibernateVersion == HibernateVersion.Hibernate_3_X ? "2.0" : "2.1";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/hibernate/engine/HibernateEngine", "getJpaVersion"));
        }
        return string;
    }

    private File createTemporaryHibernateConfig(@NotNull JpaEngineBase.GenerationInfo info) {
        if (info == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "com/intellij/hibernate/engine/HibernateEngine", "createTemporaryHibernateConfig"));
        }
        String fileName = info.facet.getModule().getName().replace(' ', '_') + "-hibernate-" + System.currentTimeMillis() + ".cfg.xml";
        String text = HibernateEngine.createHibernateConfigXml(info);
        File path = HibernateEngine.getTempDirectory((Project)info.project);
        File file = new File(path, fileName);
        this.writeTemporaryConfigText(file, text, info);
        return file;
    }
}

