/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.struts;

import com.intellij.ide.IconProvider;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.impl.ElementPresentationUtil;
import com.intellij.psi.jsp.JspFile;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.ui.LayeredIcon;
import com.intellij.ui.RowIcon;
import icons.StrutsApiIcons;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StrutsIconProvider
extends IconProvider {
    private boolean active;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public Icon getIcon(@NotNull PsiElement element, int flags) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/struts/StrutsIconProvider", "getIcon"));
        }
        if (element instanceof JspFile) {
            return null;
        }
        if (!(element instanceof PsiClass)) {
            return null;
        }
        if (!element.isPhysical()) {
            return null;
        }
        if (this.active) {
            return null;
        }
        this.active = true;
        try {
            Icon strutsIcon = null;
            Object icon = null;
            PsiClass psiClass = (PsiClass)element;
            if (InheritanceUtil.isInheritor((PsiClass)psiClass, (String)"org.apache.struts.action.Action")) {
                strutsIcon = StrutsApiIcons.ActionMapping_small;
            } else if (InheritanceUtil.isInheritor((PsiClass)psiClass, (String)"org.apache.struts.action.ActionForm")) {
                strutsIcon = StrutsApiIcons.FormBean_small;
            } else if (InheritanceUtil.isInheritor((PsiClass)psiClass, (String)"org.apache.struts.tiles.Controller")) {
                strutsIcon = StrutsApiIcons.Tiles.Tile_small;
            }
            if (strutsIcon != null) {
                icon = new LayeredIcon(2);
                Icon original = element.getIcon(flags & 0xFFFFFFFE);
                icon.setIcon(original, 0);
                icon.setIcon(strutsIcon, 1, 0, 6);
                RowIcon rowIcon = new RowIcon(2);
                rowIcon.setIcon((Icon)icon, 0);
                icon = ElementPresentationUtil.addVisibilityIcon((PsiModifierListOwner)((PsiClass)element), (int)flags, (RowIcon)rowIcon);
            }
            LayeredIcon layeredIcon = icon;
            return layeredIcon;
        }
        finally {
            this.active = false;
        }
    }
}

