/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.web.mvc.jam;

import com.intellij.ide.presentation.Presentation;
import com.intellij.jam.JamConverter;
import com.intellij.jam.JamElement;
import com.intellij.jam.JamEnumAttributeElement;
import com.intellij.jam.JamPomTarget;
import com.intellij.jam.JamService;
import com.intellij.jam.JamStringAttributeElement;
import com.intellij.jam.reflect.JamAnnotationMeta;
import com.intellij.jam.reflect.JamAttributeMeta;
import com.intellij.jam.reflect.JamChildrenQuery;
import com.intellij.jam.reflect.JamClassMeta;
import com.intellij.jam.reflect.JamEnumAttributeMeta;
import com.intellij.jam.reflect.JamMemberMeta;
import com.intellij.jam.reflect.JamMethodMeta;
import com.intellij.jam.reflect.JamStringAttributeMeta;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementRef;
import com.intellij.psi.PsiLiteral;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.psi.PsiTarget;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.spring.web.mvc.jam.MVCPathVariable;
import com.intellij.spring.web.mvc.jam.RequestMapping;
import com.intellij.spring.web.mvc.jam.RequestMethod;
import com.intellij.spring.web.mvc.jam.SpringMVCModelAttribute;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Function;
import com.intellij.util.NullableFunction;
import com.intellij.util.containers.ContainerUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Presentation(typeName="@RequestMapping", icon="SpringMvcIcons.RequestMapping")
public abstract class SpringMVCRequestMapping<T extends PsiMember>
implements RequestMapping<T> {
    private static final JamStringAttributeMeta.Collection<String> URLS_META = JamAttributeMeta.collectionString((String)"value");
    private static final JamEnumAttributeMeta.Collection<RequestMethod> METHOD_META = new JamEnumAttributeMeta.Collection("method", RequestMethod.class);
    private static final JamStringAttributeMeta.Collection<String> CONSUMES_META = JamAttributeMeta.collectionString((String)"consumes", (JamConverter)new RequestMappingMimetypeConverter());
    private static final JamStringAttributeMeta.Collection<String> PRODUCES_META = JamAttributeMeta.collectionString((String)"produces", (JamConverter)new RequestMappingMimetypeConverter());
    private static final JamStringAttributeMeta.Collection<String> PARAMS_META = JamAttributeMeta.collectionString((String)"params");
    private static final JamStringAttributeMeta.Collection<String> HEADERS_META = JamAttributeMeta.collectionString((String)"headers");
    private static final JamAnnotationMeta REQUEST_MAPPING_ANNO_META = new JamAnnotationMeta("org.springframework.web.bind.annotation.RequestMapping").addAttribute(URLS_META).addAttribute(METHOD_META).addAttribute(CONSUMES_META).addAttribute(PRODUCES_META).addAttribute(PARAMS_META).addAttribute(HEADERS_META);
    @NotNull
    private static final NullableFunction<JamStringAttributeElement<String>, String> STRING_MAPPER = JamStringAttributeElement::getStringValue;
    private final Function<JamStringAttributeElement<String>, PsiTarget> myMapping = url -> url.getPsiLiteral() == null ? null : new JamPomTarget((JamElement)this, url);

    @Override
    public List<JamStringAttributeElement<String>> getMappingUrls() {
        return (List)REQUEST_MAPPING_ANNO_META.getAttribute(this.getPsiElement(), URLS_META);
    }

    @Override
    public RequestMethod[] getMethods() {
        List methods = ContainerUtil.mapNotNull((Collection)((Collection)REQUEST_MAPPING_ANNO_META.getAttribute(this.getPsiElement(), METHOD_META)), JamEnumAttributeElement::getValue);
        return methods.toArray(new RequestMethod[methods.size()]);
    }

    @Override
    public List<String> getUrls() {
        return ContainerUtil.mapNotNull(this.getMappingUrls(), STRING_MAPPER);
    }

    @Override
    public List<String> getConsumes() {
        return ContainerUtil.mapNotNull((Collection)((Collection)REQUEST_MAPPING_ANNO_META.getAttribute(this.getPsiElement(), CONSUMES_META)), STRING_MAPPER);
    }

    @Override
    public List<String> getProduces() {
        return ContainerUtil.mapNotNull((Collection)((Collection)REQUEST_MAPPING_ANNO_META.getAttribute(this.getPsiElement(), PRODUCES_META)), STRING_MAPPER);
    }

    @Override
    public List<String> getParams() {
        return ContainerUtil.mapNotNull((Collection)((Collection)REQUEST_MAPPING_ANNO_META.getAttribute(this.getPsiElement(), PARAMS_META)), STRING_MAPPER);
    }

    @Override
    public List<String> getHeaders() {
        return ContainerUtil.mapNotNull((Collection)((Collection)REQUEST_MAPPING_ANNO_META.getAttribute(this.getPsiElement(), HEADERS_META)), STRING_MAPPER);
    }

    protected List<PsiTarget> getPomTargets() {
        return ContainerUtil.mapNotNull(this.getMappingUrls(), this.myMapping);
    }

    static /* synthetic */ JamAnnotationMeta access$100() {
        return REQUEST_MAPPING_ANNO_META;
    }

    private static class RequestMappingMimetypeConverter
    extends JamConverter<String> {
        private static String[] DEFAULT_MIME_TYPES = new String[]{"application/json", "text/html", "text/plain"};

        private RequestMappingMimetypeConverter() {
        }

        @Nullable
        public String fromString(@Nullable String s, JamStringAttributeElement<String> context) {
            return s;
        }

        @NotNull
        public PsiReference[] createReferences(JamStringAttributeElement<String> context) {
            PsiLiteral psiLiteral = context.getPsiLiteral();
            if (psiLiteral == null) {
                if (PsiReference.EMPTY_ARRAY == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/web/mvc/jam/SpringMVCRequestMapping$RequestMappingMimetypeConverter", "createReferences"));
                }
                return PsiReference.EMPTY_ARRAY;
            }
            PsiReference[] psiReferenceArray = new PsiReference[]{new PsiReferenceBase.Immediate<PsiElement>((PsiElement)psiLiteral, (PsiElement)psiLiteral){

                @NotNull
                public Object[] getVariants() {
                    Object[] objectArray = DEFAULT_MIME_TYPES;
                    if (objectArray == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/web/mvc/jam/SpringMVCRequestMapping$RequestMappingMimetypeConverter$1", "getVariants"));
                    }
                    return objectArray;
                }
            }};
            if (psiReferenceArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/web/mvc/jam/SpringMVCRequestMapping$RequestMappingMimetypeConverter", "createReferences"));
            }
            return psiReferenceArray;
        }

        static {
            Arrays.sort(DEFAULT_MIME_TYPES);
        }
    }

    public static abstract class MethodMapping
    extends SpringMVCRequestMapping<PsiMethod> {
        private static final JamChildrenQuery<SpringMVCModelAttribute> MODEL_ATTRIBUTE_JAM_CHILDREN_QUERY = JamChildrenQuery.annotatedParameters((JamAnnotationMeta)SpringMVCModelAttribute.ANNOTATION_META, SpringMVCModelAttribute.class);
        private static final JamChildrenQuery<MVCPathVariable> PATH_VARIABLE_JAM_CHILDREN_QUERY = JamChildrenQuery.annotatedParameters((JamAnnotationMeta)MVCPathVariable.ANNOTATION_META, MVCPathVariable.META);
        public static final JamMethodMeta<MethodMapping> META = new JamMethodMeta(MethodMapping.class).addAnnotation(SpringMVCRequestMapping.access$100()).addChildrenQuery(MODEL_ATTRIBUTE_JAM_CHILDREN_QUERY).addChildrenQuery(PATH_VARIABLE_JAM_CHILDREN_QUERY).addPomTargetProducer((methodMapping, pomTargetConsumer) -> {
            for (PsiTarget target : methodMapping.getPomTargets()) {
                pomTargetConsumer.consume((Object)target);
            }
        });

        @Override
        public List<SpringMVCModelAttribute> getModelAttributes() {
            return MODEL_ATTRIBUTE_JAM_CHILDREN_QUERY.findChildren(PsiElementRef.real(this.getPsiElement()));
        }

        public List<MVCPathVariable> getPathVariables() {
            return PATH_VARIABLE_JAM_CHILDREN_QUERY.findChildren(PsiElementRef.real(this.getPsiElement()));
        }

        @Override
        public RequestMethod[] getMethods() {
            RequestMethod[] methods = super.getMethods();
            SpringMVCRequestMapping<PsiClass> classLevelMapping = this.getClassLevelMapping();
            if (classLevelMapping == null) {
                return methods;
            }
            return (RequestMethod[])ArrayUtil.mergeArrays((Object[])classLevelMapping.getMethods(), (Object[])methods);
        }

        @Nullable
        private SpringMVCRequestMapping<PsiClass> getClassLevelMapping() {
            PsiClass containingClass = (PsiClass)PsiTreeUtil.getParentOfType(this.getPsiElement(), PsiClass.class);
            if (containingClass == null) {
                return null;
            }
            return (SpringMVCRequestMapping)JamService.getJamService((Project)containingClass.getProject()).getJamElement((PsiElement)containingClass, new JamMemberMeta[]{ClassMapping.META});
        }
    }

    public static abstract class ClassMapping
    extends SpringMVCRequestMapping<PsiClass> {
        private static final JamChildrenQuery<SpringMVCModelAttribute> ALL_METHODS_MODEL_ATTRIBUTE_JAM_CHILDREN_QUERY = JamChildrenQuery.annotatedMethods((JamAnnotationMeta)SpringMVCModelAttribute.ANNOTATION_META, SpringMVCModelAttribute.class);
        public static final JamClassMeta<ClassMapping> META = new JamClassMeta(ClassMapping.class).addAnnotation(SpringMVCRequestMapping.access$100()).addChildrenQuery(ALL_METHODS_MODEL_ATTRIBUTE_JAM_CHILDREN_QUERY).addPomTargetProducer((classMapping, pomTargetConsumer) -> {
            for (PsiTarget target : classMapping.getPomTargets()) {
                pomTargetConsumer.consume((Object)target);
            }
        });

        @Override
        public List<SpringMVCModelAttribute> getModelAttributes() {
            return ALL_METHODS_MODEL_ATTRIBUTE_JAM_CHILDREN_QUERY.findChildren(PsiElementRef.real(this.getPsiElement()));
        }
    }
}

