/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.web.mvc.model;

import com.intellij.codeInspection.dataFlow.StringExpressionHelper;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.JavaRecursiveElementVisitor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.impl.light.LightMethodBuilder;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.spring.contexts.model.SpringModel;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.web.mvc.model.CodeConfigurationParserBase;
import com.intellij.spring.web.mvc.views.BeanNameViewResolverFactory;
import com.intellij.spring.web.mvc.views.UrlBasedViewResolver;
import com.intellij.spring.web.mvc.views.ViewResolver;
import com.intellij.spring.web.mvc.views.ViewResolverFactory;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

class CodeConfigurationViewResolverParser
extends CodeConfigurationParserBase {
    private final List<ViewResolver> myViewResolvers;

    CodeConfigurationViewResolverParser(SpringModel servletModel, SpringBeanPointer configBeanPointer, List<ViewResolver> resolvers) {
        super(servletModel, configBeanPointer);
        this.myViewResolvers = resolvers;
    }

    @Override
    protected boolean parseConfigurationClass(@NotNull PsiClass configClass) {
        if (configClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configClass", "com/intellij/spring/web/mvc/model/CodeConfigurationViewResolverParser", "parseConfigurationClass"));
        }
        LightMethodBuilder configureViewResolversMethodTemplate = new LightMethodBuilder(configClass.getManager(), "configureViewResolvers").setModifiers(new String[]{"protected"}).setMethodReturnType((PsiType)PsiType.VOID).addParameter("registry", "org.springframework.web.servlet.config.annotation.ViewResolverRegistry");
        PsiMethod configureViewResolvers = configClass.findMethodBySignature((PsiMethod)configureViewResolversMethodTemplate, false);
        if (configureViewResolvers == null) {
            return false;
        }
        final ViewResolverFactory[] viewResolverFactoryEPs = (ViewResolverFactory[])Extensions.getExtensions(ViewResolverFactory.EP_NAME);
        configureViewResolvers.accept((PsiElementVisitor)new JavaRecursiveElementVisitor(){

            public void visitMethodCallExpression(PsiMethodCallExpression expression) {
                super.visitMethodCallExpression(expression);
                PsiReferenceExpression methodExpression = expression.getMethodExpression();
                PsiExpression qualifierExpression = methodExpression.getQualifierExpression();
                if (qualifierExpression == null) {
                    return;
                }
                PsiType qualifierType = qualifierExpression.getType();
                PsiClass qualifierClass = PsiTypesUtil.getPsiClass((PsiType)qualifierType);
                if (qualifierClass == null || !"org.springframework.web.servlet.config.annotation.ViewResolverRegistry".equals(qualifierClass.getQualifiedName())) {
                    return;
                }
                String methodName = methodExpression.getReferenceName();
                if ("jsp".equals(methodName)) {
                    CodeConfigurationViewResolverParser.this.handleJsp(expression);
                } else if ("beanName".equals(methodName)) {
                    CodeConfigurationViewResolverParser.this.handleBeanName();
                } else {
                    for (ViewResolverFactory viewResolver : viewResolverFactoryEPs) {
                        Set<ViewResolver> viewResolvers = viewResolver.handleViewResolverRegistry(methodName, expression, CodeConfigurationViewResolverParser.this.myServletModel);
                        if (viewResolvers.isEmpty()) continue;
                        CodeConfigurationViewResolverParser.this.myViewResolvers.addAll(viewResolvers);
                        break;
                    }
                }
            }
        });
        return true;
    }

    private void handleJsp(PsiMethodCallExpression expression) {
        PsiExpression[] arguments = expression.getArgumentList().getExpressions();
        if (arguments.length == 0) {
            this.myViewResolvers.add(new UrlBasedViewResolver("/WEB-INF/", ".jsp"));
            return;
        }
        if (arguments.length == 2) {
            Pair prefixExpr = StringExpressionHelper.evaluateExpression((PsiElement)arguments[0]);
            Pair suffixExpr = StringExpressionHelper.evaluateExpression((PsiElement)arguments[1]);
            if (prefixExpr != null && suffixExpr != null) {
                this.myViewResolvers.add(new UrlBasedViewResolver((String)prefixExpr.getSecond(), (String)suffixExpr.getSecond()));
            }
        }
    }

    private void handleBeanName() {
        this.myViewResolvers.add(new BeanNameViewResolverFactory.BeanNameViewResolver());
    }
}

