/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.web.mvc.model;

import com.intellij.javaee.web.ServletMappingInfo;
import com.intellij.javaee.web.facet.WebFacet;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.spring.contexts.model.SpringModel;
import com.intellij.spring.facet.SpringFacet;
import com.intellij.spring.facet.SpringFileSet;
import com.intellij.spring.model.utils.SpringCommonUtils;
import com.intellij.spring.web.mvc.jam.RequestMethod;
import com.intellij.spring.web.mvc.model.SpringMVCModel;
import com.intellij.spring.web.mvc.views.ViewResolver;
import com.intellij.util.ui.UIUtil;
import java.util.Collection;

public class DumpSpringMVCModelAction
extends AnAction {
    public void update(AnActionEvent e) {
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        boolean hasSpring = project != null && SpringCommonUtils.hasSpringFacets((Project)project);
        e.getPresentation().setEnabled(hasSpring);
    }

    public void actionPerformed(AnActionEvent e) {
        final Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        if (project == null) {
            return;
        }
        Runnable process = () -> {
            String dump = (String)ApplicationManager.getApplication().runReadAction((Computable)new Computable<String>(){

                public String compute() {
                    return DumpSpringMVCModelAction.getMvcModelDump(project);
                }
            });
            UIUtil.invokeLaterIfNeeded(() -> Messages.showMultilineInputDialog((Project)project, (String)"", (String)"Spring MVC Model Dump", (String)dump, null, null));
        };
        ProgressManager.getInstance().runProcessWithProgressSynchronously(process, "Gathering Spring MVC Models", true, project);
    }

    private static String getMvcModelDump(Project project) {
        ProgressIndicator pi = ProgressManager.getInstance().getProgressIndicator();
        Module[] modules = ModuleManager.getInstance((Project)project).getSortedModules();
        StringBuilder dump = new StringBuilder();
        int processedModules = 0;
        for (Module module : modules) {
            String name = module.getName();
            dump.append(name).append(" ").append(StringUtil.repeatSymbol((char)'=', (int)Math.max(1, 100 - name.length()))).append("\n");
            SpringFacet springFacet = SpringFacet.getInstance((Module)module);
            if (springFacet == null) {
                dump.append("no Spring facet");
            } else {
                Collection webFacets = WebFacet.getInstances((Module)module);
                if (webFacets.isEmpty()) {
                    dump.append("no Web facets");
                } else {
                    DumpSpringMVCModelAction.dumpModule(dump, springFacet, webFacets);
                }
            }
            dump.append("\n\n");
            pi.setFraction((double)(++processedModules) / (double)modules.length);
        }
        return dump.toString();
    }

    private static void dumpModule(StringBuilder dump, SpringFacet springFacet, Collection<WebFacet> webFacets) {
        SpringFileSet fileSet;
        SpringMVCModel model = SpringMVCModel.getModel(webFacets.iterator().next(), springFacet);
        if (model == null) {
            dump.append("No Spring MVC model");
            return;
        }
        dump.append("Servlet models:\n");
        Collection<SpringModel> servletModels = model.getServletModels();
        for (SpringModel servletModel : servletModels) {
            fileSet = servletModel.getFileSet();
            assert (fileSet != null) : servletModel;
            dump.append(" ").append(fileSet.getId());
        }
        dump.append("\nRoot models:\n");
        for (SpringModel allModel : model.getAllModels()) {
            if (servletModels.contains(allModel)) continue;
            fileSet = allModel.getFileSet();
            assert (fileSet != null) : allModel;
            dump.append(" ").append(fileSet.getId());
        }
        dump.append("\n\nServlet mapping:\n");
        ServletMappingInfo info = model.getServletMappingInfo();
        if (info == null) {
            dump.append("NONE\n");
        } else {
            dump.append("'").append(info.getUrlPattern()).append("' ").append(info.getServlet().getServletName().getStringValue()).append(" (").append(info.getServlet().getContainingFile()).append(")");
        }
        dump.append("\n\nView Resolvers:\n");
        dump.append(" hasUnknown: ").append(model.hasUnknownResolvers());
        for (ViewResolver resolver : model.getViewResolvers()) {
            dump.append("\n ").append(resolver.toString());
        }
        dump.append("\n\nURLs:");
        for (SpringMVCModel.Variant variant : model.getAllUrls()) {
            PsiElement resolve = variant.psiElementPointer.getPsiElement();
            PsiFile finalResolve = resolve != null ? resolve.getContainingFile() : null;
            dump.append("\n").append(variant.lookupString).append(" ").append(RequestMethod.getDisplay(variant.method)).append(" ").append(finalResolve);
        }
    }
}

