/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.web.mvc.model;

import com.intellij.jam.JamElement;
import com.intellij.jam.JamService;
import com.intellij.jam.JamStringAttributeElement;
import com.intellij.jam.reflect.JamMemberMeta;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.pom.PomTarget;
import com.intellij.pom.PomTargetPsiElement;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.spring.CommonSpringModel;
import com.intellij.spring.contexts.model.SpringModel;
import com.intellij.spring.model.CommonSpringBean;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.model.SpringBeanPsiTarget;
import com.intellij.spring.model.SpringModelSearchParameters;
import com.intellij.spring.model.jam.JamStringAttributeElementPsiElementPointer;
import com.intellij.spring.model.utils.SpringCommonUtils;
import com.intellij.spring.model.utils.SpringModelSearchers;
import com.intellij.spring.model.xml.beans.Prop;
import com.intellij.spring.model.xml.beans.SpringBean;
import com.intellij.spring.model.xml.beans.SpringEntry;
import com.intellij.spring.model.xml.beans.SpringProperty;
import com.intellij.spring.model.xml.beans.SpringPropertyDefinition;
import com.intellij.spring.model.xml.mvc.ViewControllerBase;
import com.intellij.spring.web.mvc.jam.RequestMapping;
import com.intellij.spring.web.mvc.jam.RequestMethod;
import com.intellij.spring.web.mvc.jam.SpringMVCRequestMapping;
import com.intellij.spring.web.mvc.model.CodeConfigurationViewControllerParser;
import com.intellij.spring.web.mvc.model.SpringMVCRequestMappings;
import com.intellij.xml.util.PsiElementPointer;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.jetbrains.annotations.Nullable;

class SpringMVCRequestMappingsCollector {
    private final Module myModule;
    private final Collection<SpringModel> myModels;
    private final SpringMVCRequestMappings myRequestMappings = new SpringMVCRequestMappings();
    private static final Key<CachedValue<List<SpringMVCRequestMapping.MethodMapping>>> REQUEST_MAPPINGS_CACHE = Key.create((String)"REQUEST_MAPPINGS_CACHE");

    SpringMVCRequestMappingsCollector(Module module, Collection<SpringModel> models) {
        this.myModule = module;
        this.myModels = models;
    }

    SpringMVCRequestMappings collect() {
        this.doCollect();
        return this.myRequestMappings;
    }

    private void doCollect() {
        SpringModelSearchParameters.BeanClass controllerClassSearchParams = this.createSearchParams("org.springframework.web.servlet.mvc.Controller");
        SpringModelSearchParameters.BeanClass simpleUrlMappingSearchParams = this.createSearchParams("org.springframework.web.servlet.handler.SimpleUrlHandlerMapping");
        for (SpringModel model : this.myModels) {
            List list = controllerClassSearchParams == null ? Collections.emptyList() : SpringModelSearchers.findBeans((CommonSpringModel)model, (SpringModelSearchParameters.BeanClass)controllerClassSearchParams);
            Iterator<Object> iterator = list.iterator();
            while (iterator.hasNext()) {
                CommonSpringBean bean;
                PomTarget target;
                SpringBeanPointer beanPointer = (SpringBeanPointer)iterator.next();
                PsiElement element = beanPointer.getPsiElement();
                if (element instanceof PomTargetPsiElement && (target = ((PomTargetPsiElement)element).getTarget()) instanceof SpringBeanPsiTarget && (bean = ((SpringBeanPsiTarget)target).getSpringBean()) instanceof ViewControllerBase) {
                    ViewControllerBase viewController = (ViewControllerBase)bean;
                    String path = viewController.getPath().getStringValue();
                    if (path == null) continue;
                    this.myRequestMappings.addUrl(path, (PsiElementPointer)beanPointer, new RequestMethod[0]);
                    continue;
                }
                String name = beanPointer.getName();
                if (name == null) continue;
                this.myRequestMappings.addUrl(name, (PsiElementPointer)beanPointer, new RequestMethod[0]);
            }
            List simpleMappings = simpleUrlMappingSearchParams == null ? Collections.emptyList() : SpringModelSearchers.findBeans((CommonSpringModel)model, (SpringModelSearchParameters.BeanClass)simpleUrlMappingSearchParams);
            for (SpringBeanPointer mapping : simpleMappings) {
                SpringPropertyDefinition mappings;
                Object springBeanPointer;
                CommonSpringBean springBean = mapping.getSpringBean();
                if (!(springBean instanceof SpringBean)) continue;
                SpringPropertyDefinition urlMap = ((SpringBean)springBean).getProperty("urlMap");
                if (urlMap instanceof SpringProperty) {
                    for (SpringEntry entry : ((SpringProperty)urlMap).getMap().getEntries()) {
                        String key = (String)entry.getKeyAttr().getValue();
                        if (key == null || (springBeanPointer = entry.getRefValue()) == null) continue;
                        this.myRequestMappings.addUrl(key, (PsiElementPointer)springBeanPointer.getBasePointer(), new RequestMethod[0]);
                    }
                }
                if ((mappings = ((SpringBean)springBean).getProperty("mappings")) == null) continue;
                String value = mappings.getValueAsString();
                if (value != null) {
                    try {
                        Properties properties = new Properties();
                        properties.load(new ByteArrayInputStream(value.getBytes()));
                        springBeanPointer = properties.entrySet().iterator();
                        while (springBeanPointer.hasNext()) {
                            Map.Entry entry = (Map.Entry)springBeanPointer.next();
                            Object beanName = entry.getValue();
                            SpringBeanPointer bean = SpringModelSearchers.findBean((CommonSpringModel)model, (String)((String)beanName));
                            if (bean == null) continue;
                            this.myRequestMappings.addUrl((String)entry.getKey(), (PsiElementPointer)bean, new RequestMethod[0]);
                        }
                        continue;
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
                if (!(mappings instanceof SpringProperty)) continue;
                SpringProperty holder = (SpringProperty)mappings;
                springBeanPointer = holder.getProps().getProps().iterator();
                while (springBeanPointer.hasNext()) {
                    String url;
                    Prop prop = (Prop)springBeanPointer.next();
                    Object controllerBean = prop.getValue();
                    if (!(controllerBean instanceof SpringBeanPointer) || (url = prop.getKey().getStringValue()) == null) continue;
                    this.myRequestMappings.addUrl(url, (PsiElementPointer)((SpringBeanPointer)controllerBean), new RequestMethod[0]);
                }
            }
        }
        JamService jamService = JamService.getJamService((Project)this.myModule.getProject());
        List requestMappings = (List)CachedValuesManager.getManager((Project)this.myModule.getProject()).getCachedValue((UserDataHolder)this.myModule, REQUEST_MAPPINGS_CACHE, () -> {
            GlobalSearchScope scope = GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)this.myModule, (boolean)false);
            List mappings = jamService.getJamMethodElements(SpringMVCRequestMapping.MethodMapping.META, "org.springframework.web.bind.annotation.RequestMapping", scope);
            return CachedValueProvider.Result.create((Object)mappings, (Object[])new Object[]{PsiModificationTracker.JAVA_STRUCTURE_MODIFICATION_COUNT});
        }, false);
        for (SpringMVCRequestMapping.MethodMapping mapping : requestMappings) {
            PsiMethod psiMethod = (PsiMethod)mapping.getPsiElement();
            PsiClass psiClass = psiMethod.getContainingClass();
            assert (psiClass != null);
            SpringMVCRequestMapping.ClassMapping classMapping = (SpringMVCRequestMapping.ClassMapping)jamService.getJamElement((PsiElement)psiClass, new JamMemberMeta[]{SpringMVCRequestMapping.ClassMapping.META});
            RequestMethod[] method = mapping.getMethods();
            List<JamStringAttributeElement<String>> urls = mapping.getMappingUrls();
            if (urls.isEmpty() && classMapping != null) {
                this.processRequestMapping(mapping, classMapping, null, null, method);
            }
            for (JamStringAttributeElement<String> url : urls) {
                String urlValue = url.getStringValue();
                if (classMapping != null) {
                    this.processRequestMapping(mapping, classMapping, url, urlValue, method);
                    continue;
                }
                if (urlValue == null) continue;
                this.myRequestMappings.addUrl(urlValue, (PsiElementPointer)new JamStringAttributeElementPsiElementPointer(url, (JamElement)mapping), method);
            }
        }
        SpringModelSearchParameters.BeanClass mvcConfigurationSupportSearchParameters = this.createSearchParams("org.springframework.web.servlet.config.annotation.WebMvcConfigurationSupport");
        if (mvcConfigurationSupportSearchParameters != null) {
            for (SpringModel model : this.myModels) {
                SpringBeanPointer pointer;
                CodeConfigurationViewControllerParser parser;
                boolean configured;
                Iterator iterator = SpringModelSearchers.findBeans((CommonSpringModel)model, (SpringModelSearchParameters.BeanClass)mvcConfigurationSupportSearchParameters).iterator();
                while (iterator.hasNext() && !(configured = (parser = new CodeConfigurationViewControllerParser(model, pointer = (SpringBeanPointer)iterator.next(), this.myRequestMappings)).collect())) {
                }
            }
        }
    }

    @Nullable
    private SpringModelSearchParameters.BeanClass createSearchParams(String fqn) {
        PsiClass psiClass = SpringCommonUtils.findLibraryClass((Module)this.myModule, (String)fqn);
        if (psiClass == null) {
            return null;
        }
        return SpringModelSearchParameters.byClass((PsiClass)psiClass).withInheritors();
    }

    private void processRequestMapping(RequestMapping<?> mapping, SpringMVCRequestMapping.ClassMapping classMapping, @Nullable JamStringAttributeElement<String> url, @Nullable String urlValue, RequestMethod ... method) {
        for (JamStringAttributeElement<String> classUrl : classMapping.getMappingUrls()) {
            String baseUrl = classUrl.getStringValue();
            if (baseUrl != null && urlValue == null) {
                this.myRequestMappings.addUrl(baseUrl, (PsiElementPointer)new JamStringAttributeElementPsiElementPointer(classUrl, (JamElement)classMapping), method);
                continue;
            }
            if (baseUrl == null) {
                baseUrl = "";
            }
            StringBuilder builder = new StringBuilder(baseUrl);
            if (urlValue != null) {
                if (!baseUrl.endsWith("/") && !urlValue.startsWith("/")) {
                    builder.append('/');
                }
                builder.append(urlValue);
            }
            this.myRequestMappings.addUrl(builder.toString(), (PsiElementPointer)new JamStringAttributeElementPsiElementPointer(url, mapping), method);
        }
    }
}

