/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.web.mvc.navigation;

import com.intellij.navigation.GotoRelatedItem;
import com.intellij.navigation.GotoRelatedProvider;
import com.intellij.openapi.util.Comparing;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassOwner;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.jsp.BaseJspUtil;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.web.mvc.SpringControllerClassInfo;
import com.intellij.spring.web.mvc.model.SpringMVCModel;
import com.intellij.spring.web.mvc.views.ViewResolver;
import com.intellij.util.SmartList;
import com.intellij.util.containers.MultiMap;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class SpringMvcViewGotoRelatedProvider
extends GotoRelatedProvider {
    private static final String GROUP_NAME = "Spring MVC";

    @NotNull
    public List<? extends GotoRelatedItem> getItems(@NotNull PsiElement context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/spring/web/mvc/navigation/SpringMvcViewGotoRelatedProvider", "getItems"));
        }
        PsiFile psiFile = context.getContainingFile();
        if (psiFile == null) {
            List list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/web/mvc/navigation/SpringMvcViewGotoRelatedProvider", "getItems"));
            }
            return list;
        }
        if (psiFile instanceof PsiClassOwner && !BaseJspUtil.isInJspFile((PsiFile)psiFile)) {
            List list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/web/mvc/navigation/SpringMvcViewGotoRelatedProvider", "getItems"));
            }
            return list;
        }
        SpringMVCModel model = SpringMVCModel.getModel(context);
        if (model == null) {
            List list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/web/mvc/navigation/SpringMvcViewGotoRelatedProvider", "getItems"));
            }
            return list;
        }
        List<ViewResolver> resolvers = model.getViewResolvers();
        if (resolvers.isEmpty()) {
            List list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/web/mvc/navigation/SpringMvcViewGotoRelatedProvider", "getItems"));
            }
            return list;
        }
        SmartList items = new SmartList();
        for (SpringBeanPointer pointer : model.getControllers()) {
            PsiClass beanClass = pointer.getBeanClass();
            if (beanClass == null) continue;
            SpringControllerClassInfo info = SpringControllerClassInfo.getInfo(beanClass);
            MultiMap<String, PsiMethod> views = info.getViews(null);
            for (String view : views.keySet()) {
                for (ViewResolver resolver : resolvers) {
                    PsiElement psiElement = resolver.resolveFinalView(view, model);
                    if (psiElement == null || !Comparing.equal((Object)psiFile.getVirtualFile(), (Object)psiElement.getContainingFile().getVirtualFile())) continue;
                    for (PsiMethod method : views.get((Object)view)) {
                        items.add(new GotoRelatedItem((PsiElement)method, GROUP_NAME));
                    }
                }
            }
        }
        SmartList smartList = items;
        if (smartList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/web/mvc/navigation/SpringMvcViewGotoRelatedProvider", "getItems"));
        }
        return smartList;
    }
}

