/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.web.mvc.pathVariables;

import com.intellij.codeInsight.daemon.EmptyResolveMessageProvider;
import com.intellij.jam.JamService;
import com.intellij.jam.JamStringAttributeElement;
import com.intellij.jam.reflect.JamMemberMeta;
import com.intellij.openapi.project.Project;
import com.intellij.patterns.PsiJavaElementPattern;
import com.intellij.patterns.PsiJavaPatterns;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLiteral;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.spring.web.mvc.jam.RequestMapping;
import com.intellij.spring.web.mvc.jam.SpringMVCRequestMapping;
import com.intellij.spring.web.mvc.pathVariables.MVCPathVariableReference;
import com.intellij.util.ArrayUtil;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class MVCRequestMappingReference
extends PsiReferenceBase<PsiLiteralExpression>
implements EmptyResolveMessageProvider {
    static final PsiJavaElementPattern.Capture<PsiLiteralExpression> PATTERN = (PsiJavaElementPattern.Capture)PsiJavaPatterns.literalExpression().annotationParam("org.springframework.web.bind.annotation.PathVariable");

    MVCRequestMappingReference(PsiLiteralExpression psiElement) {
        super((PsiElement)psiElement);
    }

    @Nullable
    public PsiElement resolve() {
        ResolveResult[] results;
        CommonProcessors.FindFirstProcessor<MVCPathVariableReference> processor = new CommonProcessors.FindFirstProcessor<MVCPathVariableReference>(){

            protected boolean accept(MVCPathVariableReference reference) {
                return reference.getValue().equals(MVCRequestMappingReference.this.getValue());
            }
        };
        this.processPathVariables((Processor<MVCPathVariableReference>)processor);
        MVCPathVariableReference value = (MVCPathVariableReference)((Object)processor.getFoundValue());
        if (value == null) {
            return null;
        }
        for (ResolveResult result : results = value.multiResolve(false)) {
            PsiElement element = result.getElement();
            if (element == null) continue;
            return element;
        }
        return null;
    }

    @NotNull
    public Object[] getVariants() {
        CommonProcessors.CollectProcessor processor = new CommonProcessors.CollectProcessor();
        this.processPathVariables((Processor<MVCPathVariableReference>)processor);
        SmartList variants = new SmartList();
        for (MVCPathVariableReference reference : processor.getResults()) {
            variants.add(reference.getValue());
        }
        Object[] objectArray = ArrayUtil.toStringArray((Collection)variants);
        if (objectArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/web/mvc/pathVariables/MVCRequestMappingReference", "getVariants"));
        }
        return objectArray;
    }

    @NotNull
    public String getUnresolvedMessagePattern() {
        if ("Cannot resolve path variable ''{0}'' in @RequestMapping" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/web/mvc/pathVariables/MVCRequestMappingReference", "getUnresolvedMessagePattern"));
        }
        return "Cannot resolve path variable ''{0}'' in @RequestMapping";
    }

    private void processPathVariables(Processor<MVCPathVariableReference> processor) {
        PsiLiteralExpression element = (PsiLiteralExpression)this.getElement();
        PsiModifierListOwner method = (PsiModifierListOwner)PsiTreeUtil.getParentOfType((PsiElement)element, PsiMethod.class);
        boolean processed = MVCRequestMappingReference.processModifierListOwner(processor, method, SpringMVCRequestMapping.MethodMapping.META);
        if (!processed) {
            return;
        }
        PsiModifierListOwner clazz = (PsiModifierListOwner)PsiTreeUtil.getParentOfType((PsiElement)method, PsiClass.class);
        MVCRequestMappingReference.processModifierListOwner(processor, clazz, SpringMVCRequestMapping.ClassMapping.META);
    }

    private static boolean processModifierListOwner(Processor<MVCPathVariableReference> processor, @Nullable PsiModifierListOwner modifierListOwner, JamMemberMeta<? extends PsiMember, ? extends RequestMapping> meta) {
        if (modifierListOwner == null) {
            return false;
        }
        PsiModifierList modifierList = modifierListOwner.getModifierList();
        if (modifierList == null) {
            return false;
        }
        RequestMapping requestMapping = (RequestMapping)JamService.getJamService((Project)modifierList.getProject()).getJamElement((PsiElement)modifierListOwner, new JamMemberMeta[]{meta});
        if (requestMapping == null) {
            return true;
        }
        for (JamStringAttributeElement<String> urlAttribute : requestMapping.getMappingUrls()) {
            PsiLiteral psiLiteral = urlAttribute.getPsiLiteral();
            if (psiLiteral == null) continue;
            for (PsiReference reference : psiLiteral.getReferences()) {
                boolean processed;
                if (!(reference instanceof MVCPathVariableReference) || (processed = processor.process((Object)((MVCPathVariableReference)reference)))) continue;
                return false;
            }
        }
        return true;
    }
}

