/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.web.mvc.tiles;

import com.intellij.javaee.web.facet.WebFacet;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.psi.xml.XmlFile;
import com.intellij.spring.contexts.model.SpringModel;
import com.intellij.spring.facet.SpringFacet;
import com.intellij.spring.web.mvc.model.SpringMVCModel;
import com.intellij.spring.web.mvc.tiles.TilesViewResolver;
import com.intellij.struts.StrutsPluginDomFactory;
import com.intellij.struts.StrutsProjectComponent;
import com.intellij.struts.TilesModel;
import com.intellij.struts.TilesModelProvider;
import com.intellij.struts.psi.TilesModelImpl;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import com.intellij.util.xml.DomFileElement;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class MVCTilesModelProvider
implements TilesModelProvider {
    @NotNull
    public Collection<TilesModel> computeModels(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/spring/web/mvc/tiles/MVCTilesModelProvider", "computeModels"));
        }
        SpringFacet springFacet = SpringFacet.getInstance((Module)module);
        if (springFacet == null) {
            List<TilesModel> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/web/mvc/tiles/MVCTilesModelProvider", "computeModels"));
            }
            return list;
        }
        Collection webFacets = WebFacet.getInstances((Module)module);
        if (webFacets.isEmpty()) {
            List<TilesModel> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/web/mvc/tiles/MVCTilesModelProvider", "computeModels"));
            }
            return list;
        }
        SmartList models = new SmartList();
        Processor processor = arg_0 -> MVCTilesModelProvider.lambda$computeModels$0(module, (List)models, arg_0);
        for (WebFacet webFacet : webFacets) {
            SpringMVCModel springMVCModel = SpringMVCModel.getModel(webFacet, springFacet);
            if (springMVCModel == null) continue;
            Collection<SpringModel> servletModels = springMVCModel.getServletModels();
            for (SpringModel servletModel : servletModels) {
                TilesViewResolver.processTiles(servletModel, (Processor<Set<XmlFile>>)processor);
            }
        }
        SmartList smartList = models;
        if (smartList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/web/mvc/tiles/MVCTilesModelProvider", "computeModels"));
        }
        return smartList;
    }

    private static /* synthetic */ boolean lambda$computeModels$0(@NotNull Module module, List models, Set definitions) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/spring/web/mvc/tiles/MVCTilesModelProvider", "lambda$computeModels$0"));
        }
        StrutsPluginDomFactory factory = StrutsProjectComponent.getInstance((Project)module.getProject()).getTilesFactory();
        DomFileElement domFileElement = factory.createMergedModelRoot(definitions);
        if (domFileElement != null) {
            TilesModelImpl tilesModel = new TilesModelImpl(definitions, domFileElement, "mvcTilesModel");
            models.add(tilesModel);
        }
        return true;
    }
}

