/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.web.mvc.tiles;

import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInspection.dataFlow.StringExpressionHelper;
import com.intellij.javaee.web.WebUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiType;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.jsp.WebDirectoryElement;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PropertyUtil;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.util.PsiUtilBase;
import com.intellij.psi.xml.XmlFile;
import com.intellij.spring.CommonSpringModel;
import com.intellij.spring.contexts.model.SpringModel;
import com.intellij.spring.model.CommonSpringBean;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.model.SpringModelSearchParameters;
import com.intellij.spring.model.jam.javaConfig.ContextJavaBean;
import com.intellij.spring.model.utils.SpringCommonUtils;
import com.intellij.spring.model.utils.SpringModelSearchers;
import com.intellij.spring.model.utils.SpringPropertyUtils;
import com.intellij.spring.model.xml.beans.ListOrSet;
import com.intellij.spring.model.xml.beans.SpringBean;
import com.intellij.spring.model.xml.beans.SpringProperty;
import com.intellij.spring.model.xml.beans.SpringPropertyDefinition;
import com.intellij.spring.model.xml.beans.SpringValue;
import com.intellij.spring.model.xml.mvc.TilesConfigurer;
import com.intellij.spring.model.xml.mvc.TilesDefinitions;
import com.intellij.spring.web.SpringWebConstants;
import com.intellij.spring.web.mvc.model.SpringMVCModel;
import com.intellij.spring.web.mvc.views.ViewResolver;
import com.intellij.struts.StrutsPluginDomFactory;
import com.intellij.struts.StrutsProjectComponent;
import com.intellij.struts.dom.tiles.Definition;
import com.intellij.struts.dom.tiles.Put;
import com.intellij.util.ObjectUtils;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.DomAnchor;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomFileElement;
import com.intellij.util.xml.DomManager;
import com.intellij.util.xml.DomService;
import com.intellij.util.xml.DomUtil;
import icons.StrutsApiIcons;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TilesViewResolver
extends ViewResolver {
    private final SpringModel myModel;

    TilesViewResolver(SpringModel model) {
        this.myModel = model;
    }

    @Override
    public PsiElement resolveView(String viewName, SpringMVCModel springMVCModel) {
        Ref ref = new Ref();
        TilesViewResolver.processTiles((Processor<Map<String, DomAnchor<Definition>>>)((Processor)stringDomAnchorMap -> {
            PsiElement psiElement;
            DomAnchor anchor = (DomAnchor)stringDomAnchorMap.get(viewName);
            if (anchor != null && (psiElement = anchor.getPsiElement()) != null) {
                ref.set((Object)psiElement);
                return false;
            }
            return true;
        }), this.myModel);
        return (PsiElement)ref.get();
    }

    @Override
    public PsiElement resolveFinalView(String viewName, SpringMVCModel springMVCModel) {
        Ref ref = new Ref();
        TilesViewResolver.processTiles((Processor<Map<String, DomAnchor<Definition>>>)((Processor)stringDomAnchorMap -> {
            Definition definition;
            PsiFile element;
            DomAnchor anchor = (DomAnchor)stringDomAnchorMap.get(viewName);
            if (anchor != null && (element = TilesViewResolver.processDefinition(definition = (Definition)anchor.retrieveDomElement(), springMVCModel)) != null) {
                ref.set((Object)element);
                return false;
            }
            return true;
        }), this.myModel);
        return (PsiElement)ref.get();
    }

    @Nullable
    private static PsiFile processDefinition(Definition definition, SpringMVCModel context) {
        if (definition != null) {
            List puts = definition.getAllPuts();
            for (Put put : puts) {
                WebDirectoryElement element;
                Definition inner = put.getDefinition();
                PsiFile directoryElement = TilesViewResolver.processDefinition(inner, context);
                if (directoryElement != null) {
                    return directoryElement;
                }
                String value = put.getValue();
                if (StringUtil.isEmpty((String)value)) {
                    value = put.getAttributeValue().getStringValue();
                }
                if (value == null || !StringUtil.isNotEmpty((String)value) || (element = WebUtil.getWebUtil().findWebDirectoryElement(value, context.getWebFacet())) == null) continue;
                return element.getOriginalFile();
            }
        }
        return null;
    }

    @Override
    public List<LookupElement> getAllViews(SpringMVCModel context) {
        ArrayList<LookupElement> elements = new ArrayList<LookupElement>();
        TilesViewResolver.processTiles((Processor<Map<String, DomAnchor<Definition>>>)((Processor)stringDomAnchorMap -> {
            for (Map.Entry entry : stringDomAnchorMap.entrySet()) {
                DomAnchor domAnchor = (DomAnchor)entry.getValue();
                Definition definition = (Definition)domAnchor.retrieveDomElement();
                if (definition == null) continue;
                LookupElementBuilder lookupElement = LookupElementBuilder.create((Object)definition.getXmlTag(), (String)((String)entry.getKey())).withIcon(StrutsApiIcons.Tiles.Tile).withTypeText(domAnchor.getContainingFile().getName());
                elements.add((LookupElement)lookupElement);
            }
            return true;
        }), this.myModel);
        return elements;
    }

    @Override
    public String bindToElement(PsiElement element) {
        return null;
    }

    @Override
    @NotNull
    public String handleElementRename(String newElementName) {
        String string = newElementName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/web/mvc/tiles/TilesViewResolver", "handleElementRename"));
        }
        return string;
    }

    private static void processTiles(Processor<Map<String, DomAnchor<Definition>>> processor, SpringModel model) {
        TilesViewResolver.processTiles(model, (Processor<Set<XmlFile>>)((Processor)files -> {
            for (XmlFile file : files) {
                CachedValueProvider provider;
                Map definitions = (Map)CachedValuesManager.getCachedValue((PsiElement)file, (CachedValueProvider)(provider = () -> {
                    HashMap<String, DomAnchor> map = new HashMap<String, DomAnchor>();
                    DomFileElement fileElement = DomManager.getDomManager((Project)file.getProject()).getFileElement(file, com.intellij.struts.dom.tiles.TilesDefinitions.class);
                    if (fileElement != null) {
                        for (Definition definition : ((com.intellij.struts.dom.tiles.TilesDefinitions)fileElement.getRootElement()).getDefinitions()) {
                            String name = definition.getName().getStringValue();
                            map.put(name, DomService.getInstance().createAnchor((DomElement)definition));
                        }
                    }
                    return new CachedValueProvider.Result(map, new Object[]{file});
                }));
                if (processor.process((Object)definitions)) continue;
                return false;
            }
            return true;
        }));
    }

    static void processTiles(SpringModel model, Processor<Set<XmlFile>> consumer) {
        Module module = model.getModule();
        assert (module != null) : model;
        for (String configurerClass : SpringWebConstants.TILES_CONFIGURER_CLASSES) {
            PsiClass tilesConfigurer = SpringCommonUtils.findLibraryClass((Module)module, (String)configurerClass);
            if (tilesConfigurer == null || TilesViewResolver.processTilesConfigurer(model, consumer, tilesConfigurer)) continue;
            return;
        }
    }

    private static boolean processTilesConfigurer(SpringModel model, Processor<Set<XmlFile>> consumer, PsiClass configurerClass) {
        SpringModelSearchParameters.BeanClass searchParameters = SpringModelSearchParameters.byClass((PsiClass)configurerClass).withInheritors().effectiveBeanTypes();
        List pointers = SpringModelSearchers.findBeans((CommonSpringModel)model, (SpringModelSearchParameters.BeanClass)searchParameters);
        for (SpringBeanPointer pointer : pointers) {
            Set<VirtualFile> tilesXmlFiles = TilesViewResolver.getTilesXmlFiles(pointer);
            PsiManager psiManager = configurerClass.getManager();
            StrutsPluginDomFactory tilesFactory = StrutsProjectComponent.getInstance((Project)psiManager.getProject()).getTilesFactory();
            LinkedHashSet<XmlFile> foundFiles = new LinkedHashSet<XmlFile>(tilesXmlFiles.size());
            for (VirtualFile file : tilesXmlFiles) {
                PsiFile psiFile = psiManager.findFile(file);
                if (!(psiFile instanceof XmlFile) || tilesFactory.getDomRoot((XmlFile)psiFile) == null) continue;
                foundFiles.add((XmlFile)psiFile);
            }
            if (consumer.process(foundFiles)) continue;
            return false;
        }
        return pointers.isEmpty();
    }

    @NotNull
    private static Set<VirtualFile> getTilesXmlFiles(SpringBeanPointer pointer) {
        PsiMethod byMethodReturnTypeBeanClass;
        PsiMethod setter;
        PsiClass beanClass;
        if (!pointer.isValid()) {
            Set<VirtualFile> set = Collections.emptySet();
            if (set == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/web/mvc/tiles/TilesViewResolver", "getTilesXmlFiles"));
            }
            return set;
        }
        CommonSpringBean springBean = pointer.getSpringBean();
        SmartList referenceElements = new SmartList();
        if (springBean instanceof SpringBean) {
            SpringPropertyDefinition property = SpringPropertyUtils.findPropertyByName((CommonSpringBean)springBean, (String)"definitions");
            if (!(property instanceof SpringProperty)) {
                Set<VirtualFile> set = Collections.emptySet();
                if (set == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/web/mvc/tiles/TilesViewResolver", "getTilesXmlFiles"));
                }
                return set;
            }
            SpringProperty springProperty = (SpringProperty)property;
            String valueAttribute = property.getValueAsString();
            if (valueAttribute != null) {
                ContainerUtil.addIfNotNull((Collection)referenceElements, (Object)springProperty.getValueAttr().getXmlAttributeValue());
            } else {
                TilesViewResolver.collectCollectionProperties((List<PsiElement>)referenceElements, springProperty);
            }
        } else if (springBean instanceof TilesConfigurer) {
            TilesConfigurer tilesConfigurer = (TilesConfigurer)springBean;
            for (TilesDefinitions definitions : tilesConfigurer.getTilesDefinitions()) {
                if (definitions.getLocation().getStringValue() == null) continue;
                ContainerUtil.addIfNotNull((Collection)referenceElements, (Object)definitions.getLocation().getXmlAttributeValue());
            }
        } else if (springBean instanceof ContextJavaBean && (beanClass = PsiTypesUtil.getPsiClass((PsiType)springBean.getBeanType())) != null && (setter = (PsiMethod)ObjectUtils.chooseNotNull((Object)(byMethodReturnTypeBeanClass = PropertyUtil.findPropertySetter((PsiClass)beanClass, (String)"definitions", (boolean)false, (boolean)true)), (Object)PropertyUtil.findPropertySetter((PsiClass)PsiTypesUtil.getPsiClass((PsiType)springBean.getBeanType(true)), (String)"definitions", (boolean)false, (boolean)true))) != null) {
            LocalSearchScope scope = new LocalSearchScope((PsiElement)((ContextJavaBean)springBean).getPsiElement());
            Set setterCalls = StringExpressionHelper.searchMethodCalls((PsiMethod)setter, (SearchScope)scope);
            for (PsiMethodCallExpression methodCallExpression : setterCalls) {
                PsiExpression[] paramExpressions;
                PsiExpression[] psiExpressionArray = paramExpressions = methodCallExpression.getArgumentList().getExpressions();
                int n = psiExpressionArray.length;
                for (int i = 0; i < n; ++i) {
                    PsiExpression expression = psiExpressionArray[i];
                    Pair evaluated = StringExpressionHelper.evaluateExpression((PsiElement)expression);
                    if (evaluated == null) continue;
                    referenceElements.add(evaluated.getFirst());
                }
            }
        }
        LinkedHashSet files = ContainerUtil.newLinkedHashSet();
        for (PsiElement referenceElement : referenceElements) {
            for (PsiReference reference : referenceElement.getReferences()) {
                if (!(reference instanceof PsiPolyVariantReference)) continue;
                for (ResolveResult result : ((PsiPolyVariantReference)reference).multiResolve(false)) {
                    ContainerUtil.addIfNotNull((Collection)files, (Object)PsiUtilBase.asVirtualFile((PsiElement)result.getElement()));
                }
            }
        }
        LinkedHashSet linkedHashSet = files;
        if (linkedHashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/web/mvc/tiles/TilesViewResolver", "getTilesXmlFiles"));
        }
        return linkedHashSet;
    }

    private static void collectCollectionProperties(List<PsiElement> referenceElements, SpringProperty springProperty) {
        if (DomUtil.hasXml((DomElement)springProperty.getList())) {
            TilesViewResolver.collect(referenceElements, springProperty.getList());
        }
        if (DomUtil.hasXml((DomElement)springProperty.getSet())) {
            TilesViewResolver.collect(referenceElements, springProperty.getSet());
        }
        if (DomUtil.hasXml((DomElement)springProperty.getArray())) {
            TilesViewResolver.collect(referenceElements, springProperty.getArray());
        }
    }

    private static void collect(List<PsiElement> elements, ListOrSet list) {
        for (SpringValue springValue : list.getValues()) {
            ContainerUtil.addIfNotNull(elements, (Object)springValue.getXmlElement());
        }
    }
}

