/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.web.mvc.toolWindow;

import com.intellij.ide.SelectInContext;
import com.intellij.jam.model.util.JamCommonUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.spring.dom.SpringDomUtils;
import com.intellij.spring.model.BeanService;
import com.intellij.spring.model.CommonSpringBean;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.model.xml.mvc.ViewControllerBase;
import com.intellij.spring.web.mvc.SpringControllerClassInfo;
import com.intellij.spring.web.mvc.jam.RequestMapping;
import com.intellij.spring.web.mvc.model.SpringMVCModel;
import com.intellij.spring.web.mvc.toolWindow.SpringMvcRequestMappingsPanel;
import com.intellij.spring.web.mvc.toolWindow.SpringMvcViewSettings;
import com.intellij.spring.web.mvc.toolWindow.SpringMvcViewUtils;
import com.intellij.util.ArrayUtil;
import com.intellij.util.CommonProcessors;
import com.intellij.util.ObjectUtils;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomUtil;
import java.util.Collection;
import org.jetbrains.annotations.Nullable;

class SpringMvcViewSelectInTargetPathBuilder {
    private Object[] myPath = ArrayUtil.EMPTY_OBJECT_ARRAY;
    private Module myModule;
    private SpringMvcViewSettings myViewSettings;

    SpringMvcViewSelectInTargetPathBuilder(SelectInContext context) {
        PsiElement element = this.getElement(context);
        if (element != null) {
            this.calculatePath(element);
        }
    }

    boolean canSelect() {
        return this.myPath.length != 0;
    }

    Object[] getPath() {
        return this.myPath;
    }

    private PsiElement getElement(SelectInContext context) {
        Object selector = context.getSelectorInFile();
        if (!(selector instanceof PsiElement)) {
            return null;
        }
        PsiElement element = (PsiElement)selector;
        this.myModule = ModuleUtilCore.findModuleForPsiElement((PsiElement)element);
        if (this.myModule == null) {
            return null;
        }
        this.myViewSettings = SpringMvcViewSettings.getInstance(this.myModule.getProject());
        return element;
    }

    private void calculatePath(PsiElement element) {
        PsiClass psiClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)element, PsiClass.class);
        if (psiClass != null) {
            this.findControllerCode(element, psiClass);
        } else {
            this.findControllerXml(element);
        }
    }

    private void findControllerCode(PsiElement element, final PsiClass psiClass) {
        boolean isValidRequestMethod;
        if (psiClass.hasModifierProperty("private") || PsiUtil.isLocalOrAnonymousClass((PsiClass)psiClass)) {
            return;
        }
        SpringControllerClassInfo controllerClassInfo = SpringControllerClassInfo.getInfo(psiClass);
        if (!controllerClassInfo.isController()) {
            return;
        }
        CommonProcessors.FindFirstProcessor<SpringBeanPointer> processor = new CommonProcessors.FindFirstProcessor<SpringBeanPointer>(){

            protected boolean accept(SpringBeanPointer pointer) {
                return psiClass.equals(pointer.getBeanClass());
            }
        };
        if (SpringMvcViewUtils.processControllers(this.myModule, (Processor<SpringBeanPointer>)processor)) {
            for (Module dependentModule : ModuleUtilCore.getAllDependentModules((Module)this.myModule)) {
                if (SpringMvcViewUtils.processControllers(dependentModule, (Processor<SpringBeanPointer>)processor)) continue;
                this.myModule = dependentModule;
                break;
            }
        }
        if (!processor.isFound()) {
            return;
        }
        SpringBeanPointer controllerSpringBeanPointer = (SpringBeanPointer)processor.getFoundValue();
        final PsiMethod requestMethod = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)element, PsiMethod.class);
        SpringMvcRequestMappingsPanel.RequestMappingItem requestMappingItem = null;
        boolean bl = isValidRequestMethod = requestMethod != null && controllerClassInfo.isRequestHandler(requestMethod);
        if (isValidRequestMethod) {
            CommonProcessors.FindFirstProcessor<SpringMVCModel.Variant> methodProcessor = new CommonProcessors.FindFirstProcessor<SpringMVCModel.Variant>(){

                protected boolean accept(SpringMVCModel.Variant variant) {
                    PsiElement psiElement = variant.psiElementPointer.getPsiElement();
                    Object modelObject = JamCommonUtil.getModelObject((PsiElement)psiElement);
                    if (!(modelObject instanceof RequestMapping)) {
                        return false;
                    }
                    Object variantRequestMethod = ((RequestMapping)modelObject).getPsiElement();
                    return requestMethod.equals(variantRequestMethod);
                }
            };
            requestMappingItem = this.findRequestMappingItem(controllerSpringBeanPointer, methodProcessor);
        }
        this.createResult(controllerSpringBeanPointer, requestMappingItem);
    }

    private void findControllerXml(PsiElement element) {
        PsiFile file = element.getContainingFile();
        if (!(file instanceof XmlFile)) {
            return;
        }
        if (!SpringDomUtils.isSpringXml((XmlFile)((XmlFile)file))) {
            return;
        }
        XmlTag xmlTag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)element, XmlTag.class);
        if (xmlTag == null) {
            return;
        }
        DomElement domElement = DomUtil.getDomElement((PsiElement)xmlTag);
        if (domElement == null) {
            return;
        }
        ViewControllerBase viewController = (ViewControllerBase)domElement.getParentOfType(ViewControllerBase.class, false);
        if (viewController == null) {
            return;
        }
        SpringBeanPointer controllerSpringBeanPointer = BeanService.getInstance().createSpringBeanPointer((CommonSpringBean)viewController);
        final String viewControllerPath = StringUtil.trimLeading((String)((String)ObjectUtils.assertNotNull((Object)viewController.getPath().getStringValue())), (char)'/');
        CommonProcessors.FindFirstProcessor<SpringMVCModel.Variant> methodProcessor = new CommonProcessors.FindFirstProcessor<SpringMVCModel.Variant>(){

            protected boolean accept(SpringMVCModel.Variant variant) {
                return variant.lookupString.equals(viewControllerPath);
            }
        };
        SpringMvcRequestMappingsPanel.RequestMappingItem requestMappingItem = this.findRequestMappingItem(controllerSpringBeanPointer, methodProcessor);
        this.createResult(controllerSpringBeanPointer, requestMappingItem);
    }

    @Nullable
    private SpringMvcRequestMappingsPanel.RequestMappingItem findRequestMappingItem(SpringBeanPointer controllerSpringBeanPointer, CommonProcessors.FindFirstProcessor<SpringMVCModel.Variant> processor) {
        SpringMvcViewUtils.processUrls(this.myModule, controllerSpringBeanPointer, this.myViewSettings.getRequestMethods(), processor);
        SpringMVCModel.Variant foundVariant = (SpringMVCModel.Variant)processor.getFoundValue();
        if (foundVariant == null) {
            return null;
        }
        return new SpringMvcRequestMappingsPanel.RequestMappingItem(foundVariant.presentation, foundVariant.psiElementPointer, foundVariant.isPattern, foundVariant.method);
    }

    private void createResult(SpringBeanPointer controllerSpringBeanPointer, @Nullable SpringMvcRequestMappingsPanel.RequestMappingItem requestMappingItem) {
        SmartList pathValues = new SmartList();
        if (this.myViewSettings.isShowModules()) {
            pathValues.add(this.myModule);
        }
        if (this.myViewSettings.isShowControllers()) {
            pathValues.add(controllerSpringBeanPointer);
        }
        if (requestMappingItem != null) {
            pathValues.add(requestMappingItem);
        }
        this.myPath = ArrayUtil.toObjectArray((Collection)pathValues);
    }
}

