/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.web.mvc.views;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.spring.CommonSpringModel;
import com.intellij.spring.contexts.model.SpringModel;
import com.intellij.spring.model.CommonSpringBean;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.model.SpringModelSearchParameters;
import com.intellij.spring.model.jam.javaConfig.ContextJavaBean;
import com.intellij.spring.model.utils.SpringCommonUtils;
import com.intellij.spring.model.utils.SpringModelSearchers;
import com.intellij.spring.model.utils.SpringPropertyUtils;
import com.intellij.spring.model.xml.beans.SpringBean;
import com.intellij.spring.web.mvc.views.UrlBasedViewResolver;
import com.intellij.spring.web.mvc.views.ViewResolver;
import com.intellij.spring.web.mvc.views.ViewResolverFactory;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class TemplateViewResolverFactory
extends ViewResolverFactory {
    private final String myBeanClass;
    private final String myConfigurerClass;
    private final String myLoaderProperty;
    private final String myDefaultSuffix;

    protected TemplateViewResolverFactory(String beanClass, String configurerClass, String loaderProperty, String defaultSuffix) {
        this.myBeanClass = beanClass;
        this.myConfigurerClass = configurerClass;
        this.myLoaderProperty = loaderProperty;
        this.myDefaultSuffix = defaultSuffix;
    }

    @Override
    protected String getBeanClass() {
        return this.myBeanClass;
    }

    @Override
    protected Set<ViewResolver> doCreate(CommonSpringBean bean, SpringModel model) {
        Module module;
        UrlBasedViewResolver resolver = new UrlBasedViewResolver(bean);
        Module module2 = module = model.getModule() != null ? model.getModule() : bean.getModule();
        if (module == null) {
            return Collections.emptySet();
        }
        PsiClass configurerClass = SpringCommonUtils.findLibraryClass((Module)module, (String)this.myConfigurerClass);
        if (configurerClass == null) {
            return Collections.singleton(resolver);
        }
        SpringModelSearchParameters.BeanClass searchParameters = SpringModelSearchParameters.byClass((PsiClass)configurerClass).withInheritors().effectiveBeanTypes();
        List configurers = SpringModelSearchers.findBeans((CommonSpringModel)model, (SpringModelSearchParameters.BeanClass)searchParameters);
        if (configurers.isEmpty()) {
            return Collections.singleton(resolver);
        }
        CommonSpringBean configurer = ((SpringBeanPointer)configurers.get(0)).getSpringBean();
        if (configurer instanceof SpringBean || configurer instanceof ContextJavaBean) {
            String value = SpringPropertyUtils.getPropertyStringValue((CommonSpringBean)configurer, (String)this.myLoaderProperty);
            if (value != null) {
                return Collections.singleton(new UrlBasedViewResolver(value + resolver.myPrefix, resolver.mySuffix));
            }
        } else {
            return Collections.singleton(this.handleCustomConfigurer(configurer, resolver));
        }
        return Collections.singleton(resolver);
    }

    @NotNull
    protected ViewResolver handleCustomConfigurer(CommonSpringBean configurer, UrlBasedViewResolver resolver) {
        UrlBasedViewResolver urlBasedViewResolver = resolver;
        if (urlBasedViewResolver == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/web/mvc/views/TemplateViewResolverFactory", "handleCustomConfigurer"));
        }
        return urlBasedViewResolver;
    }

    @Override
    public Set<ViewResolver> handleViewResolverRegistry(String methodName, PsiMethodCallExpression methodCallExpression, SpringModel servletModel) {
        if (this.getViewResolverRegistryMethodName().equals(methodName)) {
            return this.getViewResolverRegistryViewResolvers(methodCallExpression, servletModel);
        }
        return super.handleViewResolverRegistry(methodName, methodCallExpression, servletModel);
    }

    protected String getViewResolverRegistryMethodName() {
        return "";
    }

    private Set<ViewResolver> getViewResolverRegistryViewResolvers(PsiMethodCallExpression expression, SpringModel springModel) {
        PsiClass configurerClass = SpringCommonUtils.findLibraryClass((Module)springModel.getModule(), (String)this.myConfigurerClass);
        if (configurerClass == null) {
            return Collections.emptySet();
        }
        SpringModelSearchParameters.BeanClass searchParameters = SpringModelSearchParameters.byClass((PsiClass)configurerClass).withInheritors().effectiveBeanTypes();
        List configurers = SpringModelSearchers.findBeans((CommonSpringModel)springModel, (SpringModelSearchParameters.BeanClass)searchParameters);
        if (configurers.size() != 1) {
            return Collections.emptySet();
        }
        CommonSpringBean configurer = ((SpringBeanPointer)configurers.get(0)).getSpringBean();
        String prefix = SpringPropertyUtils.getPropertyStringValue((CommonSpringBean)configurer, (String)this.myLoaderProperty);
        return Collections.singleton(new UrlBasedViewResolver(StringUtil.notNullize((String)prefix), this.myDefaultSuffix));
    }
}

