/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.properties.editor;

import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.ide.structureView.StructureViewTreeElement;
import com.intellij.lang.properties.IProperty;
import com.intellij.lang.properties.PropertiesHighlighter;
import com.intellij.lang.properties.editor.PropertiesAnchorizer;
import com.intellij.lang.properties.editor.ResourceBundleEditorViewElement;
import com.intellij.lang.properties.editor.inspections.InspectedPropertyNodeInfo;
import com.intellij.lang.properties.editor.inspections.ResourceBundleEditorProblemDescriptor;
import com.intellij.lang.properties.editor.inspections.ResourceBundleEditorRenderer;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiFile;
import com.intellij.util.PlatformIcons;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ResourceBundlePropertyStructureViewElement
implements StructureViewTreeElement,
ResourceBundleEditorViewElement {
    private static final TextAttributesKey GROUP_KEY;
    public static final String PROPERTY_GROUP_KEY_TEXT = "<property>";
    @NotNull
    private final PropertiesAnchorizer.PropertyAnchor myAnchor;
    private String myPresentableName;
    private volatile InspectedPropertyNodeInfo myInspectedPropertyNodeInfo;

    public ResourceBundlePropertyStructureViewElement(@NotNull PropertiesAnchorizer.PropertyAnchor anchor) {
        if (anchor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "anchor", "com/intellij/lang/properties/editor/ResourceBundlePropertyStructureViewElement", "<init>"));
        }
        this.myAnchor = anchor;
    }

    public IProperty getProperty() {
        return this.getValue().getRepresentative();
    }

    @Override
    @NotNull
    public IProperty[] getProperties() {
        IProperty[] iPropertyArray = new IProperty[]{this.getProperty()};
        if (iPropertyArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/properties/editor/ResourceBundlePropertyStructureViewElement", "getProperties"));
        }
        return iPropertyArray;
    }

    @Override
    @Nullable
    public PsiFile[] getFiles() {
        return null;
    }

    public void setPresentableName(String presentableName) {
        this.myPresentableName = presentableName;
    }

    public PropertiesAnchorizer.PropertyAnchor getValue() {
        return this.myAnchor;
    }

    @NotNull
    public StructureViewTreeElement[] getChildren() {
        if (EMPTY_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/properties/editor/ResourceBundlePropertyStructureViewElement", "getChildren"));
        }
        return EMPTY_ARRAY;
    }

    @NotNull
    public Pair<ResourceBundleEditorProblemDescriptor, HighlightDisplayKey>[] getProblemDescriptors() {
        Object[] objectArray = this.myInspectedPropertyNodeInfo == null ? new Pair[]{} : this.myInspectedPropertyNodeInfo.getDescriptors();
        if (objectArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/properties/editor/ResourceBundlePropertyStructureViewElement", "getProblemDescriptors"));
        }
        return objectArray;
    }

    public void setInspectedPropertyNodeInfo(InspectedPropertyNodeInfo inspectedPropertyNodeInfo) {
        this.myInspectedPropertyNodeInfo = inspectedPropertyNodeInfo;
    }

    @NotNull
    public ItemPresentation getPresentation() {
        ResourceBundleEditorRenderer.TextAttributesPresentation textAttributesPresentation = new ResourceBundleEditorRenderer.TextAttributesPresentation(){

            public String getPresentableText() {
                return ResourceBundlePropertyStructureViewElement.this.myPresentableName == null ? ResourceBundlePropertyStructureViewElement.this.getProperty().getName() : (ResourceBundlePropertyStructureViewElement.this.myPresentableName.isEmpty() ? ResourceBundlePropertyStructureViewElement.PROPERTY_GROUP_KEY_TEXT : ResourceBundlePropertyStructureViewElement.this.myPresentableName);
            }

            public String getLocationString() {
                return null;
            }

            public Icon getIcon(boolean open) {
                return PlatformIcons.PROPERTY_ICON;
            }

            @Override
            public TextAttributes getTextAttributes(EditorColorsScheme colorsScheme) {
                TextAttributes highlightingAttributes;
                TextAttributesKey baseAttrKey = ResourceBundlePropertyStructureViewElement.this.myPresentableName != null && ResourceBundlePropertyStructureViewElement.this.myPresentableName.isEmpty() ? GROUP_KEY : PropertiesHighlighter.PROPERTY_KEY;
                TextAttributes baseAttrs = colorsScheme.getAttributes(baseAttrKey);
                if (ResourceBundlePropertyStructureViewElement.this.getProperty().getPsiElement().isValid() && ResourceBundlePropertyStructureViewElement.this.myInspectedPropertyNodeInfo != null && (highlightingAttributes = ResourceBundlePropertyStructureViewElement.this.myInspectedPropertyNodeInfo.getTextAttributes(colorsScheme)) != null) {
                    return TextAttributes.merge((TextAttributes)baseAttrs, (TextAttributes)highlightingAttributes);
                }
                return baseAttrs;
            }
        };
        if (textAttributesPresentation == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/properties/editor/ResourceBundlePropertyStructureViewElement", "getPresentation"));
        }
        return textAttributesPresentation;
    }

    public void navigate(boolean requestFocus) {
    }

    public boolean canNavigate() {
        return false;
    }

    public boolean canNavigateToSource() {
        return false;
    }

    static {
        TextAttributes groupKeyTextAttributes = EditorColorsManager.getInstance().getGlobalScheme().getAttributes(PropertiesHighlighter.PROPERTY_KEY).clone();
        groupKeyTextAttributes.setFontType(2);
        GROUP_KEY = TextAttributesKey.createTextAttributesKey((String)"GROUP_KEY", (TextAttributes)groupKeyTextAttributes);
    }
}

