/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.properties.editor.inspections.incomplete;

import com.intellij.codeInspection.InspectionProfile;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.QuickFix;
import com.intellij.codeInspection.ex.DisableInspectionToolAction;
import com.intellij.codeInspection.ex.UnfairLocalInspectionTool;
import com.intellij.lang.properties.IProperty;
import com.intellij.lang.properties.PropertiesBundle;
import com.intellij.lang.properties.PropertiesImplUtil;
import com.intellij.lang.properties.PropertiesUtil;
import com.intellij.lang.properties.ResourceBundle;
import com.intellij.lang.properties.editor.inspections.ResourceBundleEditorInspection;
import com.intellij.lang.properties.editor.inspections.ResourceBundleEditorProblemDescriptor;
import com.intellij.lang.properties.editor.inspections.incomplete.IncompletePropertyInspectionOptionsPanel;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.function.Function;
import javax.swing.JComponent;
import org.jdom.Element;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IncompletePropertyInspection
extends LocalInspectionTool
implements ResourceBundleEditorInspection,
UnfairLocalInspectionTool {
    private static final String SUFFIXES_TAG_NAME = "suffixes";
    private static final String TOOL_KEY = "IncompleteProperty";
    SortedSet<String> mySuffixes = new TreeSet<String>();

    @Nullable
    public JComponent createOptionsPanel() {
        return new IncompletePropertyInspectionOptionsPanel(this.mySuffixes).buildPanel();
    }

    public void readSettings(@NotNull Element node) throws InvalidDataException {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/lang/properties/editor/inspections/incomplete/IncompletePropertyInspection", "readSettings"));
        }
        this.mySuffixes.clear();
        Element element = node.getChild(SUFFIXES_TAG_NAME);
        if (element != null) {
            this.mySuffixes.addAll(StringUtil.split((String)element.getText(), (String)",", (boolean)true, (boolean)false));
        }
    }

    public void writeSettings(@NotNull Element node) throws WriteExternalException {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/lang/properties/editor/inspections/incomplete/IncompletePropertyInspection", "writeSettings"));
        }
        if (!this.mySuffixes.isEmpty()) {
            node.addContent(new Element(SUFFIXES_TAG_NAME).setText(StringUtil.join(this.mySuffixes, (String)",")));
        }
    }

    @Override
    @NotNull
    public Function<IProperty[], ResourceBundleEditorProblemDescriptor[]> buildPropertyGroupVisitor(@NotNull ResourceBundle resourceBundle) {
        if (resourceBundle == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resourceBundle", "com/intellij/lang/properties/editor/inspections/incomplete/IncompletePropertyInspection", "buildPropertyGroupVisitor"));
        }
        Function<IProperty[], ResourceBundleEditorProblemDescriptor[]> function = properties -> {
            ResourceBundleEditorProblemDescriptor[] resourceBundleEditorProblemDescriptorArray;
            if (resourceBundle == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resourceBundle", "com/intellij/lang/properties/editor/inspections/incomplete/IncompletePropertyInspection", "lambda$buildPropertyGroupVisitor$0"));
            }
            if (!this.isPropertyComplete((IProperty[])properties, resourceBundle)) {
                ResourceBundleEditorProblemDescriptor[] resourceBundleEditorProblemDescriptorArray2 = new ResourceBundleEditorProblemDescriptor[1];
                resourceBundleEditorProblemDescriptorArray = resourceBundleEditorProblemDescriptorArray2;
                resourceBundleEditorProblemDescriptorArray2[0] = new ResourceBundleEditorProblemDescriptor(ProblemHighlightType.GENERIC_ERROR_OR_WARNING, PropertiesBundle.message("incomplete.property.inspection.description", properties[0].getName()), new IgnoreLocalesQuickFix(properties[0], resourceBundle));
            } else {
                resourceBundleEditorProblemDescriptorArray = null;
            }
            return resourceBundleEditorProblemDescriptorArray;
        };
        if (function == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/properties/editor/inspections/incomplete/IncompletePropertyInspection", "buildPropertyGroupVisitor"));
        }
        return function;
    }

    @NotNull
    public static IncompletePropertyInspection getInstance(PsiElement element) {
        InspectionProjectProfileManager profileManager = InspectionProjectProfileManager.getInstance((Project)element.getProject());
        InspectionProfile inspectionProfile = profileManager.getCurrentProfile();
        IncompletePropertyInspection incompletePropertyInspection = (IncompletePropertyInspection)inspectionProfile.getUnwrappedTool(TOOL_KEY, element);
        if (incompletePropertyInspection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/properties/editor/inspections/incomplete/IncompletePropertyInspection", "getInstance"));
        }
        return incompletePropertyInspection;
    }

    public boolean isPropertyComplete(String key, ResourceBundle resourceBundle) {
        return this.isPropertyComplete((IProperty[])resourceBundle.getPropertiesFiles().stream().map(f -> f.findPropertyByKey(key)).filter(Objects::nonNull).toArray(IProperty[]::new), resourceBundle);
    }

    private boolean isPropertyComplete(IProperty[] properties, ResourceBundle resourceBundle) {
        Set existed = ContainerUtil.map2Set((Object[])properties, IProperty::getPropertiesFile);
        for (PropertiesFile file : resourceBundle.getPropertiesFiles()) {
            if (existed.contains(file) || this.getIgnoredSuffixes().contains(PropertiesUtil.getSuffix(file))) continue;
            return false;
        }
        return true;
    }

    public Set<String> getIgnoredSuffixes() {
        return this.mySuffixes;
    }

    public List<PropertiesFile> getPropertiesFilesWithoutTranslation(ResourceBundle resourceBundle, String key) {
        return ContainerUtil.filter(resourceBundle.getPropertiesFiles(), propertiesFile -> propertiesFile.findPropertyByKey(key) == null && !this.getIgnoredSuffixes().contains(PropertiesUtil.getSuffix(propertiesFile)));
    }

    public void addSuffixes(Collection<String> suffixes) {
        this.mySuffixes.addAll(suffixes);
    }

    private static class IgnoreLocalesQuickFix
    implements QuickFix<ResourceBundleEditorProblemDescriptor> {
        private final ResourceBundle myResourceBundle;
        private final SmartPsiElementPointer<PsiElement> myElementPointer;

        public IgnoreLocalesQuickFix(IProperty property, ResourceBundle bundle) {
            this.myElementPointer = SmartPointerManager.getInstance((Project)bundle.getProject()).createSmartPsiElementPointer(property.getPsiElement());
            this.myResourceBundle = bundle;
        }

        @Nls
        @NotNull
        public String getName() {
            String string = this.getFamilyName();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/properties/editor/inspections/incomplete/IncompletePropertyInspection$IgnoreLocalesQuickFix", "getName"));
            }
            return string;
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            String string = PropertiesBundle.message("incomplete.property.quick.fix.name", new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/properties/editor/inspections/incomplete/IncompletePropertyInspection$IgnoreLocalesQuickFix", "getFamilyName"));
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ResourceBundleEditorProblemDescriptor descriptor) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/properties/editor/inspections/incomplete/IncompletePropertyInspection$IgnoreLocalesQuickFix", "applyFix"));
            }
            if (descriptor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/lang/properties/editor/inspections/incomplete/IncompletePropertyInspection$IgnoreLocalesQuickFix", "applyFix"));
            }
            PsiElement element = this.myElementPointer.getElement();
            if (element == null) {
                return;
            }
            IProperty property = PropertiesImplUtil.getProperty(element);
            if (property == null) {
                return;
            }
            IncompletePropertyInspection inspection = IncompletePropertyInspection.getInstance(element);
            List<PropertiesFile> allFilesWithoutTranslation = inspection.getPropertiesFilesWithoutTranslation(this.myResourceBundle, property.getKey());
            if (allFilesWithoutTranslation.isEmpty()) {
                return;
            }
            TreeSet<String> suffixesToIgnore = new TreeSet<String>(ContainerUtil.map(allFilesWithoutTranslation, PropertiesUtil::getSuffix));
            if (new IncompletePropertyInspectionOptionsPanel(suffixesToIgnore).showDialogAndGet(project)) {
                DisableInspectionToolAction.modifyAndCommitProjectProfile(modifiableModel -> ((IncompletePropertyInspection)modifiableModel.getInspectionTool(IncompletePropertyInspection.TOOL_KEY, element).getTool()).addSuffixes(suffixesToIgnore), (Project)project);
            }
        }
    }
}

