/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.gui;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Window;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.EventListener;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.lobobrowser.clientlet.ClientletResponse;
import org.lobobrowser.clientlet.ComponentContent;
import org.lobobrowser.gui.AddressBarPanel;
import org.lobobrowser.gui.BrowserWindow;
import org.lobobrowser.gui.ContentListener;
import org.lobobrowser.gui.FillerComponent;
import org.lobobrowser.gui.FramePanel;
import org.lobobrowser.gui.FramePanelFactorySource;
import org.lobobrowser.gui.ResponseListener;
import org.lobobrowser.gui.SharedToolBarPanel;
import org.lobobrowser.gui.StatusBarPanel;
import org.lobobrowser.gui.WindowCallback;
import org.lobobrowser.main.ExtensionManager;
import org.lobobrowser.request.RequestEngine;
import org.lobobrowser.request.UserAgentImpl;
import org.lobobrowser.ua.NavigationEntry;
import org.lobobrowser.ua.NavigationListener;
import org.lobobrowser.ua.NavigatorEvent;
import org.lobobrowser.ua.NavigatorEventType;
import org.lobobrowser.ua.NavigatorFrame;
import org.lobobrowser.ua.NavigatorProgressEvent;
import org.lobobrowser.ua.NavigatorWindow;
import org.lobobrowser.ua.NavigatorWindowEvent;
import org.lobobrowser.ua.NavigatorWindowListener;
import org.lobobrowser.ua.RequestType;
import org.lobobrowser.ua.UserAgent;
import org.lobobrowser.util.EventDispatch2;
import org.lobobrowser.util.Objects;
import org.lobobrowser.util.Urls;

public class BrowserPanel
extends JPanel
implements NavigatorWindow,
BrowserWindow,
WindowCallback {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = Logger.getLogger(BrowserPanel.class.getName());
    private final boolean hasToolBar;
    private final JMenuBar menuBar;
    private final FramePanel framePanel;
    private final AddressBarPanel addressBarPanel;
    private final SharedToolBarPanel sharedToolBarPanel;
    private final StatusBarPanel statusBarPanel;
    private final Map<String, JMenu> menuesById = new HashMap<String, JMenu>(1);
    private final EventDispatch2 EVENT = new LocalEventDispatch();
    private volatile NavigatorFrame latestAccessedFrame = null;
    private static final int HGAP = 4;
    private static final int VGAP = 2;
    private boolean closeWindowOnDispose = true;
    private String defaultStatus;
    private String status;
    private String documentTitle;

    public BrowserPanel() {
        this(null, true, true, true);
    }

    public BrowserPanel(JMenuBar menuBar) {
        this(menuBar, true, true, true);
    }

    public BrowserPanel(JMenuBar menuBar, boolean hasAddressBar, boolean hasToolBar, boolean hasStatusBar) {
        FramePanel framePanel;
        this.hasToolBar = hasToolBar;
        this.menuBar = menuBar;
        String windowId = "BrowserPanel." + System.identityHashCode(this);
        this.framePanel = framePanel = FramePanelFactorySource.getInstance().getActiveFactory().createFramePanel(windowId);
        BrowserPanel contentPane = this;
        contentPane.setLayout(new BoxLayout(contentPane, 1));
        if (hasAddressBar) {
            AddressBarPanel abp;
            this.addressBarPanel = abp = new AddressBarPanel();
            contentPane.add(abp);
        } else {
            this.addressBarPanel = null;
        }
        if (hasToolBar) {
            SharedToolBarPanel stbp;
            this.sharedToolBarPanel = stbp = new SharedToolBarPanel();
            contentPane.add(stbp);
        } else {
            this.sharedToolBarPanel = null;
        }
        contentPane.add(new FillerComponent(framePanel, false));
        if (hasStatusBar) {
            StatusBarPanel statusBar;
            this.statusBarPanel = statusBar = new StatusBarPanel();
            contentPane.add(statusBar);
        } else {
            this.statusBarPanel = null;
        }
        ExtensionManager.getInstance().initExtensionsWindow(this);
    }

    public void windowClosing() {
        ExtensionManager.getInstance().shutdownExtensionsWindow(this);
    }

    public void navigate(String urlOrPath) throws MalformedURLException {
        this.framePanel.navigate(urlOrPath);
    }

    public void navigate(URL url) throws MalformedURLException {
        this.framePanel.navigate(url);
    }

    @Override
    public void addAddressBarComponent(Component addressBarComponent) {
        AddressBarPanel abp = this.addressBarPanel;
        if (abp != null) {
            abp.add(addressBarComponent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addMenu(String menuId, JMenu menu) {
        JMenuBar menuBar = this.menuBar;
        if (menuBar != null) {
            Map<String, JMenu> map = this.menuesById;
            synchronized (map) {
                this.menuesById.put(menuId, menu);
            }
            menuBar.add(menu);
        }
    }

    @Override
    public void addNavigatorWindowListener(NavigatorWindowListener listener) {
        this.EVENT.addListener(listener);
    }

    @Override
    public void addSharedToolBarComponent(Component toolBarComponent) {
        SharedToolBarPanel stbp = this.sharedToolBarPanel;
        if (stbp != null) {
            stbp.add(toolBarComponent);
        }
    }

    @Override
    public void addStatusBarComponent(Component statusBarComponent) {
        StatusBarPanel sbp = this.statusBarPanel;
        if (sbp != null) {
            sbp.add(statusBarComponent);
        }
    }

    @Override
    public void addToolBar(Component toolBar) {
        if (this.hasToolBar) {
            this.add(toolBar);
        }
    }

    @Override
    public boolean back() {
        NavigatorFrame frame = this.latestAccessedFrame;
        if (frame != null) {
            if (frame.back()) {
                return true;
            }
            if (frame == this.framePanel) {
                return false;
            }
        }
        return this.framePanel.back();
    }

    @Override
    public boolean canBack() {
        NavigatorFrame frame = this.latestAccessedFrame;
        if (frame != null) {
            if (frame.canBack()) {
                return true;
            }
            if (frame == this.framePanel) {
                return false;
            }
        }
        return this.framePanel.canBack();
    }

    @Override
    public boolean canCopy() {
        return this.framePanel.canCopy();
    }

    @Override
    public boolean canForward() {
        NavigatorFrame frame = this.latestAccessedFrame;
        if (frame != null) {
            if (frame.canForward()) {
                return true;
            }
            if (frame == this.framePanel) {
                return false;
            }
        }
        return this.framePanel.canForward();
    }

    @Override
    public boolean canReload() {
        return this.framePanel.canReload();
    }

    @Override
    public boolean copy() {
        return this.framePanel.copy();
    }

    @Override
    public Component createGap() {
        return Box.createRigidArea(new Dimension(4, 2));
    }

    @Override
    public Component createGlueComponent(Component wrappedComponent, boolean usingMaxSize) {
        return new FillerComponent(wrappedComponent, usingMaxSize);
    }

    public boolean isCloseWindowOnDispose() {
        return this.closeWindowOnDispose;
    }

    public void setCloseWindowOnDispose(boolean closeWindowOnDispose) {
        this.closeWindowOnDispose = closeWindowOnDispose;
    }

    @Override
    public void dispose() {
        Window awtFrame;
        if (this.closeWindowOnDispose && (awtFrame = this.getAwtWindow()) != null) {
            awtFrame.dispose();
        }
    }

    @Override
    public boolean forward() {
        NavigatorFrame frame = this.latestAccessedFrame;
        if (frame != null) {
            if (frame.forward()) {
                return true;
            }
            if (frame == this.framePanel) {
                return false;
            }
        }
        return this.framePanel.forward();
    }

    @Override
    public Window getAwtWindow() {
        Container parent;
        for (parent = this.getParent(); parent != null && !(parent instanceof Window); parent = parent.getParent()) {
        }
        return (Window)parent;
    }

    @Override
    public NavigationEntry[] getBackNavigationEntries() {
        return this.framePanel.getBackNavigationEntries();
    }

    @Override
    public NavigationEntry getCurrentNavigationEntry() {
        return this.framePanel.getCurrentNavigationEntry();
    }

    @Override
    public NavigationEntry[] getForwardNavigationEntries() {
        return this.framePanel.getForwardNavigationEntries();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JMenu getMenu(String menuId) {
        Map<String, JMenu> map = this.menuesById;
        synchronized (map) {
            return this.menuesById.get(menuId);
        }
    }

    @Override
    public NavigatorFrame getTopFrame() {
        return this.framePanel;
    }

    @Override
    public UserAgent getUserAgent() {
        return UserAgentImpl.getInstance();
    }

    @Override
    public boolean goTo(NavigationEntry entry) {
        return this.framePanel.goTo(entry);
    }

    @Override
    public boolean hasSource() {
        return this.framePanel.hasSource();
    }

    @Override
    public boolean reload() {
        this.framePanel.reload();
        return true;
    }

    @Override
    public void removeNavigatorWindowListener(NavigatorWindowListener listener) {
        this.EVENT.removeListener(listener);
    }

    @Override
    public boolean stop() {
        RequestEngine.getInstance().cancelAllRequests();
        return true;
    }

    @Override
    public FramePanel getTopFramePanel() {
        return this.framePanel;
    }

    @Override
    public WindowCallback getWindowCallback() {
        return this;
    }

    @Override
    public Component getComponent() {
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getDefaultStatus() {
        BrowserPanel browserPanel = this;
        synchronized (browserPanel) {
            return this.defaultStatus;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getStatus() {
        BrowserPanel browserPanel = this;
        synchronized (browserPanel) {
            return this.status;
        }
    }

    @Override
    public void handleDocumentAccess(NavigatorFrame frame, ClientletResponse response) {
        final NavigatorWindowEvent event = new NavigatorWindowEvent(this, NavigatorEventType.DOCUMENT_ACCESSED, frame, response);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                BrowserPanel.this.EVENT.fireEvent(event);
            }
        });
    }

    @Override
    public void handleDocumentRendering(final NavigatorFrame frame, final ClientletResponse response, final ComponentContent content) {
        if (EventQueue.isDispatchThread()) {
            this.handleDocumentRenderingImpl(frame, response, content);
        } else {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    BrowserPanel.this.handleDocumentRenderingImpl(frame, response, content);
                }
            });
        }
    }

    protected String getWindowTitle(ClientletResponse response, ComponentContent content) {
        String title;
        String string = title = content == null ? null : content.getTitle();
        if (title == null) {
            title = response == null ? "" : Urls.getNoRefForm(response.getResponseURL());
        }
        return title;
    }

    public String getDocumentTitle() {
        return this.documentTitle;
    }

    public void setDocumentTitle(String documentTitle) {
        this.documentTitle = documentTitle;
    }

    private void handleDocumentRenderingImpl(NavigatorFrame frame, ClientletResponse response, ComponentContent content) {
        if (frame == this.framePanel) {
            String title = this.getWindowTitle(response, content);
            this.setDocumentTitle(title);
        }
        NavigatorWindowEvent event = new NavigatorWindowEvent(this, NavigatorEventType.DOCUMENT_RENDERING, frame, response);
        this.latestAccessedFrame = event.getNavigatorFrame();
        if (!this.EVENT.fireEvent(event)) {
            logger.warning("handleDocumentRendering(): Did not deliver event to any window: " + event);
        }
    }

    private ExtensionManager getSafeExtensionManager() {
        return AccessController.doPrivileged(new PrivilegedAction<ExtensionManager>(){

            @Override
            public ExtensionManager run() {
                return ExtensionManager.getInstance();
            }
        });
    }

    @Override
    public void handleError(NavigatorFrame frame, ClientletResponse response, Throwable exception) {
        this.getSafeExtensionManager().handleError(frame, response, exception);
        this.handleDocumentRendering(frame, response, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setDefaultStatus(NavigatorFrame frame, String defaultStatus) {
        BrowserPanel browserPanel = this;
        synchronized (browserPanel) {
            this.defaultStatus = defaultStatus;
            if (this.status == null) {
                String actualStatus = this.defaultStatus;
                final NavigatorWindowEvent event = new NavigatorWindowEvent((Object)this, NavigatorEventType.STATUS_UPDATED, frame, actualStatus, RequestType.NONE);
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        BrowserPanel.this.EVENT.fireEvent(event);
                    }
                });
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setStatus(NavigatorFrame frame, String value) {
        BrowserPanel browserPanel = this;
        synchronized (browserPanel) {
            if (!Objects.equals(this.status, value)) {
                this.status = value;
                String actualStatus = value == null ? this.defaultStatus : value;
                final NavigatorWindowEvent event = new NavigatorWindowEvent((Object)this, NavigatorEventType.STATUS_UPDATED, frame, actualStatus, RequestType.NONE);
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        BrowserPanel.this.EVENT.fireEvent(event);
                    }
                });
            }
        }
    }

    @Override
    public void updateProgress(final NavigatorProgressEvent event) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                BrowserPanel.this.EVENT.fireEvent(event);
            }
        });
    }

    public Object getContentObject() {
        return this.framePanel.getContentObject();
    }

    public String getCurrentMimeType() {
        return this.framePanel.getCurrentMimeType();
    }

    public void addNavigationListener(NavigationListener listener) {
        this.framePanel.addNavigationListener(listener);
    }

    public void removeNavigationListener(NavigationListener listener) {
        this.framePanel.addNavigationListener(listener);
    }

    public void addContentListener(ContentListener listener) {
        this.framePanel.addContentListener(listener);
    }

    public void removeContentListener(ContentListener listener) {
        this.framePanel.removeContentListener(listener);
    }

    public void addResponseListener(ResponseListener listener) {
        this.framePanel.addResponseListener(listener);
    }

    public void removeResponseListener(ResponseListener listener) {
        this.framePanel.removeResponseListener(listener);
    }

    public ComponentContent getComponentContent() {
        return this.framePanel.getComponentContent();
    }

    public static class LocalEventDispatch
    extends EventDispatch2 {
        @Override
        protected void dispatchEvent(EventListener listener, EventObject event) {
            NavigatorEvent ne = (NavigatorEvent)event;
            NavigatorWindowListener nwl = (NavigatorWindowListener)listener;
            switch (ne.getEventType()) {
                case DOCUMENT_ACCESSED: {
                    nwl.documentAccessed((NavigatorWindowEvent)ne);
                    break;
                }
                case DOCUMENT_RENDERING: {
                    nwl.documentRendering((NavigatorWindowEvent)ne);
                    break;
                }
                case PROGRESS_UPDATED: {
                    nwl.progressUpdated((NavigatorProgressEvent)ne);
                    break;
                }
                case STATUS_UPDATED: {
                    nwl.statusUpdated((NavigatorWindowEvent)ne);
                    break;
                }
                case DEFAULT_STATUS_UPDATED: {
                    nwl.defaultStatusUpdated((NavigatorWindowEvent)ne);
                    break;
                }
            }
        }
    }
}

