/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Graphics;
import java.awt.Window;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.lobobrowser.clientlet.ClientletResponse;
import org.lobobrowser.clientlet.ComponentContent;
import org.lobobrowser.clientlet.SimpleComponentContent;
import org.lobobrowser.context.NetworkRequestImpl;
import org.lobobrowser.gui.BrowserWindow;
import org.lobobrowser.gui.ContentEvent;
import org.lobobrowser.gui.ContentListener;
import org.lobobrowser.gui.FramePanelFactorySource;
import org.lobobrowser.gui.NavigationEngine;
import org.lobobrowser.gui.NavigatorWindowImpl;
import org.lobobrowser.gui.ResponseEvent;
import org.lobobrowser.gui.ResponseListener;
import org.lobobrowser.gui.WindowCallback;
import org.lobobrowser.main.ExtensionManager;
import org.lobobrowser.request.ClientletRequestHandler;
import org.lobobrowser.request.ClientletRequestImpl;
import org.lobobrowser.request.RequestEngine;
import org.lobobrowser.security.GenericLocalPermission;
import org.lobobrowser.ua.NavigationEntry;
import org.lobobrowser.ua.NavigationEvent;
import org.lobobrowser.ua.NavigationListener;
import org.lobobrowser.ua.NavigationVetoException;
import org.lobobrowser.ua.NavigatorFrame;
import org.lobobrowser.ua.NavigatorProgressEvent;
import org.lobobrowser.ua.NetworkRequest;
import org.lobobrowser.ua.ParameterInfo;
import org.lobobrowser.ua.ProgressType;
import org.lobobrowser.ua.RequestType;
import org.lobobrowser.ua.TargetType;
import org.lobobrowser.util.GenericEventListener;
import org.lobobrowser.util.Items;
import org.lobobrowser.util.Urls;
import org.lobobrowser.util.WrapperException;
import org.lobobrowser.util.gui.WrapperLayout;

public class FramePanel
extends JPanel
implements NavigatorFrame {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = Logger.getLogger(FramePanel.class.getName());
    private final String windowId;
    private final NavigationEngine navigationEngine = new NavigationEngine();
    private final FramePanel knownParentFrame;
    private final Collection<NavigationListener> navigationListeners = new ArrayList<NavigationListener>();
    private final Collection<ResponseListener> responseListeners = new ArrayList<ResponseListener>();
    private final Collection<ContentListener> contentListeners = new ArrayList<ContentListener>();
    private final Object propertiesMonitor = new Object();
    private NavigatorFrame openerFrame;
    private Window topFrameWindow;
    private ComponentContent content;
    private NavigatorProgressEvent progressEvent;
    private Map contentProperties = null;

    public FramePanel(String windowId) {
        this.knownParentFrame = null;
        this.windowId = windowId;
        this.setLayout(WrapperLayout.getInstance());
        this.setBackground(Color.WHITE);
        this.setOpaque(true);
    }

    public FramePanel(FramePanel parentFrame) {
        this.knownParentFrame = parentFrame;
        this.windowId = null;
        this.setLayout(WrapperLayout.getInstance());
        this.setBackground(Color.WHITE);
        this.setOpaque(true);
    }

    public FramePanel() {
        this((FramePanel)null);
    }

    public void setOpenerFrame(NavigatorFrame opener) {
        this.openerFrame = opener;
    }

    public void informResponseProcessed(ClientletResponse response) {
        this.dispatchResponseProcessed(new ResponseEvent(this, response));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addNavigationListener(NavigationListener listener) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(GenericLocalPermission.EXT_GENERIC);
        }
        FramePanel framePanel = this;
        synchronized (framePanel) {
            this.navigationListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeNavigationListener(NavigationListener listener) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(GenericLocalPermission.EXT_GENERIC);
        }
        FramePanel framePanel = this;
        synchronized (framePanel) {
            this.navigationListeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addContentListener(ContentListener listener) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(GenericLocalPermission.EXT_GENERIC);
        }
        FramePanel framePanel = this;
        synchronized (framePanel) {
            this.contentListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeContentListener(ContentListener listener) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(GenericLocalPermission.EXT_GENERIC);
        }
        FramePanel framePanel = this;
        synchronized (framePanel) {
            this.contentListeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addResponseListener(ResponseListener listener) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(GenericLocalPermission.EXT_GENERIC);
        }
        FramePanel framePanel = this;
        synchronized (framePanel) {
            this.responseListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeResponseListener(ResponseListener listener) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(GenericLocalPermission.EXT_GENERIC);
        }
        FramePanel framePanel = this;
        synchronized (framePanel) {
            this.responseListeners.remove(listener);
        }
    }

    private void dispatchBeforeNavigate(final NavigationEvent event) throws NavigationVetoException {
        try {
            AccessController.doPrivileged(new PrivilegedAction<Object>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public Object run() {
                    try {
                        NavigationListener[] listeners;
                        ExtensionManager.getInstance().dispatchBeforeNavigate(event);
                        1 var2_1 = this;
                        synchronized (var2_1) {
                            listeners = FramePanel.this.navigationListeners.toArray(NavigationListener.EMPTY_ARRAY);
                        }
                        for (int i = 0; i < listeners.length; ++i) {
                            listeners[i].beforeNavigate(event);
                        }
                        return null;
                    }
                    catch (NavigationVetoException nve) {
                        throw new WrapperException(nve);
                    }
                }
            });
        }
        catch (WrapperException we) {
            throw (NavigationVetoException)we.getCause();
        }
    }

    private void dispatchBeforeLocalNavigate(final NavigationEvent event) throws NavigationVetoException {
        try {
            AccessController.doPrivileged(new PrivilegedAction<Object>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public Object run() {
                    try {
                        NavigationListener[] listeners;
                        ExtensionManager.getInstance().dispatchBeforeLocalNavigate(event);
                        2 var2_1 = this;
                        synchronized (var2_1) {
                            listeners = FramePanel.this.navigationListeners.toArray(NavigationListener.EMPTY_ARRAY);
                        }
                        for (int i = 0; i < listeners.length; ++i) {
                            listeners[i].beforeLocalNavigate(event);
                        }
                        return null;
                    }
                    catch (NavigationVetoException nve) {
                        throw new WrapperException(nve);
                    }
                }
            });
        }
        catch (WrapperException we) {
            throw (NavigationVetoException)we.getCause();
        }
    }

    private void dispatchBeforeWindowOpen(final NavigationEvent event) throws NavigationVetoException {
        try {
            AccessController.doPrivileged(new PrivilegedAction<Object>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public Object run() {
                    try {
                        NavigationListener[] listeners;
                        ExtensionManager.getInstance().dispatchBeforeWindowOpen(event);
                        3 var2_1 = this;
                        synchronized (var2_1) {
                            listeners = FramePanel.this.navigationListeners.toArray(NavigationListener.EMPTY_ARRAY);
                        }
                        for (int i = 0; i < listeners.length; ++i) {
                            listeners[i].beforeWindowOpen(event);
                        }
                        return null;
                    }
                    catch (NavigationVetoException nve) {
                        throw new WrapperException(nve);
                    }
                }
            });
        }
        catch (WrapperException we) {
            throw (NavigationVetoException)we.getCause();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dispatchContentSet(ContentEvent event) {
        ContentListener[] listeners;
        FramePanel framePanel = this;
        synchronized (framePanel) {
            listeners = this.contentListeners.toArray(ContentListener.EMPTY_ARRAY);
        }
        for (int i = 0; i < listeners.length; ++i) {
            listeners[i].contentSet(event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dispatchResponseProcessed(ResponseEvent event) {
        ResponseListener[] listeners;
        FramePanel framePanel = this;
        synchronized (framePanel) {
            listeners = this.responseListeners.toArray(ResponseListener.EMPTY_ARRAY);
        }
        for (int i = 0; i < listeners.length; ++i) {
            listeners[i].responseProcessed(event);
        }
    }

    protected WindowCallback getWindowCallback() {
        Container parent;
        FramePanel kpf = this.knownParentFrame;
        if (kpf != null) {
            return kpf.getWindowCallback();
        }
        for (parent = this.getParent(); parent != null && !(parent instanceof BrowserWindow); parent = parent.getParent()) {
        }
        if (parent == null) {
            return null;
        }
        return ((BrowserWindow)((Object)parent)).getWindowCallback();
    }

    @Override
    public NavigatorFrame getParentFrame() {
        Container parent;
        FramePanel kpf = this.knownParentFrame;
        if (kpf != null) {
            return kpf;
        }
        for (parent = this.getParent(); parent != null && !(parent instanceof NavigatorFrame); parent = parent.getParent()) {
        }
        return (NavigatorFrame)((Object)parent);
    }

    @Override
    public NavigatorFrame getTopFrame() {
        NavigatorFrame current = this;
        NavigatorFrame ancestor;
        while ((ancestor = current.getParentFrame()) != null) {
            current = ancestor;
        }
        return current;
    }

    @Override
    public Component getComponent() {
        return this;
    }

    @Override
    public void paint(Graphics g) {
        this.paintComponent(g);
        this.paintBorder(g);
        this.paintChildren(g);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NavigationEntry[] getBackNavigationEntries() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(GenericLocalPermission.EXT_GENERIC);
        }
        FramePanel framePanel = this;
        synchronized (framePanel) {
            return this.navigationEngine.getBackNavigationEntries();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NavigationEntry[] getForwardNavigationEntries() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(GenericLocalPermission.EXT_GENERIC);
        }
        FramePanel framePanel = this;
        synchronized (framePanel) {
            return this.navigationEngine.getForwardNavigationEntries();
        }
    }

    public boolean hasSource() {
        ComponentContent content = this.content;
        return content != null && content.getSourceCode() != null;
    }

    public boolean canCopy() {
        ComponentContent content = this.content;
        return content == null ? false : content.canCopy();
    }

    public boolean copy() {
        ComponentContent content = this.content;
        return content == null ? false : content.copy();
    }

    @Override
    public final void replaceContent(Component component) {
        this.replaceContent(null, new SimpleComponentContent(component));
    }

    @Override
    public void replaceContent(final ClientletResponse response, final ComponentContent content) {
        if (EventQueue.isDispatchThread()) {
            this.replaceContentImpl(response, content);
        } else {
            final AccessControlContext context = AccessController.getContext();
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    PrivilegedAction<Object> action = new PrivilegedAction<Object>(){

                        @Override
                        public Object run() {
                            FramePanel.this.replaceContentImpl(response, content);
                            return null;
                        }
                    };
                    AccessController.doPrivileged(action, context);
                }
            });
        }
    }

    @Override
    protected void addImpl(Component comp, Object constraints, int index) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(GenericLocalPermission.EXT_GENERIC);
        }
        super.addImpl(comp, constraints, index);
    }

    @Override
    public void remove(Component comp) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(GenericLocalPermission.EXT_GENERIC);
        }
        super.remove(comp);
    }

    @Override
    public void remove(int index) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(GenericLocalPermission.EXT_GENERIC);
        }
        super.remove(index);
    }

    @Override
    public void removeAll() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(GenericLocalPermission.EXT_GENERIC);
        }
        super.removeAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void replaceContentImpl(ClientletResponse response, ComponentContent content) {
        if (logger.isLoggable(Level.INFO)) {
            logger.info("replaceContentImpl(): this=" + this + ",response=" + response + ", content=" + content);
        }
        ComponentContent oldContent = this.content;
        this.removeAll();
        if (oldContent != null) {
            oldContent.removeNotify();
        }
        if (content != null) {
            Component component = content.getComponent();
            if (component == null) {
                throw new IllegalStateException("Component from " + content + " is null: " + response.getResponseURL() + ".");
            }
            this.add(component);
        }
        this.validate();
        this.repaint();
        this.content = content;
        if (content != null) {
            content.addNotify();
            this.updateContentProperties(content);
        }
        if (response != null) {
            WindowCallback wc;
            String title = content == null ? null : content.getTitle();
            String description = content == null ? null : content.getDescription();
            NavigationEntry navigationEntry = NavigationEntry.fromResponse(this, response, title, description);
            if (response.isNewNavigationAction()) {
                FramePanel framePanel = this;
                synchronized (framePanel) {
                    this.navigationEngine.addNavigationEntry(navigationEntry);
                }
            }
            if ((wc = this.getWindowCallback()) != null) {
                wc.handleDocumentRendering(this, response, content);
            }
        }
        this.dispatchContentSet(new ContentEvent(this, content, response));
    }

    public void clear() {
        this.removeAll();
        this.content = null;
    }

    private Window getWindow() {
        FramePanel kpf = this.knownParentFrame;
        if (kpf != null) {
            return kpf.getWindow();
        }
        Container parent = this.getParent();
        if (parent instanceof FramePanel) {
            return ((FramePanel)parent).getWindow();
        }
        while (parent != null && !(parent instanceof Window)) {
            parent = parent.getParent();
        }
        return (Window)parent;
    }

    @Override
    public void closeWindow() {
        Window window = this.getWindow();
        if (window != null) {
            window.dispose();
        }
    }

    @Override
    public boolean confirm(final String message) {
        return AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                return JOptionPane.showConfirmDialog(FramePanel.this, message) == 0;
            }
        });
    }

    @Override
    public void invokeLater(Runnable runnable) {
        EventQueue.invokeLater(runnable);
    }

    @Override
    public final void navigate(String urlOrPath) throws MalformedURLException {
        URL url = Urls.guessURL(urlOrPath);
        this.navigate(url, "GET", null, TargetType.SELF, RequestType.PROGRAMMATIC);
    }

    @Override
    public final void navigate(String urlOrPath, RequestType requestType) throws MalformedURLException {
        URL url = Urls.guessURL(urlOrPath);
        this.navigate(url, "GET", null, TargetType.SELF, requestType);
    }

    @Override
    public void navigate(URL url, String method, ParameterInfo paramInfo, TargetType type, RequestType requestType) {
        this.navigate(url, method, paramInfo, type, requestType, this);
    }

    @Override
    public void navigate(URL url, String method, ParameterInfo paramInfo, TargetType type, RequestType requestType, NavigatorFrame originatingFrame) {
        NavigationEvent event = new NavigationEvent(this, url, method, paramInfo, type, requestType, originatingFrame);
        this.navigate(event);
    }

    private void navigate(NavigationEvent event) {
        try {
            this.dispatchBeforeNavigate(event);
        }
        catch (NavigationVetoException nve) {
            if (logger.isLoggable(Level.INFO)) {
                logger.info("navigateLocal(): Navigation was vetoed: " + nve.getMessage());
            }
            return;
        }
        TargetType type = event.getTargetType();
        URL url = event.getURL();
        String method = event.getMethod();
        ParameterInfo paramInfo = event.getParamInfo();
        RequestType requestType = event.getRequestType();
        switch (type) {
            case PARENT: {
                NavigatorFrame parent = this.getParentFrame();
                if (parent != null) {
                    parent.navigate(url, method, paramInfo, TargetType.SELF, requestType, this);
                    break;
                }
                this.navigateLocal(event);
                break;
            }
            case TOP: {
                NavigatorFrame top = this.getTopFrame();
                if (top == this) {
                    this.navigateLocal(event);
                    break;
                }
                top.navigate(url, method, paramInfo, TargetType.SELF, requestType, this);
                break;
            }
            case SELF: {
                this.navigateLocal(event);
                break;
            }
            case BLANK: {
                this.open(url, method, paramInfo);
            }
        }
    }

    private void navigateToHistoryEntry(URL url) {
        this.navigateLocal(url, "GET", RequestType.HISTORY, this);
    }

    protected boolean isOKToAddReferrer(RequestType requestType) {
        return requestType == RequestType.CLICK || requestType == RequestType.PROGRAMMATIC || requestType == RequestType.PROGRAMMATIC_FROM_CLICK || requestType == RequestType.OPEN_WINDOW || requestType == RequestType.OPEN_WINDOW_FROM_CLICK || requestType == RequestType.FORM;
    }

    private void navigateLocal(URL url, String method, RequestType requestType, FramePanel originatingFrame) {
        NavigationEvent event = new NavigationEvent(this, url, method, requestType, originatingFrame);
        this.navigateLocal(event);
    }

    private void navigateLocal(NavigationEvent event) {
        NavigationEntry entry;
        try {
            this.dispatchBeforeLocalNavigate(event);
        }
        catch (NavigationVetoException nve) {
            if (logger.isLoggable(Level.INFO)) {
                logger.info("navigateLocal(): Navigation was vetoed: " + nve.getMessage());
            }
            return;
        }
        String referrer = null;
        RequestType requestType = event.getRequestType();
        URL url = event.getURL();
        String method = event.getMethod();
        ParameterInfo paramInfo = event.getParamInfo();
        if (this.isOKToAddReferrer(requestType) && (entry = this.getCurrentNavigationEntry()) != null) {
            referrer = entry.getUrl().toExternalForm();
        }
        ClientletRequestImpl request = new ClientletRequestImpl(false, url, method, paramInfo, null, referrer, null, requestType);
        final ClientletRequestHandler handler = new ClientletRequestHandler(request, this.getWindowCallback(), this);
        SecurityManager sm = System.getSecurityManager();
        if (sm == null) {
            RequestEngine.getInstance().scheduleRequest(handler);
        } else {
            AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    RequestEngine.getInstance().scheduleRequest(handler);
                    return null;
                }
            });
        }
    }

    @Override
    public final NavigatorFrame open(String urlOrPath) throws MalformedURLException {
        URL url = Urls.guessURL(urlOrPath);
        return this.open(url, null);
    }

    @Override
    public final NavigatorFrame open(URL url, Properties windowProperties) {
        return this.open(url, null, windowProperties);
    }

    public final NavigatorFrame open(URL url, String windowId, Properties windowProperties) {
        return this.open(url, "GET", null, windowId, windowProperties);
    }

    @Override
    public final NavigatorFrame open(URL url) {
        return this.open(url, null);
    }

    @Override
    public NavigatorFrame open(URL url, String method, ParameterInfo pinfo, String windowId, Properties windowProperties) {
        NavigationEvent event = new NavigationEvent(this, url, method, pinfo, TargetType.BLANK, RequestType.OPEN_WINDOW, this);
        try {
            this.dispatchBeforeWindowOpen(event);
        }
        catch (NavigationVetoException nve) {
            if (logger.isLoggable(Level.INFO)) {
                logger.info("navigateLocal(): Navigation was vetoed: " + nve.getMessage());
            }
            return null;
        }
        return FramePanel.openWindow(this, url, windowId, windowProperties, method, pinfo);
    }

    @Override
    public final NavigatorFrame open(URL url, String method, ParameterInfo pinfo) {
        return this.open(url, method, pinfo, null, null);
    }

    public static NavigatorFrame openWindow(final FramePanel opener, URL url, final String windowId, final Properties windowProperties, String method, ParameterInfo pinfo) {
        ClientletRequestImpl request = new ClientletRequestImpl(true, url, method, pinfo, RequestType.OPEN_WINDOW);
        final NavigatorWindowImpl wcontext = AccessController.doPrivileged(new PrivilegedAction<NavigatorWindowImpl>(){

            @Override
            public NavigatorWindowImpl run() {
                return new NavigatorWindowImpl(opener, windowId, windowProperties);
            }
        });
        FramePanel newFrame = wcontext.getFramePanel();
        final ClientletRequestHandler handler = new ClientletRequestHandler(request, wcontext, newFrame);
        handler.evtProgress.addListener(new GenericEventListener(){

            @Override
            public void processEvent(EventObject event) {
                NavigatorProgressEvent pe = (NavigatorProgressEvent)event;
                if (pe == null || pe.getProgressType() == ProgressType.DONE) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            wcontext.resetAsNavigator(handler.getContextWindowProperties());
                        }
                    });
                    handler.evtProgress.removeListener(this);
                } else {
                    wcontext.updatePreNavigationProgress(pe);
                }
            }
        });
        SecurityManager sm = System.getSecurityManager();
        if (sm == null) {
            RequestEngine.getInstance().scheduleRequest(handler);
        } else {
            AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    RequestEngine.getInstance().scheduleRequest(handler);
                    return null;
                }
            });
        }
        return newFrame;
    }

    @Override
    public String prompt(final String message, final String inputDefault) {
        return AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return JOptionPane.showInputDialog(FramePanel.this, message, inputDefault);
            }
        });
    }

    @Override
    public void windowToBack() {
        Window window = this.getWindow();
        if (window != null) {
            window.toBack();
        }
    }

    @Override
    public void windowToFront() {
        Window window = this.getWindow();
        if (window != null) {
            window.toFront();
        }
        this.grabFocus();
    }

    @Override
    public void alert(final String message) {
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                JOptionPane.showMessageDialog(FramePanel.this, message);
                return null;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean goTo(NavigationEntry entry) {
        if (!"GET".equals(entry.getMethod())) {
            throw new IllegalArgumentException("Method only accepts entries with GET method.");
        }
        this.navigateToHistoryEntry(entry.getUrl());
        FramePanel framePanel = this;
        synchronized (framePanel) {
            return this.navigationEngine.moveTo(entry);
        }
    }

    @Override
    public boolean back() {
        return this.moveNavigation(-1);
    }

    @Override
    public boolean forward() {
        return this.moveNavigation(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean moveNavigation(int offset) {
        if (offset == 0 || offset > 1 || offset < -1) {
            throw new IllegalArgumentException("offset: only +1 or -1 are allowed");
        }
        FramePanel framePanel = this;
        synchronized (framePanel) {
            NavigationEntry newEntry;
            do {
                if ((newEntry = this.navigationEngine.move(offset)) != null) continue;
                return false;
            } while (!"GET".equals(newEntry.getMethod()));
            this.navigateToHistoryEntry(newEntry.getUrl());
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean canForward() {
        FramePanel framePanel = this;
        synchronized (framePanel) {
            return this.navigationEngine.hasNextWithGET();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean canBack() {
        FramePanel framePanel = this;
        synchronized (framePanel) {
            return this.navigationEngine.hasPrevWithGET();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reload() {
        NavigationEntry entry;
        FramePanel framePanel = this;
        synchronized (framePanel) {
            entry = this.navigationEngine.getCurrentEntry();
        }
        if (entry != null) {
            String method = entry.getMethod();
            if (!"GET".equals(method)) {
                String lineBreak = System.getProperty("line.separator");
                this.alert("Reloading a document not obtained with the GET " + lineBreak + "method is disallowed for security reasons." + lineBreak + "The request method of the current page is " + method + ".");
            } else {
                this.navigateLocal(entry.getUrl(), entry.getMethod(), RequestType.SOFT_RELOAD, this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean canReload() {
        NavigationEntry entry;
        FramePanel framePanel = this;
        synchronized (framePanel) {
            entry = this.navigationEngine.getCurrentEntry();
        }
        return entry != null;
    }

    @Override
    public NavigatorFrame createFrame() {
        return FramePanelFactorySource.getInstance().getActiveFactory().createFramePanel(this);
    }

    @Override
    public String getDefaultStatus() {
        WindowCallback wc = this.getWindowCallback();
        if (wc != null) {
            return wc.getDefaultStatus();
        }
        return null;
    }

    public Object getItem(String name) {
        return Items.getItem(this, name);
    }

    @Override
    public NavigatorFrame getOpenerFrame() {
        return this.openerFrame;
    }

    @Override
    public String getStatus() {
        WindowCallback wc = this.getWindowCallback();
        if (wc != null) {
            return wc.getStatus();
        }
        return null;
    }

    @Override
    public String getWindowId() {
        return this.windowId;
    }

    @Override
    public boolean isWindowClosed() {
        Window window = this.getWindow();
        if (window != null) {
            return !window.isDisplayable();
        }
        return true;
    }

    @Override
    public void setDefaultStatus(String value) {
        WindowCallback wc = this.getWindowCallback();
        if (wc != null) {
            wc.setDefaultStatus(this, value);
        }
    }

    public void setItem(String name, Object value) {
        Items.setItem(this, name, value);
    }

    @Override
    public void setStatus(String status) {
        WindowCallback wc = this.getWindowCallback();
        if (wc != null) {
            wc.setStatus(this, status);
        }
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.isPreferredSizeSet()) {
            return super.getPreferredSize();
        }
        return new Dimension(600, 400);
    }

    @Override
    public Dimension getMinimumSize() {
        return new Dimension(1, 1);
    }

    @Override
    public Dimension getMaximumSize() {
        return new Dimension(Short.MAX_VALUE, Short.MAX_VALUE);
    }

    @Override
    public ComponentContent getComponentContent() {
        return this.content;
    }

    @Override
    public String getSourceCode() {
        ComponentContent content = this.content;
        return content == null ? null : content.getSourceCode();
    }

    @Override
    public final void navigate(URL url) {
        this.navigate(url, RequestType.PROGRAMMATIC);
    }

    @Override
    public final void navigate(URL url, RequestType requestType) {
        this.navigate(url, "GET", null, TargetType.SELF, requestType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NavigationEntry getCurrentNavigationEntry() {
        FramePanel framePanel = this;
        synchronized (framePanel) {
            return this.navigationEngine.getCurrentEntry();
        }
    }

    @Override
    public NavigatorProgressEvent getProgressEvent() {
        return this.progressEvent;
    }

    @Override
    public void setProgressEvent(NavigatorProgressEvent event) {
        WindowCallback wc;
        this.progressEvent = event;
        if (event != null && (wc = this.getWindowCallback()) != null) {
            wc.updateProgress(event);
        }
    }

    @Override
    public NetworkRequest createNetworkRequest() {
        return new NetworkRequestImpl();
    }

    @Override
    public String toString() {
        return "FramePanel[windowId=" + this.windowId + ",hashCode=" + this.hashCode() + ",parent=" + this.getParent() + "]";
    }

    @Override
    public void resizeWindowBy(int byWidth, int byHeight) {
        Window window = this.getWindow();
        if (logger.isLoggable(Level.INFO)) {
            logger.info("resizeWindowBy(): byWidth=" + byWidth + ",byHeight=" + byHeight + "; window=" + window);
        }
        if (window != null) {
            window.setSize(window.getWidth() + byWidth, window.getHeight() + byHeight);
        }
    }

    @Override
    public void resizeWindowTo(int width, int height) {
        Window window = this.getWindow();
        if (logger.isLoggable(Level.INFO)) {
            logger.info("resizeWindowTo(): width=" + width + ",height=" + height + "; window=" + window);
        }
        if (window != null) {
            window.setSize(width, height);
        }
    }

    public Window getTopFrameWindow() {
        return this.topFrameWindow;
    }

    public void setTopFrameWindow(Window topFrameWindow) {
        this.topFrameWindow = topFrameWindow;
    }

    public Object getContentObject() {
        ComponentContent content = this.getComponentContent();
        return content == null ? null : content.getContentObject();
    }

    public String getCurrentMimeType() {
        ComponentContent content = this.getComponentContent();
        return content == null ? null : content.getMimeType();
    }

    @Override
    public void linkClicked(URL url, TargetType targetType, Object linkObject) {
        NavigationEvent event = new NavigationEvent(this, url, targetType, RequestType.CLICK, linkObject, this);
        this.navigate(event);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getHistoryLength() {
        FramePanel framePanel = this;
        synchronized (framePanel) {
            return this.navigationEngine.getLength();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NavigationEntry getNextNavigationEntry() {
        FramePanel framePanel = this;
        synchronized (framePanel) {
            NavigationEntry[] entries = this.navigationEngine.getForwardNavigationEntries();
            return entries.length == 0 ? null : entries[0];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NavigationEntry getPreviousNavigationEntry() {
        FramePanel framePanel = this;
        synchronized (framePanel) {
            NavigationEntry[] entries = this.navigationEngine.getBackNavigationEntries();
            return entries.length == 0 ? null : entries[0];
        }
    }

    @Override
    public void moveInHistory(int offset) {
        this.moveNavigation(offset);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void navigateInHistory(String absoluteURL) {
        NavigationEntry entry;
        FramePanel framePanel = this;
        synchronized (framePanel) {
            entry = this.navigationEngine.findEntry(absoluteURL);
        }
        if (entry != null) {
            this.navigateToHistoryEntry(entry.getUrl());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setProperty(String name, Object value) {
        ComponentContent content = this.getComponentContent();
        Object object = this.propertiesMonitor;
        synchronized (object) {
            HashMap<String, Object> props;
            if (content != null) {
                content.setProperty(name, value);
            }
            if ((props = this.contentProperties) == null) {
                this.contentProperties = props = new HashMap<String, Object>(5);
            }
            props.put(name, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateContentProperties(ComponentContent content) {
        Object object = this.propertiesMonitor;
        synchronized (object) {
            Map props = this.contentProperties;
            if (props != null) {
                for (Map.Entry entry : props.entrySet()) {
                    content.setProperty((String)entry.getKey(), entry.getValue());
                }
            }
        }
    }
}

