/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.html.domimpl;

import org.lobobrowser.html.domimpl.DOMCharacterDataImpl;
import org.lobobrowser.html.domimpl.DOMNodeImpl;
import org.lobobrowser.util.Strings;
import org.w3c.dom.DOMException;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class DOMTextImpl
extends DOMCharacterDataImpl
implements Text {
    public DOMTextImpl() {
        this("");
    }

    public DOMTextImpl(String text) {
        this.text = text;
    }

    @Override
    public boolean isElementContentWhitespace() {
        String t = this.text;
        return t == null || t.trim().equals("");
    }

    @Override
    public Text replaceWholeText(String content) throws DOMException {
        DOMNodeImpl parent = (DOMNodeImpl)this.getParentNode();
        if (parent == null) {
            throw new DOMException(3, "Text node has no parent");
        }
        return parent.replaceAdjacentTextNodes(this, content);
    }

    @Override
    public Text splitText(int offset) throws DOMException {
        DOMNodeImpl parent = (DOMNodeImpl)this.getParentNode();
        if (parent == null) {
            throw new DOMException(3, "Text node has no parent");
        }
        String t = this.text;
        if (offset < 0 || offset > t.length()) {
            throw new DOMException(1, "Bad offset: " + offset);
        }
        String content1 = t.substring(0, offset);
        String content2 = t.substring(offset);
        this.text = content1;
        DOMTextImpl newNode = new DOMTextImpl(content2);
        newNode.setOwnerDocument(this.document);
        return (Text)parent.insertAfter(newNode, this);
    }

    @Override
    public String getWholeText() {
        DOMNodeImpl parent = (DOMNodeImpl)this.getParentNode();
        if (parent == null) {
            throw new DOMException(3, "Text node has no parent");
        }
        return parent.getTextContent();
    }

    @Override
    public String getLocalName() {
        return null;
    }

    @Override
    public String getNodeName() {
        return "#text";
    }

    @Override
    public short getNodeType() {
        return 3;
    }

    @Override
    public String getNodeValue() throws DOMException {
        return this.text;
    }

    @Override
    public void setNodeValue(String nodeValue) throws DOMException {
        this.text = nodeValue;
    }

    @Override
    public void setTextContent(String textContent) throws DOMException {
        this.text = textContent;
    }

    @Override
    protected Node createSimilarNode() {
        return new DOMTextImpl(this.text);
    }

    @Override
    public String toString() {
        String text = this.text;
        int textLength = text == null ? 0 : text.length();
        return "#text[length=" + textLength + ",value=\"" + Strings.truncate(text, 64) + "\",renderState=" + this.getRenderState() + "]";
    }
}

