/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.html.style;

import com.steadystate.css.dom.CSSStyleSheetImpl;
import com.steadystate.css.parser.CSSOMParser;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lobobrowser.html.HttpRequest;
import org.lobobrowser.html.UserAgentContext;
import org.lobobrowser.html.domimpl.HTMLDocumentImpl;
import org.lobobrowser.util.Strings;
import org.lobobrowser.util.Urls;
import org.w3c.css.sac.InputSource;
import org.w3c.dom.Node;
import org.w3c.dom.css.CSSStyleSheet;
import org.w3c.dom.stylesheets.MediaList;

public class CSSUtilities {
    private static final Logger logger = Logger.getLogger(CSSUtilities.class.getName());

    private CSSUtilities() {
    }

    public static String preProcessCss(String text) {
        try {
            String line;
            BufferedReader reader = new BufferedReader(new StringReader(text));
            StringBuffer sb = new StringBuffer();
            String pendingLine = null;
            while ((line = reader.readLine()) != null) {
                String tline = line.trim();
                if (tline.length() == 0) continue;
                if (pendingLine != null) {
                    sb.append(pendingLine);
                    sb.append("\r\n");
                    pendingLine = null;
                }
                if (tline.startsWith("//")) {
                    pendingLine = line;
                    continue;
                }
                sb.append(line);
                sb.append("\r\n");
            }
            return sb.toString();
        }
        catch (IOException ioe) {
            throw new IllegalStateException(ioe.getMessage());
        }
    }

    public static InputSource getCssInputSourceForStyleSheet(String text, String scriptURI) {
        StringReader reader = new StringReader(text);
        InputSource is = new InputSource(reader);
        is.setURI(scriptURI);
        return is;
    }

    public static CSSStyleSheet parse(Node ownerNode, String href, String text, String baseUri, boolean considerDoubleSlashComments) throws IOException {
        String scriptURI;
        URL baseURL = new URL(baseUri);
        URL scriptURL = Urls.createURL(baseURL, href);
        String string = scriptURI = scriptURL == null ? href : scriptURL.toExternalForm();
        if (text != null && !"".equals(text)) {
            String processedText = considerDoubleSlashComments ? CSSUtilities.preProcessCss(text) : text;
            CSSOMParser parser = new CSSOMParser();
            InputSource is = CSSUtilities.getCssInputSourceForStyleSheet(processedText, scriptURI);
            is.setURI(scriptURI);
            CSSStyleSheetImpl sheet = (CSSStyleSheetImpl)parser.parseStyleSheet(is, null, null);
            sheet.setHref(scriptURI);
            sheet.setOwnerNode(ownerNode);
            return sheet;
        }
        return null;
    }

    public static CSSStyleSheet parse(Node ownerNode, String text, String baseUri, boolean considerDoubleSlashComments) throws IOException {
        if (text != null && !"".equals(text)) {
            String processedText = considerDoubleSlashComments ? CSSUtilities.preProcessCss(text) : text;
            CSSOMParser parser = new CSSOMParser();
            InputSource is = CSSUtilities.getCssInputSourceForStyleSheet(processedText, baseUri);
            is.setURI(baseUri);
            CSSStyleSheetImpl sheet = (CSSStyleSheetImpl)parser.parseStyleSheet(is, null, null);
            sheet.setHref(baseUri);
            sheet.setOwnerNode(ownerNode);
            return sheet;
        }
        return null;
    }

    public static boolean matchesMedia(String mediaValues, UserAgentContext rcontext) {
        if (mediaValues == null || mediaValues.length() == 0) {
            return true;
        }
        if (rcontext == null) {
            return false;
        }
        StringTokenizer tok = new StringTokenizer(mediaValues, ",");
        while (tok.hasMoreTokens()) {
            String token = tok.nextToken().trim();
            String mediaName = Strings.trimForAlphaNumDash(token);
            if (!rcontext.isMedia(mediaName)) continue;
            return true;
        }
        return false;
    }

    public static boolean matchesMedia(MediaList mediaList, UserAgentContext rcontext) {
        if (mediaList == null) {
            return true;
        }
        int length = mediaList.getLength();
        if (length == 0) {
            return true;
        }
        if (rcontext == null) {
            return false;
        }
        for (int i = 0; i < length; ++i) {
            String mediaName = mediaList.item(i);
            if (!rcontext.isMedia(mediaName)) continue;
            return true;
        }
        return false;
    }

    public static ArrayList<String> cssText(String href, HTMLDocumentImpl doc, String baseUri) throws MalformedURLException, UnsupportedEncodingException {
        String script;
        UserAgentContext bcontext = doc.getUserAgentContext();
        final HttpRequest request = bcontext.createHttpRequest();
        URL baseURL = new URL(baseUri);
        URL scriptURL = Urls.createURL(baseURL, href);
        String responseText = "";
        String string = script = scriptURL == null ? href : scriptURL.toExternalForm();
        if (script != null && (script.contains(".com") || script.contains(".it"))) {
            script = script.replace("file://", "http://");
        }
        final String scriptURI = script;
        SecurityManager sm = System.getSecurityManager();
        if (sm == null) {
            try {
                request.open("GET", scriptURI, false);
                request.send(null);
            }
            catch (IOException thrown) {
                logger.log(Level.WARNING, "processScript()", thrown);
            }
        } else {
            AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    try {
                        request.open("GET", scriptURI, false);
                        request.send(null);
                    }
                    catch (IOException thrown) {
                        logger.log(Level.WARNING, "parse()", thrown);
                    }
                    return null;
                }
            });
        }
        int status = request.getStatus();
        responseText = status != 200 && status != 0 ? CSSUtilities.httpURLConnection(scriptURI) : request.getResponseText();
        return CSSUtilities.cssText(responseText);
    }

    private static String httpURLConnection(String url) {
        StringBuffer response = new StringBuffer();
        int responseCode = -1;
        try {
            String inputLine;
            URL obj = new URL(url);
            HttpURLConnection con = (HttpURLConnection)obj.openConnection();
            con.setRequestMethod("GET");
            responseCode = con.getResponseCode();
            BufferedReader in = new BufferedReader(new InputStreamReader(con.getInputStream()));
            while ((inputLine = in.readLine()) != null) {
                response.append(inputLine);
            }
            in.close();
        }
        catch (Exception e) {
            logger.warning("Unable to parse CSS. URI=[" + url + "]. Response status was " + responseCode + ".");
            return "";
        }
        return response.toString();
    }

    public static ArrayList<String> cssText(String text) throws MalformedURLException {
        ArrayList<String> listText = new ArrayList<String>();
        text = text.replaceAll("\n", "").replaceAll("\r", "").replaceAll("}", "}\n");
        String[] splitString = text.split("\n");
        for (int i = 0; i < splitString.length; ++i) {
            String str = splitString[i];
            if (str == null || str.length() <= 0 || (str = str.trim()).length() <= 1 || !str.endsWith("}")) continue;
            if (str.contains("media")) {
                listText.add(CSSUtilities.fixMediaQueryString(str + "}"));
                continue;
            }
            listText.add(CSSUtilities.fixString(str));
        }
        return listText;
    }

    private static String fixMediaQueryString(String css) {
        int counter1;
        String stringFixed = "";
        boolean app = false;
        String[] b = css.split("\\ ");
        for (int i = 0; i < b.length; ++i) {
            String split = b[i];
            if (!(split.startsWith("filter:") || split.startsWith("-ms") || split.startsWith("-moz") || split.startsWith("*") || split.startsWith("-webkit") || app)) {
                app = false;
                stringFixed = stringFixed + " " + b[i];
                continue;
            }
            app = !app;
        }
        int counter = CSSUtilities.countChar(stringFixed, "{");
        if (counter < (counter1 = CSSUtilities.countChar(stringFixed, "}"))) {
            stringFixed = stringFixed.replace("}}", "}");
        }
        return stringFixed.trim();
    }

    private static String fixString(String css) {
        String stringFixed = "";
        String result = "";
        String[] b = css.split("\\{");
        if (b.length != 1) {
            String str = b[1];
            String[] strSpli = str.split(";");
            for (int i = 0; i < strSpli.length; ++i) {
                String split = strSpli[i];
                if (!(split.startsWith("filter:") || split.startsWith("-ms") || split.startsWith("-moz") || split.startsWith("*") || split.startsWith("-webkit"))) {
                    stringFixed = split.contains("url(") ? stringFixed + split.replace("\\", "").trim() : stringFixed + split.replace("\\", "").replace("/", "").trim();
                    if (stringFixed.endsWith("}")) continue;
                    stringFixed = stringFixed + ";";
                    continue;
                }
                if (!split.endsWith("}")) continue;
                stringFixed = stringFixed + "}";
            }
            result = b[0] + "{" + stringFixed.trim();
        }
        return result;
    }

    private static int countChar(String str, String str1) {
        int occurrences = 0;
        for (char c : str.toCharArray()) {
            if (c != str1.charAt(0)) continue;
            ++occurrences;
        }
        return occurrences;
    }
}

