/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.main;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Random;
import org.lobobrowser.main.PlatformInit;

public class ReuseServer
implements Runnable {
    private static final int MIN_PORT = 55000;
    private static final int TOP_PORT = 65000;
    private static final Random RAND = new Random(System.currentTimeMillis());
    private ServerSocket serverSocket;

    public ReuseServer() {
        Thread t = new Thread((Runnable)this, "ReuseServer");
        t.setDaemon(true);
        t.start();
    }

    private static int getRandomPort() {
        return Math.abs(RAND.nextInt()) % 10000 + 55000;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int start(InetAddress bindAddr) {
        ReuseServer reuseServer = this;
        synchronized (reuseServer) {
            if (this.serverSocket != null) {
                throw new IllegalStateException("Already started");
            }
            for (int tries = 0; tries < 100; ++tries) {
                int rport = ReuseServer.getRandomPort();
                try {
                    ServerSocket ss;
                    this.serverSocket = ss = new ServerSocket(rport, 100, bindAddr);
                    this.notify();
                    return rport;
                }
                catch (IOException ioe) {
                    ioe.printStackTrace(System.err);
                    continue;
                }
            }
        }
        throw new IllegalStateException("Unable to bind reuse server after many tries.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        ReuseServer reuseServer = this;
        synchronized (reuseServer) {
            if (this.serverSocket != null) {
                try {
                    this.serverSocket.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                this.serverSocket = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (true) {
            try {
                block9: while (true) {
                    ServerSocket ss;
                    ReuseServer reuseServer = this;
                    synchronized (reuseServer) {
                        while (this.serverSocket == null) {
                            this.wait();
                        }
                        ss = this.serverSocket;
                    }
                    Socket s = ss.accept();
                    s.setSoTimeout(10000);
                    s.setTcpNoDelay(true);
                    InputStream in = s.getInputStream();
                    try {
                        InputStreamReader reader = new InputStreamReader(in);
                        BufferedReader br = new BufferedReader(reader);
                        while (true) {
                            String command;
                            String line;
                            if ((line = br.readLine()) == null) continue block9;
                            int blankIdx = line.indexOf(32);
                            String string = command = blankIdx == -1 ? line : line.substring(0, blankIdx).trim();
                            if ("LAUNCH".equals(command)) {
                                if (blankIdx == -1) {
                                    PlatformInit.getInstance().launch();
                                    continue;
                                }
                                String path = line.substring(blankIdx + 1).trim();
                                PlatformInit.getInstance().launch(path);
                                continue;
                            }
                            if (!"LAUNCH_BLANK".equals(command)) continue;
                            PlatformInit.getInstance().launch();
                        }
                    }
                    finally {
                        in.close();
                        continue;
                    }
                    break;
                }
            }
            catch (Throwable t) {
                t.printStackTrace(System.err);
                continue;
            }
            break;
        }
    }
}

