/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.primary.clientlets.download;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.lobobrowser.clientlet.CancelClientletException;
import org.lobobrowser.clientlet.Clientlet;
import org.lobobrowser.clientlet.ClientletContext;
import org.lobobrowser.clientlet.ClientletException;
import org.lobobrowser.clientlet.ClientletResponse;
import org.lobobrowser.primary.gui.download.DownloadDialog;
import org.lobobrowser.util.Strings;
import org.lobobrowser.util.Urls;

public class DownloadClientlet
implements Clientlet {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void process(ClientletContext context) throws ClientletException {
        ClientletResponse response = context.getResponse();
        URL url = response.getResponseURL();
        if (url.getProtocol().equals("file") && "".equals(url.getHost())) {
            String shorterPath = Strings.truncate(Urls.getNoRefForm(url), 64);
            context.getNavigatorFrame().alert("There are no extensions that can render\r\n" + shorterPath + ".");
            throw new CancelClientletException("cancel");
        }
        if (!"GET".equals(response.getLastRequestMethod())) {
            String shorterPath = Strings.truncate(Urls.getNoRefForm(url), 64);
            context.getNavigatorFrame().alert("Cannot download document that is not accessed with method GET:\r\n" + shorterPath + ".");
            throw new CancelClientletException("cancel");
        }
        int transferSpeed = -1;
        int contentLength = response.getContentLength();
        if (contentLength > 0) {
            try {
                InputStream in = response.getInputStream();
                try {
                    int numRead;
                    long baseTime = System.currentTimeMillis();
                    long maxElapsed = 1000L;
                    byte[] buffer = new byte[4096];
                    int totalRead = 0;
                    while (System.currentTimeMillis() - baseTime < maxElapsed && (numRead = in.read(buffer)) != -1) {
                        totalRead += numRead;
                    }
                    long elapsed = System.currentTimeMillis() - baseTime;
                    if (elapsed > 0L) {
                        transferSpeed = (int)Math.round((double)totalRead / (double)elapsed);
                    }
                }
                finally {
                    in.close();
                }
            }
            catch (IOException ioe) {
                throw new ClientletException(ioe);
            }
        }
        DownloadDialog dialog = new DownloadDialog(response, url, transferSpeed);
        dialog.setTitle("Download " + Urls.getNoRefForm(url));
        dialog.pack();
        dialog.setLocationByPlatform(true);
        dialog.setVisible(true);
        throw new CancelClientletException("download");
    }
}

