/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.primary.gui;

import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.HeadlessException;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import org.lobobrowser.primary.action.SearchCancelAction;
import org.lobobrowser.primary.action.SearchOkAction;
import org.lobobrowser.primary.gui.FieldType;
import org.lobobrowser.primary.gui.FormField;
import org.lobobrowser.primary.gui.FormPanel;

public class SearchDialog
extends JDialog {
    private static final long serialVersionUID = 1L;
    private final FormField tagsField = new FormField(FieldType.TEXT, "Keywords:");
    private String searchKeywords = null;

    public SearchDialog(Frame owner, boolean modal, String keywordsTooltip) throws HeadlessException {
        super(owner, modal);
        this.setDefaultCloseOperation(2);
        this.tagsField.setToolTip(keywordsTooltip);
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BoxLayout(contentPane, 1));
        FormPanel fieldsPanel = new FormPanel();
        fieldsPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
        fieldsPanel.addField(this.tagsField);
        contentPane.add(fieldsPanel);
        JPanel buttonsPanel = new JPanel();
        buttonsPanel.setLayout(new BoxLayout(buttonsPanel, 0));
        JButton okButton = new JButton();
        okButton.setAction(new SearchOkAction(this.tagsField, this));
        okButton.setText("Search");
        JButton cancelButton = new JButton();
        cancelButton.setAction(new SearchCancelAction(this));
        cancelButton.setText("Cancel");
        buttonsPanel.add(Box.createHorizontalGlue());
        buttonsPanel.add(okButton);
        buttonsPanel.add(Box.createRigidArea(new Dimension(4, 1)));
        buttonsPanel.add(cancelButton);
        buttonsPanel.add(Box.createHorizontalGlue());
        contentPane.add(buttonsPanel);
        contentPane.add(Box.createRigidArea(new Dimension(1, 4)));
    }

    public String getSearchKeywords() {
        return this.searchKeywords;
    }

    public String setSearchKeywords(String searchKeywords) {
        this.searchKeywords = searchKeywords;
        return this.searchKeywords;
    }
}

