/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.util.gui;

import java.awt.Color;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lobobrowser.util.ColorCommon;

public class ColorFactory {
    private static final Logger logger = Logger.getLogger(ColorFactory.class.getName());
    private static ColorFactory instance;
    public static final Color TRANSPARENT;
    private Map<String, Color> colorMap = new HashMap<String, Color>(510);
    private static final String RGB_START = "rgb(";
    private static final String RGBA_START = "rgba(";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ColorFactory() {
        ColorFactory colorFactory = this;
        synchronized (colorFactory) {
            this.colorMap = ColorCommon.mapColor();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final ColorFactory getInstance() {
        if (instance != null) return instance;
        Class<ColorFactory> clazz = ColorFactory.class;
        synchronized (ColorFactory.class) {
            if (instance != null) return instance;
            instance = new ColorFactory();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isColor(String colorSpec) {
        if (colorSpec.startsWith("#")) {
            return true;
        }
        String normalSpec = colorSpec.toLowerCase();
        if (normalSpec.startsWith(RGBA_START)) {
            return true;
        }
        if (normalSpec.startsWith(RGB_START)) {
            return true;
        }
        ColorFactory colorFactory = this;
        synchronized (colorFactory) {
            return this.colorMap.containsKey(normalSpec);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Color getColor(String colorSpec) {
        String normalSpec = colorSpec.toLowerCase();
        ColorFactory colorFactory = this;
        synchronized (colorFactory) {
            Color color = this.colorMap.get(normalSpec);
            if (color == null) {
                int red = 0;
                int green = 0;
                int blue = 0;
                int alpha = 0;
                if (normalSpec.startsWith(RGBA_START)) {
                    int endIdx = normalSpec.lastIndexOf(41);
                    String commaValues = endIdx == -1 ? normalSpec.substring(RGBA_START.length()) : normalSpec.substring(RGBA_START.length(), endIdx);
                    StringTokenizer tok = new StringTokenizer(commaValues, ",");
                    if (tok.hasMoreTokens()) {
                        String rstr = tok.nextToken().trim();
                        try {
                            red = Integer.parseInt(rstr);
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                        if (tok.hasMoreTokens()) {
                            String gstr = tok.nextToken().trim();
                            try {
                                green = Integer.parseInt(gstr);
                            }
                            catch (NumberFormatException numberFormatException) {
                                // empty catch block
                            }
                            if (tok.hasMoreTokens()) {
                                String bstr = tok.nextToken().trim();
                                try {
                                    blue = Integer.parseInt(bstr);
                                }
                                catch (NumberFormatException numberFormatException) {
                                    // empty catch block
                                }
                                if (tok.hasMoreTokens()) {
                                    String astr = tok.nextToken().trim();
                                    try {
                                        alpha = new Float(255.0f * Float.parseFloat(astr)).intValue();
                                    }
                                    catch (NumberFormatException numberFormatException) {
                                        // empty catch block
                                    }
                                }
                            }
                        }
                    }
                    color = new Color(ColorFactory.normalize(red), ColorFactory.normalize(green), ColorFactory.normalize(blue), alpha);
                } else if (normalSpec.startsWith(RGB_START)) {
                    int endIdx = normalSpec.lastIndexOf(41);
                    String commaValues = endIdx == -1 ? normalSpec.substring(RGB_START.length()) : normalSpec.substring(RGB_START.length(), endIdx);
                    StringTokenizer tok = new StringTokenizer(commaValues, ",");
                    if (tok.hasMoreTokens()) {
                        String rstr = tok.nextToken().trim();
                        try {
                            red = Integer.parseInt(rstr);
                        }
                        catch (NumberFormatException gstr) {
                            // empty catch block
                        }
                        if (tok.hasMoreTokens()) {
                            String gstr = tok.nextToken().trim();
                            try {
                                green = Integer.parseInt(gstr);
                            }
                            catch (NumberFormatException bstr) {
                                // empty catch block
                            }
                            if (tok.hasMoreTokens()) {
                                String bstr = tok.nextToken().trim();
                                try {
                                    blue = Integer.parseInt(bstr);
                                }
                                catch (NumberFormatException numberFormatException) {
                                    // empty catch block
                                }
                            }
                        }
                    }
                    color = new Color(ColorFactory.normalize(red), ColorFactory.normalize(green), ColorFactory.normalize(blue));
                } else if (normalSpec.startsWith("#")) {
                    int len = normalSpec.length();
                    int[] rgba = new int[4];
                    rgba[3] = 255;
                    for (int i = 0; i < rgba.length; ++i) {
                        int idx = 2 * i + 1;
                        if (idx >= len) continue;
                        String hexText = normalSpec.substring(idx, idx + Math.min(2, len - idx));
                        try {
                            rgba[i] = Integer.parseInt(hexText, 16);
                            continue;
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                    }
                    color = new Color(rgba[0], rgba[1], rgba[2], rgba[3]);
                } else {
                    if (logger.isLoggable(Level.INFO)) {
                        logger.warning("getColor(): Color spec [" + normalSpec + "] unknown.");
                    }
                    return Color.RED;
                }
                this.colorMap.put(normalSpec, color);
            }
            return color;
        }
    }

    private static int normalize(int colorComponent) {
        if (colorComponent > 255) {
            colorComponent = 255;
        } else if (colorComponent < 0) {
            colorComponent = 0;
        }
        return colorComponent;
    }

    static {
        TRANSPARENT = new Color(0, 0, 0, 0);
    }
}

