/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.cucumber.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiWhiteSpace;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.cucumber.psi.GherkinElementVisitor;
import org.jetbrains.plugins.cucumber.psi.GherkinTableCell;
import org.jetbrains.plugins.cucumber.psi.GherkinTableRow;
import org.jetbrains.plugins.cucumber.psi.GherkinTokenTypes;
import org.jetbrains.plugins.cucumber.psi.impl.GherkinPsiElementBase;

public class GherkinTableRowImpl
extends GherkinPsiElementBase
implements GherkinTableRow {
    public GherkinTableRowImpl(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/jetbrains/plugins/cucumber/psi/impl/GherkinTableRowImpl", "<init>"));
        }
        super(node);
    }

    @Override
    protected void acceptGherkin(GherkinElementVisitor gherkinElementVisitor) {
        gherkinElementVisitor.visitTableRow(this);
    }

    public String toString() {
        return "GherkinTableRow";
    }

    @NotNull
    public static <T extends PsiElement> List<T> getChildrenByFilter(PsiElement psiElement, Class<T> c) {
        LinkedList list = new LinkedList();
        for (PsiElement element : psiElement.getChildren()) {
            if (!c.isInstance(element)) continue;
            list.add(element);
        }
        List list2 = list.isEmpty() ? Collections.emptyList() : list;
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/cucumber/psi/impl/GherkinTableRowImpl", "getChildrenByFilter"));
        }
        return list2;
    }

    @Override
    @NotNull
    public List<GherkinTableCell> getPsiCells() {
        List<GherkinTableCell> list = GherkinTableRowImpl.getChildrenByFilter(this, GherkinTableCell.class);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/cucumber/psi/impl/GherkinTableRowImpl", "getPsiCells"));
        }
        return list;
    }

    @Override
    public int getColumnWidth(int columnIndex) {
        List<GherkinTableCell> cells = this.getPsiCells();
        if (cells.size() <= columnIndex) {
            return 0;
        }
        PsiElement cell = cells.get(columnIndex);
        if (cell != null && cell.getText() != null) {
            return cell.getText().trim().length();
        }
        return 0;
    }

    @Override
    public void deleteCell(int columnIndex) {
        List<GherkinTableCell> cells = this.getPsiCells();
        if (columnIndex < cells.size()) {
            PsiElement cell = cells.get(columnIndex);
            PsiElement nextPipe = cell.getNextSibling();
            if (nextPipe instanceof PsiWhiteSpace) {
                nextPipe = nextPipe.getNextSibling();
            }
            if (nextPipe != null && nextPipe.getNode().getElementType() == GherkinTokenTypes.PIPE) {
                nextPipe.delete();
            }
            cell.delete();
        }
    }
}

