/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.cucumber.java.steps;

import com.intellij.codeInsight.CodeInsightUtilCore;
import com.intellij.codeInsight.template.TemplateBuilder;
import com.intellij.codeInsight.template.TemplateBuilderFactory;
import com.intellij.lang.Language;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JVMElementFactories;
import com.intellij.psi.JVMElementFactory;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassOwner;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.impl.file.PsiDirectoryFactory;
import com.intellij.psi.util.CreateClassUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ObjectUtils;
import cucumber.runtime.snippets.CamelCaseConcatenator;
import cucumber.runtime.snippets.Concatenator;
import cucumber.runtime.snippets.FunctionNameGenerator;
import cucumber.runtime.snippets.Snippet;
import cucumber.runtime.snippets.SnippetGenerator;
import gherkin.formatter.model.Step;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.cucumber.AbstractStepDefinitionCreator;
import org.jetbrains.plugins.cucumber.java.CucumberJavaUtil;
import org.jetbrains.plugins.cucumber.java.steps.AnnotationPackageProvider;
import org.jetbrains.plugins.cucumber.java.steps.JavaSnippet;
import org.jetbrains.plugins.cucumber.psi.GherkinStep;

public class JavaStepDefinitionCreator
extends AbstractStepDefinitionCreator {
    public static final String STEP_DEFINITION_SUFFIX = "MyStepdefs";

    @NotNull
    public PsiFile createStepDefinitionContainer(@NotNull PsiDirectory dir, @NotNull String name) {
        if (dir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dir", "org/jetbrains/plugins/cucumber/java/steps/JavaStepDefinitionCreator", "createStepDefinitionContainer"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/plugins/cucumber/java/steps/JavaStepDefinitionCreator", "createStepDefinitionContainer"));
        }
        PsiClass newClass = CreateClassUtil.createClassNamed((String)name, (String)"#DEFAULT_CLASS_TEMPLATE", (PsiDirectory)dir);
        assert (newClass != null);
        PsiFile psiFile = newClass.getContainingFile();
        if (psiFile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/cucumber/java/steps/JavaStepDefinitionCreator", "createStepDefinitionContainer"));
        }
        return psiFile;
    }

    public boolean createStepDefinition(@NotNull GherkinStep step, @NotNull PsiFile file) {
        if (step == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "step", "org/jetbrains/plugins/cucumber/java/steps/JavaStepDefinitionCreator", "createStepDefinition"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/plugins/cucumber/java/steps/JavaStepDefinitionCreator", "createStepDefinition"));
        }
        if (!(file instanceof PsiClassOwner)) {
            return false;
        }
        Project project = file.getProject();
        Editor editor = FileEditorManager.getInstance((Project)project).getSelectedTextEditor();
        assert (editor != null);
        this.closeActiveTemplateBuilders(file);
        PsiClass clazz = (PsiClass)PsiTreeUtil.getChildOfType((PsiElement)file, PsiClass.class);
        if (clazz != null) {
            PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
            PsiMethod element = JavaStepDefinitionCreator.buildStepDefinitionByStep(step, file.getLanguage());
            PsiMethod addedElement = (PsiMethod)clazz.add((PsiElement)element);
            addedElement = (PsiMethod)CodeInsightUtilCore.forcePsiPostprocessAndRestoreElement((PsiElement)addedElement);
            JavaCodeStyleManager.getInstance((Project)project).shortenClassReferences((PsiElement)addedElement);
            editor = FileEditorManager.getInstance((Project)project).getSelectedTextEditor();
            assert (editor != null);
            PsiParameterList blockVars = addedElement.getParameterList();
            PsiCodeBlock body = addedElement.getBody();
            PsiAnnotation annotation = addedElement.getModifierList().getAnnotations()[0];
            PsiNameValuePair regexpElement = annotation.getParameterList().getAttributes()[0];
            this.runTemplateBuilderOnAddedStep(editor, (PsiElement)addedElement, (PsiElement)regexpElement, blockVars, body);
        }
        return true;
    }

    protected void runTemplateBuilderOnAddedStep(Editor editor, PsiElement addedElement, PsiElement regexpElement, PsiParameterList blockVars, PsiCodeBlock body) {
        Project project = regexpElement.getProject();
        TemplateBuilder builder = TemplateBuilderFactory.getInstance().createTemplateBuilder(addedElement);
        TextRange range = new TextRange(1, regexpElement.getTextLength() - 1);
        builder.replaceElement(regexpElement, range, regexpElement.getText().substring(range.getStartOffset(), range.getEndOffset()));
        for (PsiParameter var : blockVars.getParameters()) {
            PsiIdentifier nameIdentifier = var.getNameIdentifier();
            if (nameIdentifier == null) continue;
            builder.replaceElement((PsiElement)nameIdentifier, nameIdentifier.getText());
        }
        if (body.getStatements().length > 0) {
            PsiStatement firstStatement = body.getStatements()[0];
            TextRange pendingRange = new TextRange(0, firstStatement.getTextLength() - 1);
            builder.replaceElement((PsiElement)firstStatement, pendingRange, firstStatement.getText().substring(pendingRange.getStartOffset(), pendingRange.getEndOffset()));
        }
        PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)project);
        documentManager.doPostponedOperationsAndUnblockDocument(editor.getDocument());
        builder.run(editor, false);
    }

    public boolean validateNewStepDefinitionFileName(@NotNull Project project, @NotNull String name) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/plugins/cucumber/java/steps/JavaStepDefinitionCreator", "validateNewStepDefinitionFileName"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/plugins/cucumber/java/steps/JavaStepDefinitionCreator", "validateNewStepDefinitionFileName"));
        }
        if (name.length() == 0) {
            return false;
        }
        if (!Character.isJavaIdentifierStart(name.charAt(0))) {
            return false;
        }
        for (int i = 1; i < name.length(); ++i) {
            if (Character.isJavaIdentifierPart(name.charAt(i))) continue;
            return false;
        }
        return true;
    }

    @NotNull
    public PsiDirectory getDefaultStepDefinitionFolder(@NotNull GherkinStep step) {
        if (step == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "step", "org/jetbrains/plugins/cucumber/java/steps/JavaStepDefinitionCreator", "getDefaultStepDefinitionFolder"));
        }
        PsiFile featureFile = step.getContainingFile();
        if (featureFile != null) {
            VirtualFile directory;
            ProjectFileIndex projectFileIndex;
            PsiDirectory psiDirectory = featureFile.getContainingDirectory();
            final Project project = step.getProject();
            if (psiDirectory != null && (projectFileIndex = ProjectRootManager.getInstance((Project)project).getFileIndex()).isInContent(directory = psiDirectory.getVirtualFile())) {
                VirtualFile sourceRoot = projectFileIndex.getSourceRootForFile(directory);
                Module module = projectFileIndex.getModuleForFile(featureFile.getVirtualFile());
                if (module != null) {
                    VirtualFile[] sourceRoots = ModuleRootManager.getInstance((Module)module).getSourceRoots();
                    if (sourceRoot != null && sourceRoot.getName().equals("resources")) {
                        VirtualFile resourceParent = sourceRoot.getParent();
                        for (VirtualFile vFile : sourceRoots) {
                            if (!vFile.getPath().startsWith(resourceParent.getPath()) || !vFile.getName().equals("java")) continue;
                            sourceRoot = vFile;
                            break;
                        }
                    } else if (sourceRoots.length > 0) {
                        sourceRoot = sourceRoots[sourceRoots.length - 1];
                    }
                }
                String packageName = "";
                if (sourceRoot != null) {
                    packageName = CucumberJavaUtil.getPackageOfStepDef((PsiElement)step);
                }
                final String packagePath = packageName.replace('.', '/');
                final String path = sourceRoot != null ? sourceRoot.getPath() : directory.getPath();
                final Ref resultRef = new Ref();
                new WriteAction(){

                    protected void run(@NotNull Result result) throws Throwable {
                        if (result == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "org/jetbrains/plugins/cucumber/java/steps/JavaStepDefinitionCreator$1", "run"));
                        }
                        VirtualFile packageFile = VfsUtil.createDirectoryIfMissing((String)(path + '/' + packagePath));
                        if (packageFile != null) {
                            resultRef.set((Object)PsiDirectoryFactory.getInstance((Project)project).createDirectory(packageFile));
                        }
                    }
                }.execute();
                PsiDirectory psiDirectory2 = (PsiDirectory)resultRef.get();
                if (psiDirectory2 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/cucumber/java/steps/JavaStepDefinitionCreator", "getDefaultStepDefinitionFolder"));
                }
                return psiDirectory2;
            }
        }
        assert (featureFile != null);
        PsiDirectory psiDirectory = (PsiDirectory)ObjectUtils.assertNotNull((Object)featureFile.getParent());
        if (psiDirectory == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/cucumber/java/steps/JavaStepDefinitionCreator", "getDefaultStepDefinitionFolder"));
        }
        return psiDirectory;
    }

    @NotNull
    public String getStepDefinitionFilePath(@NotNull PsiFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/plugins/cucumber/java/steps/JavaStepDefinitionCreator", "getStepDefinitionFilePath"));
        }
        VirtualFile vFile = file.getVirtualFile();
        if (file instanceof PsiClassOwner && vFile != null) {
            String packageName = ((PsiClassOwner)file).getPackageName();
            if (StringUtil.isEmptyOrSpaces((String)packageName)) {
                String string = vFile.getNameWithoutExtension();
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/cucumber/java/steps/JavaStepDefinitionCreator", "getStepDefinitionFilePath"));
                }
                return string;
            }
            String string = vFile.getNameWithoutExtension() + " (" + packageName + ")";
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/cucumber/java/steps/JavaStepDefinitionCreator", "getStepDefinitionFilePath"));
            }
            return string;
        }
        String string = file.getName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/cucumber/java/steps/JavaStepDefinitionCreator", "getStepDefinitionFilePath"));
        }
        return string;
    }

    @NotNull
    public String getDefaultStepFileName(@NotNull GherkinStep step) {
        if (step == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "step", "org/jetbrains/plugins/cucumber/java/steps/JavaStepDefinitionCreator", "getDefaultStepFileName"));
        }
        if (STEP_DEFINITION_SUFFIX == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/cucumber/java/steps/JavaStepDefinitionCreator", "getDefaultStepFileName"));
        }
        return STEP_DEFINITION_SUFFIX;
    }

    private static PsiMethod buildStepDefinitionByStep(@NotNull GherkinStep step, Language language) {
        if (step == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "step", "org/jetbrains/plugins/cucumber/java/steps/JavaStepDefinitionCreator", "buildStepDefinitionByStep"));
        }
        String annotationPackage = new AnnotationPackageProvider().getAnnotationPackageFor(step);
        String methodAnnotation = String.format("@%s.", annotationPackage);
        Step cucumberStep = new Step(new ArrayList(), step.getKeyword().getText(), step.getStepName(), Integer.valueOf(0), null, null);
        SnippetGenerator generator = new SnippetGenerator((Snippet)new JavaSnippet());
        String snippet = generator.getSnippet(cucumberStep, new FunctionNameGenerator((Concatenator)new CamelCaseConcatenator())).replace("PendingException", CucumberJavaUtil.getCucumberPendingExceptionFqn((PsiElement)step)).replaceFirst("@", methodAnnotation).replaceAll("\\\\\\\\", "\\\\").replaceAll("\\\\d", "\\\\\\\\d");
        JVMElementFactory factory = JVMElementFactories.requireFactory((Language)language, (Project)step.getProject());
        return factory.createMethodFromText(snippet, (PsiElement)step);
    }
}

