/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.chart.annotation;

import com.intellij.openapi.util.Condition;
import com.intellij.util.Function;
import com.intellij.util.containers.HashSet;
import com.intellij.util.containers.JBIterable;
import gnu.trove.THashMap;
import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class AnnotationsCoordinator {
    private final Set<Class<? extends Annotation>> annotationsSet;

    public AnnotationsCoordinator(Collection<Class<? extends Annotation>> annotations) {
        this.annotationsSet = new java.util.HashSet<Class<? extends Annotation>>(annotations);
    }

    public AnnotationsCoordinator(Class<? extends Annotation> annotation) {
        this.annotationsSet = new java.util.HashSet<Class<? extends Annotation>>();
        this.annotationsSet.add(annotation);
    }

    public Map<Class<? extends Annotation>, Annotation> findAnnotations(Iterable<Class<?>> classes) {
        return this.findAnnotations(classes, Collections.emptySet());
    }

    private Map<Class<? extends Annotation>, Annotation> findAnnotations(Iterable<Class<?>> classes, final Set<Class<? extends Annotation>> excludedAnnotations) {
        THashMap annotationMap = new THashMap();
        List annotations = JBIterable.from(classes).filter(new Condition<Class<?>>(){

            public boolean value(Class<?> aClass) {
                return aClass != null;
            }
        }).transform(new Function<Class<?>, Map<Class<? extends Annotation>, Annotation>>(){

            public Map<Class<? extends Annotation>, Annotation> fun(Class<?> aClass) {
                return AnnotationsCoordinator.this.findAnnotations(aClass, (Set<Class<? extends Annotation>>)excludedAnnotations);
            }
        }).flatten((Function)new Function<Map<Class<? extends Annotation>, Annotation>, Iterable<Map.Entry<Class<? extends Annotation>, Annotation>>>(){

            public Iterable<Map.Entry<Class<? extends Annotation>, Annotation>> fun(Map<Class<? extends Annotation>, Annotation> map) {
                return map.entrySet();
            }
        }).toList();
        for (Map.Entry entry : annotations) {
            assert (!AnnotationsCoordinator.annotationAlreadyExistAndDiffer((Map<Class<? extends Annotation>, Annotation>)annotationMap, (Annotation)entry.getValue())) : "Found multiple annotations with type " + ((Class)entry.getKey()).getName() + " and different values; you should annotate child class too to avoid this warning";
            annotationMap.put(entry.getKey(), entry.getValue());
        }
        return annotationMap;
    }

    private static boolean annotationAlreadyExistAndDiffer(@NotNull Map<Class<? extends Annotation>, Annotation> annotations, @NotNull Annotation annotation) {
        if (annotations == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotations", "com/intellij/chart/annotation/AnnotationsCoordinator", "annotationAlreadyExistAndDiffer"));
        }
        if (annotation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotation", "com/intellij/chart/annotation/AnnotationsCoordinator", "annotationAlreadyExistAndDiffer"));
        }
        Annotation existAnnotation = annotations.get(annotation.annotationType());
        return existAnnotation != null && !existAnnotation.equals(annotation);
    }

    private Map<Class<? extends Annotation>, Annotation> findAnnotations(Class<?> clazz, Set<Class<? extends Annotation>> excludedAnnotations) {
        THashMap annotations = new THashMap();
        for (Annotation annotation : clazz.getAnnotations()) {
            Class<? extends Annotation> annotationClass = annotation.annotationType();
            if (excludedAnnotations.contains(annotationClass) || !this.annotationsSet.contains(annotationClass)) continue;
            annotations.put(annotationClass, annotation);
        }
        HashSet parentExcludedAnnotations = new HashSet(excludedAnnotations);
        parentExcludedAnnotations.addAll(annotations.keySet());
        Map<Class<? extends Annotation>, Annotation> parentAnnotations = this.findAnnotations((Iterable<Class<?>>)JBIterable.of(clazz.getSuperclass()).append((Object[])clazz.getInterfaces()), (Set<Class<? extends Annotation>>)parentExcludedAnnotations);
        annotations.putAll(parentAnnotations);
        return annotations;
    }
}

