/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.chart.layout;

import com.intellij.openapi.command.undo.DocumentReference;
import com.intellij.openapi.command.undo.UndoManager;
import com.intellij.openapi.command.undo.UndoableAction;
import com.intellij.openapi.command.undo.UnexpectedUndoException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MapUndoableWrapper<K, V>
implements Map<K, V> {
    @NotNull
    private final UndoManager undoManager;
    @NotNull
    private final DocumentReference[] documentReferences;
    @NotNull
    private final Map<K, V> underlyingMap;

    public MapUndoableWrapper(@NotNull UndoManager manager, @NotNull DocumentReference[] references, @NotNull Map<K, V> map) {
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/chart/layout/MapUndoableWrapper", "<init>"));
        }
        if (references == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "references", "com/intellij/chart/layout/MapUndoableWrapper", "<init>"));
        }
        if (map == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "map", "com/intellij/chart/layout/MapUndoableWrapper", "<init>"));
        }
        this.undoManager = manager;
        this.documentReferences = references;
        this.underlyingMap = map;
    }

    @Override
    public int size() {
        return this.underlyingMap.size();
    }

    @Override
    public boolean isEmpty() {
        return this.underlyingMap.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.underlyingMap.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.underlyingMap.containsValue(value);
    }

    @Override
    public V get(Object key) {
        return this.underlyingMap.get(key);
    }

    @Override
    public V put(final K key, final V value) {
        final V oldValue = this.underlyingMap.put(key, value);
        this.undoManager.undoableActionPerformed((UndoableAction)new Undoable(){

            public void undo() throws UnexpectedUndoException {
                if (oldValue != null) {
                    MapUndoableWrapper.this.underlyingMap.put(key, oldValue);
                } else {
                    MapUndoableWrapper.this.underlyingMap.remove(key);
                }
            }

            public void redo() throws UnexpectedUndoException {
                MapUndoableWrapper.this.underlyingMap.put(key, value);
            }
        });
        return oldValue;
    }

    @Override
    public V remove(final Object key) {
        final V oldValue = this.underlyingMap.remove(key);
        this.undoManager.undoableActionPerformed((UndoableAction)new Undoable(){

            public void undo() throws UnexpectedUndoException {
                if (oldValue != null) {
                    MapUndoableWrapper.this.underlyingMap.put(key, oldValue);
                }
            }

            public void redo() throws UnexpectedUndoException {
                MapUndoableWrapper.this.underlyingMap.remove(key);
            }
        });
        return oldValue;
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        for (Map.Entry<K, V> entry : m.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public void clear() {
        ArrayList<K> keys = new ArrayList<K>(this.underlyingMap.keySet());
        for (K key : keys) {
            this.remove(key);
        }
    }

    @Override
    @NotNull
    public Set<K> keySet() {
        Set<K> set = this.underlyingMap.keySet();
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/chart/layout/MapUndoableWrapper", "keySet"));
        }
        return set;
    }

    @Override
    @NotNull
    public Collection<V> values() {
        Collection<V> collection = this.underlyingMap.values();
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/chart/layout/MapUndoableWrapper", "values"));
        }
        return collection;
    }

    @Override
    @NotNull
    public Set<Map.Entry<K, V>> entrySet() {
        Set<Map.Entry<K, V>> set = this.underlyingMap.entrySet();
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/chart/layout/MapUndoableWrapper", "entrySet"));
        }
        return set;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MapUndoableWrapper wrapper = (MapUndoableWrapper)o;
        return this.underlyingMap.equals(wrapper.underlyingMap);
    }

    @Override
    public int hashCode() {
        return this.underlyingMap.hashCode();
    }

    private abstract class Undoable
    implements UndoableAction {
        private Undoable() {
        }

        @Nullable
        public final DocumentReference[] getAffectedDocuments() {
            return MapUndoableWrapper.this.documentReferences;
        }

        public final boolean isGlobal() {
            return false;
        }
    }
}

