/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.chart.model;

import com.intellij.chart.model.ChartFileSource;
import com.intellij.chart.model.ChartSource;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomEventListener;
import com.intellij.util.xml.DomFileElement;
import com.intellij.util.xml.DomManager;
import com.intellij.util.xml.events.DomEvent;
import org.jetbrains.annotations.NotNull;

public abstract class ChartDomFileSource
extends ChartFileSource
implements Disposable {
    @NotNull
    public final Project project;
    @NotNull
    public final PsiFile psiFile;

    public ChartDomFileSource(@NotNull Project project, @NotNull VirtualFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/chart/model/ChartDomFileSource", "<init>"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/chart/model/ChartDomFileSource", "<init>"));
        }
        super(file);
        this.project = project;
        PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(file);
        assert (psiFile != null);
        this.psiFile = psiFile;
    }

    @Override
    @NotNull
    public PsiFile getPsiFile() {
        PsiFile psiFile = this.psiFile;
        if (psiFile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/chart/model/ChartDomFileSource", "getPsiFile"));
        }
        return psiFile;
    }

    @Override
    public void addChangeListener(final ChartSource.ChartSourceChangeListener listener) {
        DomManager.getDomManager((Project)this.project).addDomEventListener(new DomEventListener(){

            public void eventOccured(DomEvent event) {
                DomElement element = event.getElement();
                if (element == null) {
                    return;
                }
                while (element.getParent() != null) {
                    element = element.getParent();
                }
                if (element instanceof DomFileElement && ((DomFileElement)element).getFile() != ChartDomFileSource.this.psiFile) {
                    return;
                }
                listener.chartSourceHasChanged();
            }
        }, (Disposable)this);
    }
}

