/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.chart.settings;

import com.intellij.chart.annotation.AnnotationNotNullCoordinator;
import com.intellij.chart.layout.ChartLayoutCoordinator;
import com.intellij.chart.model.ChartNode;
import com.intellij.chart.render.ChartRenderer;
import com.intellij.chart.render.size.ChartNodeSizeEnhancer;
import com.intellij.chart.render.size.RenderDefaultSize;
import com.intellij.chart.ui.ChartBuilder;
import com.intellij.diagram.DiagramBuilder;
import com.intellij.diagram.DiagramNode;
import com.intellij.diagram.DiagramVfsResolver;
import com.intellij.diagram.extras.DiagramExtras;
import java.awt.Dimension;
import java.awt.Point;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;

public class ChartExtras<T>
extends DiagramExtras<T> {
    @NotNull
    private final AnnotationNotNullCoordinator<RenderDefaultSize> renderSizeCoordinator = new AnnotationNotNullCoordinator<RenderDefaultSize>(RenderDefaultSize.class, this.getNodeDefaultSize());
    @NotNull
    private final ChartRenderer chartRenderer = new ChartRenderer();

    @NotNull
    public AnnotationNotNullCoordinator<RenderDefaultSize> getRenderSizeCoordinator() {
        AnnotationNotNullCoordinator<RenderDefaultSize> annotationNotNullCoordinator = this.renderSizeCoordinator;
        if (annotationNotNullCoordinator == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/chart/settings/ChartExtras", "getRenderSizeCoordinator"));
        }
        return annotationNotNullCoordinator;
    }

    public RenderDefaultSize getNodeDefaultSize() {
        return RenderDefaultSize.class.getAnnotation(RenderDefaultSize.class);
    }

    @NotNull
    public final JComponent createNodeComponent(DiagramNode<T> node, DiagramBuilder builder, Point basePoint, JPanel wrapper) {
        assert (node instanceof ChartNode);
        ChartNode chartNode = (ChartNode)node;
        assert (builder instanceof ChartBuilder);
        ChartBuilder chartBuilder = (ChartBuilder)builder;
        ChartLayoutCoordinator chartLayoutCoordinator = chartBuilder.getChartLayoutCoordinator();
        DiagramVfsResolver resolver = chartBuilder.getProvider().getVfsResolver();
        wrapper.removeAll();
        JComponent result = this.chartRenderer.createNodeComponent(chartNode, builder, basePoint, wrapper);
        if (result == null) {
            result = super.createNodeComponent(node, builder, basePoint, wrapper);
        }
        ChartLayoutCoordinator.NodeLayout nodeLayout = null;
        if (chartLayoutCoordinator != null) {
            nodeLayout = chartLayoutCoordinator.getNodeLayout(resolver.getQualifiedName(node.getIdentifyingElement()), ChartNodeSizeEnhancer.enhancerForNode(chartNode));
        }
        if (nodeLayout != null) {
            wrapper.getParent().setPreferredSize(new Dimension((int)nodeLayout.getWidth(), (int)nodeLayout.getHeight()));
        } else {
            RenderDefaultSize size = this.renderSizeCoordinator.getAnnotation(chartNode.getClassesWithAnnotationsForRendering());
            wrapper.getParent().setPreferredSize(new Dimension((int)size.width(), (int)size.height()));
        }
        JComponent jComponent = result;
        if (jComponent == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/chart/settings/ChartExtras", "createNodeComponent"));
        }
        return jComponent;
    }
}

