/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.chart.settings;

import com.intellij.chart.dnd.ChartDnDSupport;
import com.intellij.chart.layout.ChartLayoutCoordinator;
import com.intellij.chart.model.ChartDataModel;
import com.intellij.chart.model.ChartSource;
import com.intellij.chart.settings.ChartExtras;
import com.intellij.diagram.DiagramPresentationModel;
import com.intellij.diagram.DiagramProvider;
import com.intellij.diagram.DiagramRelationshipManager;
import com.intellij.diagram.DiagramVisibilityManager;
import com.intellij.diagram.EmptyDiagramVisibilityManager;
import com.intellij.openapi.graph.view.Graph2D;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.uml.presentation.DiagramPresentationModelImpl;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ChartProvider<T>
extends DiagramProvider<T> {
    public abstract String getChartId();

    public abstract String getChartName();

    public DiagramVisibilityManager createVisibilityManager() {
        return new EmptyDiagramVisibilityManager();
    }

    public DiagramPresentationModel createPresentationModel(@NotNull Project project, @NotNull Graph2D graph) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/chart/settings/ChartProvider", "createPresentationModel"));
        }
        if (graph == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "graph", "com/intellij/chart/settings/ChartProvider", "createPresentationModel"));
        }
        return new DiagramPresentationModelImpl(graph, project, (DiagramProvider)this);
    }

    public DiagramRelationshipManager<T> getRelationshipManager() {
        return DiagramRelationshipManager.NO_RELATIONSHIP_MANAGER;
    }

    public String getPresentableName() {
        return this.getChartName();
    }

    public final ChartDataModel<T> createDataModel(@NotNull Project project, @Nullable T element, @Nullable VirtualFile file, DiagramPresentationModel presentationModel) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/chart/settings/ChartProvider", "createDataModel"));
        }
        assert (false) : "should not be called";
        return null;
    }

    public abstract ChartDataModel<T> createChartDataModel(@NotNull Project var1, @NotNull ChartSource var2, DiagramPresentationModel var3);

    @Nullable
    public abstract ChartDnDSupport creteDnDSupport(ChartDataModel<T> var1);

    public abstract ChartLayoutCoordinator createLayoutCoordinator(Project var1, ChartDataModel var2);

    @NotNull
    public ChartExtras<T> getExtras() {
        ChartExtras chartExtras = new ChartExtras();
        if (chartExtras == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/chart/settings/ChartProvider", "getExtras"));
        }
        return chartExtras;
    }
}

