/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.settingsRepository;

import com.intellij.layout.CCFlags;
import com.intellij.layout.LCFlags;
import com.intellij.layout.LayoutKt;
import com.intellij.layout.Panel;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.options.ConfigurableUi;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.Iterator;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import net.miginfocom.layout.LC;
import net.miginfocom.swing.MigLayout;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.settingsRepository.IcsManagerKt;
import org.jetbrains.settingsRepository.IcsSettings;
import org.jetbrains.settingsRepository.IcsSettingsKt;
import org.jetbrains.settingsRepository.ReadOnlySourcesEditorKt;
import org.jetbrains.settingsRepository.RepositoryListEditorKt;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003B\u0005\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0002H\u0016J\b\u0010\f\u001a\u00020\nH\u0016J\b\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u000b\u001a\u00020\u0002H\u0016J\u0010\u0010\u0011\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0002H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\u00010\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/settingsRepository/IcsConfigurableUi;", "Lcom/intellij/openapi/options/ConfigurableUi;", "Lorg/jetbrains/settingsRepository/IcsSettings;", "Lcom/intellij/openapi/Disposable;", "()V", "autoSync", "Ljavax/swing/JCheckBox;", "editors", "", "apply", "", "settings", "dispose", "getComponent", "Ljavax/swing/JPanel;", "isModified", "", "reset", "settings-repository"})
public final class IcsConfigurableUi
implements ConfigurableUi<IcsSettings>,
Disposable {
    private final List<ConfigurableUi<IcsSettings>> editors = CollectionsKt.listOf((Object[])new ConfigurableUi[]{RepositoryListEditorKt.createRepositoryListEditor(), ReadOnlySourcesEditorKt.createReadOnlySourcesEditor()});
    private final JCheckBox autoSync = new JCheckBox("Auto Sync");

    public void dispose() {
        IcsManagerKt.getIcsManager().getAutoSyncManager$settings_repository().setEnabled(true);
    }

    public void reset(@NotNull IcsSettings settings) {
        Intrinsics.checkParameterIsNotNull((Object)settings, (String)"settings");
        IcsManagerKt.getIcsManager().getAutoSyncManager$settings_repository().setEnabled(false);
        this.autoSync.setSelected(settings.getAutoSync());
        Iterable $receiver$iv = this.editors;
        for (Object element$iv : $receiver$iv) {
            ConfigurableUi it = (ConfigurableUi)element$iv;
            it.reset((Object)settings);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isModified(@NotNull IcsSettings settings) {
        Object element$iv;
        ConfigurableUi it;
        Intrinsics.checkParameterIsNotNull((Object)settings, (String)"settings");
        if (this.autoSync.isSelected() != settings.getAutoSync()) return true;
        Iterable $receiver$iv = this.editors;
        Iterator iterator = $receiver$iv.iterator();
        do {
            if (!iterator.hasNext()) return false;
        } while (!(it = (ConfigurableUi)(element$iv = iterator.next())).isModified((Object)settings));
        return true;
    }

    public void apply(@NotNull IcsSettings settings) {
        Intrinsics.checkParameterIsNotNull((Object)settings, (String)"settings");
        settings.setAutoSync(this.autoSync.isSelected());
        Iterable $receiver$iv = this.editors;
        for (Object element$iv : $receiver$iv) {
            ConfigurableUi it = (ConfigurableUi)element$iv;
            it.apply((Object)settings);
        }
        IcsSettingsKt.saveSettings(settings, IcsManagerKt.getIcsManager().getSettingsFile());
    }

    @NotNull
    public JPanel getComponent() {
        Panel panel$iv;
        LCFlags[] layoutConstraints$iv = new LCFlags[]{LCFlags.noGrid, LCFlags.flowY};
        Panel $receiver = panel$iv = new Panel((LayoutManager)new MigLayout(LayoutKt.apply((LC)LayoutKt.c$default(null, null, (int)3, null), (LCFlags[])layoutConstraints$iv)));
        Panel.invoke$default((Panel)$receiver, (Component)this.editors.get(0).getComponent(), null, (int)1, null);
        Panel.invoke$default((Panel)$receiver, (Component)this.autoSync, null, (int)1, null);
        LayoutKt.hint((JPanel)((JPanel)$receiver), (String)"Use VCS -> Sync Settings to sync when you want", (CCFlags[])new CCFlags[0]);
        JPanel jPanel = (JPanel)$receiver;
        Component component = this.editors.get(1).getComponent();
        Intrinsics.checkExpressionValueIsNotNull((Object)component, (String)"editors.get(1).component");
        LayoutKt.titledPanel((JPanel)jPanel, (String)"Read-only Sources", (Component)component, (CCFlags[])new CCFlags[]{CCFlags.grow, CCFlags.push});
        return (JPanel)panel$iv;
    }
}

