/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.settingsRepository;

import com.intellij.configurationStore.ComponentStoreImpl;
import com.intellij.configurationStore.SchemeManagerFactoryBase;
import com.intellij.configurationStore.StateStorageManagerImpl;
import com.intellij.configurationStore.StoreAwareProjectManagerKt;
import com.intellij.layout.CCFlags;
import com.intellij.layout.LCFlags;
import com.intellij.layout.LayoutKt;
import com.intellij.layout.Panel;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServiceKt;
import com.intellij.openapi.components.impl.stores.IComponentStore;
import com.intellij.openapi.components.impl.stores.StateStorageManager;
import com.intellij.openapi.options.ConfigurableUi;
import com.intellij.openapi.options.SchemeManagerFactory;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.util.ui.ComboBoxModelEditor;
import com.intellij.util.ui.ListItemEditor;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.swing.JButton;
import javax.swing.JPanel;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import net.miginfocom.layout.LC;
import net.miginfocom.swing.MigLayout;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.settingsRepository.AuthenticationException;
import org.jetbrains.settingsRepository.IcsManagerKt;
import org.jetbrains.settingsRepository.IcsSettings;
import org.jetbrains.settingsRepository.NoRemoteRepositoryException;
import org.jetbrains.settingsRepository.RepositoryItem;
import org.jetbrains.settingsRepository.RepositoryListEditorKt;
import org.jetbrains.settingsRepository.RepositoryManager;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=2, d1={"\u0000\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\u001a\u000e\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001H\u0000\u001a\b\u0010\u0003\u001a\u00020\u0004H\u0002\u00a8\u0006\u0005"}, d2={"createRepositoryListEditor", "Lcom/intellij/openapi/options/ConfigurableUi;", "Lorg/jetbrains/settingsRepository/IcsSettings;", "deleteRepository", "", "settings-repository"})
public final class RepositoryListEditorKt {
    @NotNull
    public static final ConfigurableUi<IcsSettings> createRepositoryListEditor() {
        ComboBoxModelEditor editor2 = new ComboBoxModelEditor((ListItemEditor)new ListItemEditor<RepositoryItem>(){

            @NotNull
            public Class<RepositoryItem> getItemClass() {
                return RepositoryItem.class;
            }

            @NotNull
            public RepositoryItem clone(@NotNull RepositoryItem item, boolean forInPlaceEditing) {
                Intrinsics.checkParameterIsNotNull((Object)item, (String)"item");
                return new RepositoryItem(item.getUrl());
            }
        });
        JButton deleteButton = new JButton("Delete");
        deleteButton.addActionListener(new ActionListener(editor2, deleteButton){
            final /* synthetic */ ComboBoxModelEditor $editor;
            final /* synthetic */ JButton $deleteButton;

            public final void actionPerformed(ActionEvent it) {
                block0: {
                    RepositoryItem repositoryItem = (RepositoryItem)this.$editor.getModel().getSelected();
                    if (repositoryItem == null) break block0;
                    RepositoryItem repositoryItem2 = repositoryItem;
                    RepositoryItem it2 = repositoryItem2;
                    this.$editor.getModel().remove((Object)it2);
                    this.$deleteButton.setEnabled(this.$editor.getModel().getSelected() != null);
                }
            }
            {
                this.$editor = comboBoxModelEditor;
                this.$deleteButton = jButton;
            }
        });
        return (ConfigurableUi)new ConfigurableUi<IcsSettings>(editor2, deleteButton){
            final /* synthetic */ ComboBoxModelEditor $editor;
            final /* synthetic */ JButton $deleteButton;

            public boolean isModified(@NotNull IcsSettings settings) {
                Intrinsics.checkParameterIsNotNull((Object)settings, (String)"settings");
                return this.$editor.isModified();
            }

            @NotNull
            public JPanel getComponent() {
                Panel panel$iv;
                LCFlags[] layoutConstraints$iv = new LCFlags[]{};
                Panel $receiver = panel$iv = new Panel((LayoutManager)new MigLayout(LayoutKt.apply((LC)LayoutKt.c$default(null, null, (int)3, null), (LCFlags[])layoutConstraints$iv)));
                LayoutKt.label$default((JPanel)((JPanel)$receiver), (String)"Repository:", (CCFlags[])new CCFlags[0], null, null, (boolean)false, (int)0, (int)0, (int)0, (int)252, null);
                Panel.invoke$default((Panel)$receiver, (Component)((Component)this.$editor.getComboBox()), null, (int)1, null);
                Panel.invoke$default((Panel)$receiver, (Component)this.$deleteButton, null, (int)1, null);
                return (JPanel)panel$iv;
            }

            public void apply(@NotNull IcsSettings settings) {
                Intrinsics.checkParameterIsNotNull((Object)settings, (String)"settings");
                List newList = this.$editor.apply();
                if (newList.isEmpty()) {
                    RepositoryListEditorKt.access$deleteRepository();
                }
            }

            public void reset(@NotNull IcsSettings settings) {
                RepositoryItem upstream;
                RepositoryItem repositoryItem;
                Object it;
                String string;
                Intrinsics.checkParameterIsNotNull((Object)settings, (String)"settings");
                ArrayList<Object> list = new ArrayList<Object>();
                String string2 = IcsManagerKt.getIcsManager().getRepositoryManager().getUpstream();
                if (string2 != null) {
                    string = string2;
                    it = string;
                    repositoryItem = new RepositoryItem((String)it);
                } else {
                    repositoryItem = null;
                }
                RepositoryItem repositoryItem2 = upstream = repositoryItem;
                if (repositoryItem2 != null) {
                    string = repositoryItem2;
                    it = (RepositoryItem)((Object)string);
                    list.add(it);
                }
                this.$editor.reset((List)list);
                this.$editor.getModel().setSelectedItem((Object)upstream);
                this.$deleteButton.setEnabled(this.$editor.getModel().getSelectedItem() != null);
            }
            {
                this.$editor = $captured_local_variable$0;
                this.$deleteButton = $captured_local_variable$1;
            }
        };
    }

    private static final void deleteRepository() {
        String title$iv;
        boolean cancellable$iv;
        Project project$iv;
        String string = "Syncing before delete Repository";
        Object var1_1 = null;
        boolean bl = true;
        int n = 2;
        Object var4_4 = null;
        if (var4_4 != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: runModalTask");
        }
        if ((n & 2) != 0) {
            project$iv = null;
        }
        if ((n & 4) != 0) {
            cancellable$iv = true;
        }
        ProgressManager.getInstance().run((Task)new Task.Modal(project$iv, title$iv, cancellable$iv){

            /*
             * WARNING - void declaration
             */
            public void run(ProgressIndicator indicator) {
                ProgressIndicator indicator2 = indicator;
                indicator2.setIndeterminate(true);
                RepositoryManager repositoryManager = IcsManagerKt.getIcsManager().getRepositoryManager();
                if (!repositoryManager.canCommit()) {
                    IcsManagerKt.getLOG().info("Commit on repository delete skipped: repository is not committable");
                } else {
                    boolean bl = true;
                    try {
                        RepositoryManager.Updater updater = repositoryManager.fetch(indicator2);
                        indicator2.checkCanceled();
                        updater.merge();
                        indicator2.checkCanceled();
                        if (!updater.getDefinitelySkipPush()) {
                            repositoryManager.push(indicator2);
                        }
                    }
                    catch (ProcessCanceledException e$iv) {
                    }
                    catch (Throwable e$iv) {
                        void asWarning$iv;
                        if (asWarning$iv != false || e$iv instanceof AuthenticationException || e$iv instanceof NoRemoteRepositoryException) {
                            IcsManagerKt.getLOG().warn(e$iv);
                        }
                        IcsManagerKt.getLOG().error(e$iv);
                    }
                }
            }
        });
        title$iv = "Deleting Repository";
        project$iv = null;
        cancellable$iv = false;
        int $i$f$runModalTask = 2;
        var4_4 = null;
        if (var4_4 != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: runModalTask");
        }
        if (($i$f$runModalTask & 2) != 0) {
            project$iv = null;
        }
        if (($i$f$runModalTask & 4) != 0) {
            cancellable$iv = true;
        }
        ProgressManager.getInstance().run((Task)new Task.Modal(project$iv, title$iv, cancellable$iv){

            public void run(ProgressIndicator indicator) {
                ProgressIndicator indicator2 = indicator;
                RepositoryManager repositoryManager = IcsManagerKt.getIcsManager().getRepositoryManager();
                indicator2.setIndeterminate(true);
                repositoryManager.deleteRepository();
                IcsManagerKt.getIcsManager().setRepositoryActive(false);
            }
        });
        IComponentStore iComponentStore = ServiceKt.getStateStore((ComponentManager)((ComponentManager)ApplicationManager.getApplication()));
        if (iComponentStore == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.intellij.configurationStore.ComponentStoreImpl");
        }
        ComponentStoreImpl store = (ComponentStoreImpl)iComponentStore;
        StateStorageManager stateStorageManager = store.getStorageManager();
        if (stateStorageManager == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.intellij.configurationStore.StateStorageManagerImpl");
        }
        if (!StoreAwareProjectManagerKt.reloadAppStore((Set)((StateStorageManagerImpl)stateStorageManager).getCachedFileStorages())) {
            return;
        }
        SchemeManagerFactory schemeManagerFactory = SchemeManagerFactory.Companion.getInstance();
        if (schemeManagerFactory == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.intellij.configurationStore.SchemeManagerFactoryBase");
        }
        ((SchemeManagerFactoryBase)schemeManagerFactory).process((Function1)deleteRepository.3.INSTANCE);
    }

    public static final /* synthetic */ void access$deleteRepository() {
        RepositoryListEditorKt.deleteRepository();
    }
}

