/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.settingsRepository.git;

import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.util.PathUtilRt;
import com.intellij.util.SmartList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.eclipse.jgit.lib.IndexDiff;
import org.eclipse.jgit.lib.ProgressMonitor;
import org.eclipse.jgit.lib.Repository;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jgit.dirCache.AddFile;
import org.jetbrains.jgit.dirCache.DirCacheEditorKt;
import org.jetbrains.jgit.dirCache.PathEdit;
import org.jetbrains.settingsRepository.IcsManagerKt;
import org.jetbrains.settingsRepository.IcsUrlBuilderKt;
import org.jetbrains.settingsRepository.git.CommitMessageFormatter;
import org.jetbrains.settingsRepository.git.GitExKt;
import org.jetbrains.settingsRepository.git.IdeaCommitMessageFormatter;
import org.jetbrains.settingsRepository.git.JGitProgressMonitorKt;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=2, d1={"\u0000:\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\b\u0003\u001a\"\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u001a\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002\u001a,\u0010\f\u001a\u00020\r*\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\t2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\t0\u00112\b\b\u0002\u0010\u0012\u001a\u00020\u0001H\u0002\u001a\"\u0010\u0013\u001a\u00020\r*\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\t2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\t0\u0011H\u0002\u00a8\u0006\u0014"}, d2={"commit", "", "repository", "Lorg/eclipse/jgit/lib/Repository;", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "commitMessageFormatter", "Lorg/jetbrains/settingsRepository/git/CommitMessageFormatter;", "indexDiffToString", "", "diff", "Lorg/eclipse/jgit/lib/IndexDiff;", "addList", "", "Ljava/lang/StringBuilder;", "name", "list", "", "compact", "appendCompactList", "settings-repository"})
public final class CommitKt {
    /*
     * WARNING - void declaration
     */
    public static final boolean commit(@NotNull Repository repository2, @Nullable ProgressIndicator indicator, @NotNull CommitMessageFormatter commitMessageFormatter) {
        void $receiver$iv;
        Exception e$iv;
        String path2;
        Object edits;
        Intrinsics.checkParameterIsNotNull((Object)repository2, (String)"repository");
        Intrinsics.checkParameterIsNotNull((Object)commitMessageFormatter, (String)"commitMessageFormatter");
        ProgressIndicator progressIndicator = indicator;
        if (progressIndicator != null) {
            progressIndicator.checkCanceled();
        }
        IndexDiff diff = GitExKt.computeIndexDiff(repository2);
        ProgressIndicator progressIndicator2 = indicator;
        boolean changed = diff.diff((ProgressMonitor)(progressIndicator2 != null ? JGitProgressMonitorKt.asProgressMonitor(progressIndicator2) : null), 0, 0, "Commit");
        if (!changed || diff.getAdded().isEmpty() && diff.getChanged().isEmpty() && diff.getRemoved().isEmpty()) {
            if (diff.getModified().isEmpty()) {
                IcsManagerKt.getLOG().debug("Nothing to commit");
                return false;
            }
            edits = null;
            for (String path2 : diff.getModified()) {
                if (StringsKt.startsWith$default((String)path2, (String)IcsUrlBuilderKt.PROJECTS_DIR_NAME, (boolean)false, (int)2, null)) continue;
                if (edits == null) {
                    edits = (List)new SmartList();
                }
                String string = path2;
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"path");
                edits.add(new AddFile(string));
            }
            if (edits != null) {
                DirCacheEditorKt.edit(repository2, (List<? extends PathEdit>)edits);
            }
        }
        edits = IcsManagerKt.getLOG();
        path2 = null;
        boolean bl = true;
        Object var8_9 = null;
        if (var8_9 != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: debug");
        }
        if (bl & true) {
            e$iv = null;
        }
        if ($receiver$iv.isDebugEnabled()) {
            void var10_10 = $receiver$iv;
            String string = CommitKt.indexDiffToString(diff);
            var10_10.debug(string, (Throwable)e$iv);
        }
        ProgressIndicator progressIndicator3 = indicator;
        if (progressIndicator3 != null) {
            progressIndicator3.checkCanceled();
        }
        StringBuilder builder = new StringBuilder();
        commitMessageFormatter.prependMessage(builder);
        Collection collection = diff.getChanged();
        Intrinsics.checkExpressionValueIsNotNull((Object)collection, (String)"diff.changed");
        CommitKt.appendCompactList(builder, "Update", collection);
        Collection collection2 = diff.getAdded();
        Intrinsics.checkExpressionValueIsNotNull((Object)collection2, (String)"diff.added");
        CommitKt.appendCompactList(builder, "Create", collection2);
        Collection collection3 = diff.getRemoved();
        Intrinsics.checkExpressionValueIsNotNull((Object)collection3, (String)"diff.removed");
        CommitKt.appendCompactList(builder, "Delete", collection3);
        GitExKt.commit$default(repository2, builder.toString(), null, null, null, 14, null);
        return true;
    }

    public static /* bridge */ /* synthetic */ boolean commit$default(Repository repository2, ProgressIndicator progressIndicator, CommitMessageFormatter commitMessageFormatter, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: commit");
        }
        if ((n & 4) != 0) {
            commitMessageFormatter = new IdeaCommitMessageFormatter();
        }
        return CommitKt.commit(repository2, progressIndicator, commitMessageFormatter);
    }

    private static final String indexDiffToString(IndexDiff diff) {
        StringBuilder builder = new StringBuilder();
        builder.append("To commit:");
        Collection collection = diff.getAdded();
        Intrinsics.checkExpressionValueIsNotNull((Object)collection, (String)"diff.added");
        CommitKt.addList$default(builder, "Added", collection, false, 4, null);
        Collection collection2 = diff.getChanged();
        Intrinsics.checkExpressionValueIsNotNull((Object)collection2, (String)"diff.changed");
        CommitKt.addList$default(builder, "Changed", collection2, false, 4, null);
        Collection collection3 = diff.getRemoved();
        Intrinsics.checkExpressionValueIsNotNull((Object)collection3, (String)"diff.removed");
        CommitKt.addList$default(builder, "Deleted", collection3, false, 4, null);
        Collection collection4 = diff.getModified();
        Intrinsics.checkExpressionValueIsNotNull((Object)collection4, (String)"diff.modified");
        CommitKt.addList$default(builder, "Modified on disk relative to the index", collection4, false, 4, null);
        Collection collection5 = diff.getUntracked();
        Intrinsics.checkExpressionValueIsNotNull((Object)collection5, (String)"diff.untracked");
        CommitKt.addList$default(builder, "Untracked files", collection5, false, 4, null);
        Collection collection6 = diff.getUntrackedFolders();
        Intrinsics.checkExpressionValueIsNotNull((Object)collection6, (String)"diff.untrackedFolders");
        CommitKt.addList$default(builder, "Untracked folders", collection6, false, 4, null);
        Collection collection7 = diff.getMissing();
        Intrinsics.checkExpressionValueIsNotNull((Object)collection7, (String)"diff.missing");
        CommitKt.addList$default(builder, "Missing", collection7, false, 4, null);
        String string = builder.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"builder.toString()");
        return string;
    }

    private static final void appendCompactList(@NotNull StringBuilder $receiver, String name, Collection<String> list) {
        CommitKt.addList($receiver, name, list, true);
    }

    private static final void addList(@NotNull StringBuilder $receiver, String name, Collection<String> list, boolean compact) {
        if (list.isEmpty()) {
            return;
        }
        if (compact) {
            if ($receiver.length() != 0 && $receiver.charAt($receiver.length() - 1) != ' ') {
                $receiver.append('\t');
            }
            $receiver.append(name);
        } else {
            $receiver.append('\t').append(name).append(':');
        }
        $receiver.append(' ');
        boolean isNotFirst = false;
        for (String path : list) {
            if (isNotFirst) {
                $receiver.append(',').append(' ');
            } else {
                isNotFirst = true;
            }
            $receiver.append(compact ? PathUtilRt.getFileName((String)path) : path);
        }
    }

    static /* bridge */ /* synthetic */ void addList$default(StringBuilder stringBuilder, String string, Collection collection, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: addList");
        }
        if ((n & 4) != 0) {
            bl = false;
        }
        CommitKt.addList(stringBuilder, string, collection, bl);
    }
}

