/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.settingsRepository.git;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.vcs.merge.MergeData;
import com.intellij.openapi.vcs.merge.MergeProvider2;
import com.intellij.openapi.vcs.merge.MergeSession;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ui.ColumnInfo;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.eclipse.jgit.lib.Repository;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jgit.dirCache.DirCacheEditorKt;
import org.jetbrains.settingsRepository.RepositoryVirtualFile;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0010\u0012\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002:\u0001!BT\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00028\u00000\u0006\u00121\u0010\b\u001a-\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00028\u00000\u0006\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\n\u0012\u0006\u0012\u0004\u0018\u00010\u000b0\t\u00a2\u0006\u0002\b\f\u00a2\u0006\u0002\u0010\rJ\"\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u00122\b\b\u0002\u0010\u0013\u001a\u00020\nH\u0002J\u0010\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0016\u0010\u0015\u001a\u00020\u00162\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00120\u0018H\u0016J \u0010\u0019\u001a\n \u001a*\u0004\u0018\u00010\u000b0\u000b2\u0006\u0010\u001b\u001a\u00020\u00072\u0006\u0010\u001c\u001a\u00020\nH\u0002J\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u001f\u001a\u00020 2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00028\u00000\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R9\u0010\b\u001a-\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00028\u00000\u0006\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\n\u0012\u0006\u0012\u0004\u0018\u00010\u000b0\t\u00a2\u0006\u0002\b\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lorg/jetbrains/settingsRepository/git/JGitMergeProvider;", "T", "Lcom/intellij/openapi/vcs/merge/MergeProvider2;", "repository", "Lorg/eclipse/jgit/lib/Repository;", "conflicts", "", "", "pathToContent", "Lkotlin/Function3;", "", "", "Lkotlin/ExtensionFunctionType;", "(Lorg/eclipse/jgit/lib/Repository;Ljava/util/Map;Lkotlin/jvm/functions/Function3;)V", "addFile", "", "bytes", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "size", "conflictResolvedForFile", "createMergeSession", "Lcom/intellij/openapi/vcs/merge/MergeSession;", "files", "", "getContentOrEmpty", "kotlin.jvm.PlatformType", "path", "index", "isBinary", "", "loadRevisions", "Lcom/intellij/openapi/vcs/merge/MergeData;", "JGitMergeSession", "settings-repository"})
public final class JGitMergeProvider<T>
implements MergeProvider2 {
    private final Repository repository;
    private final Map<String, T> conflicts;
    private final Function3<Map<String, ? extends T>, String, Integer, byte[]> pathToContent;

    @NotNull
    public MergeSession createMergeSession(@NotNull List<? extends VirtualFile> files2) {
        Intrinsics.checkParameterIsNotNull(files2, (String)"files");
        return new JGitMergeSession();
    }

    public void conflictResolvedForFile(@NotNull VirtualFile file) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        VirtualFile virtualFile = file;
        if (virtualFile == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.settingsRepository.RepositoryVirtualFile");
        }
        byte[] bytes = ((RepositoryVirtualFile)virtualFile).getContent();
        if (bytes == null) {
            Document document = FileDocumentManager.getInstance().getCachedDocument(file);
            if (document == null) {
                Intrinsics.throwNpe();
            }
            CharSequence chars = document.getImmutableCharSequence();
            ByteBuffer byteBuffer = Charsets.UTF_8.encode(CharBuffer.wrap(chars));
            byte[] byArray = byteBuffer.array();
            Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"byteBuffer.array()");
            this.addFile(byArray, file, byteBuffer.remaining());
        } else {
            JGitMergeProvider.addFile$default(this, bytes, file, 0, 4, null);
        }
    }

    private final void addFile(byte[] bytes, VirtualFile file, int size) {
        String string = file.getPath();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"file.path");
        DirCacheEditorKt.writePath(this.repository, string, bytes, size);
    }

    static /* bridge */ /* synthetic */ void addFile$default(JGitMergeProvider jGitMergeProvider, byte[] byArray, VirtualFile virtualFile, int n, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: addFile");
        }
        if ((n2 & 4) != 0) {
            n = byArray.length;
        }
        jGitMergeProvider.addFile(byArray, virtualFile, n);
    }

    public boolean isBinary(@NotNull VirtualFile file) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        return file.getFileType().isBinary();
    }

    @NotNull
    public MergeData loadRevisions(@NotNull VirtualFile file) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        String path = file.getPath();
        MergeData mergeData = new MergeData();
        String string = path;
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"path");
        mergeData.ORIGINAL = this.getContentOrEmpty(string, 0);
        String string2 = path;
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"path");
        mergeData.CURRENT = this.getContentOrEmpty(string2, 1);
        String string3 = path;
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"path");
        mergeData.LAST = this.getContentOrEmpty(string3, 2);
        return mergeData;
    }

    private final byte[] getContentOrEmpty(String path, int index) {
        byte[] byArray = (byte[])this.pathToContent.invoke(this.conflicts, (Object)path, (Object)index);
        if (byArray == null) {
            byArray = ArrayUtil.EMPTY_BYTE_ARRAY;
        }
        return byArray;
    }

    public JGitMergeProvider(@NotNull Repository repository2, @NotNull Map<String, ? extends T> conflicts, @NotNull Function3<? super Map<String, ? extends T>, ? super String, ? super Integer, byte[]> pathToContent) {
        Intrinsics.checkParameterIsNotNull((Object)repository2, (String)"repository");
        Intrinsics.checkParameterIsNotNull(conflicts, (String)"conflicts");
        Intrinsics.checkParameterIsNotNull(pathToContent, (String)"pathToContent");
        this.repository = repository2;
        this.conflicts = conflicts;
        this.pathToContent = pathToContent;
    }

    @Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u0082\u0004\u0018\u00002\u00020\u0001:\u0001\u0013B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\nH\u0016J\u001a\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u0004H\u0002J'\u0010\u000e\u001a\u001c\u0012\u0018\u0012\u0016\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u0011\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00110\u00100\u000fH\u0016\u00a2\u0006\u0002\u0010\u0012\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/settingsRepository/git/JGitMergeProvider$JGitMergeSession;", "Lcom/intellij/openapi/vcs/merge/MergeSession;", "(Lorg/jetbrains/settingsRepository/git/JGitMergeProvider;)V", "canMerge", "", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "conflictResolvedForFile", "", "resolution", "Lcom/intellij/openapi/vcs/merge/MergeSession$Resolution;", "getContent", "", "isTheirs", "getMergeInfoColumns", "", "Lcom/intellij/util/ui/ColumnInfo;", "", "()[Lcom/intellij/util/ui/ColumnInfo;", "StatusColumn", "settings-repository"})
    private final class JGitMergeSession
    implements MergeSession {
        @NotNull
        public ColumnInfo<? extends Object, ? extends Object>[] getMergeInfoColumns() {
            ColumnInfo[] elements$iv = new ColumnInfo[]{new StatusColumn(false), new StatusColumn(true)};
            return (ColumnInfo[])((Object[])elements$iv);
        }

        public boolean canMerge(@NotNull VirtualFile file) {
            Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
            Map map = JGitMergeProvider.this.conflicts;
            String string = file.getPath();
            Map map2 = map;
            Map map3 = map2;
            if (map3 == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.collections.Map<K, *>");
            }
            return map3.containsKey(string);
        }

        public void conflictResolvedForFile(@NotNull VirtualFile file, @NotNull MergeSession.Resolution resolution) {
            Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
            Intrinsics.checkParameterIsNotNull((Object)resolution, (String)"resolution");
            if (Intrinsics.areEqual((Object)resolution, (Object)MergeSession.Resolution.Merged)) {
                JGitMergeProvider.this.conflictResolvedForFile(file);
            } else {
                byte[] content = this.getContent(file, Intrinsics.areEqual((Object)resolution, (Object)MergeSession.Resolution.AcceptedTheirs));
                if (content == null) {
                    Repository repository2 = JGitMergeProvider.this.repository;
                    String string = file.getPath();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"file.path");
                    DirCacheEditorKt.deletePath$default(repository2, string, false, false, 6, null);
                } else {
                    JGitMergeProvider.addFile$default(JGitMergeProvider.this, content, file, 0, 4, null);
                }
            }
        }

        private final byte[] getContent(VirtualFile file, boolean isTheirs) {
            Function3 function3 = JGitMergeProvider.this.pathToContent;
            Map map = JGitMergeProvider.this.conflicts;
            String string = file.getPath();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"file.path");
            return (byte[])function3.invoke((Object)map, (Object)string, (Object)(isTheirs ? 2 : 1));
        }

        @Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\b\u0086\u0004\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\u0003H\u0016J\u0012\u0010\n\u001a\u00020\u00032\b\u0010\u000b\u001a\u0004\u0018\u00010\u0002H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lorg/jetbrains/settingsRepository/git/JGitMergeProvider$JGitMergeSession$StatusColumn;", "Lcom/intellij/util/ui/ColumnInfo;", "Lcom/intellij/openapi/vfs/VirtualFile;", "", "isTheirs", "", "(Lorg/jetbrains/settingsRepository/git/JGitMergeProvider$JGitMergeSession;Z)V", "getAdditionalWidth", "", "getMaxStringValue", "valueOf", "file", "settings-repository"})
        public final class StatusColumn
        extends ColumnInfo<VirtualFile, String> {
            private final boolean isTheirs;

            @NotNull
            public String valueOf(@Nullable VirtualFile file) {
                VirtualFile virtualFile = file;
                if (virtualFile == null) {
                    Intrinsics.throwNpe();
                }
                return JGitMergeSession.this.getContent(virtualFile, this.isTheirs) == null ? "Deleted" : "Modified";
            }

            @NotNull
            public String getMaxStringValue() {
                return "Modified";
            }

            public int getAdditionalWidth() {
                return 10;
            }

            public StatusColumn(boolean isTheirs) {
                super(isTheirs ? "Theirs" : "Yours");
                this.isTheirs = isTheirs;
            }
        }
    }
}

