/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.actions.colors;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.intention.HighPriorityAction;
import com.intellij.css.util.CssPsiUtil;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Iconable;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.css.CssBundle;
import com.intellij.psi.css.CssElementFactory;
import com.intellij.psi.css.CssTerm;
import com.intellij.psi.css.CssTermList;
import com.intellij.psi.css.actions.colors.CssColorIntentionBase;
import com.intellij.psi.css.browse.ColorDeclarationType;
import com.intellij.psi.css.impl.util.CssPsiColorUtil;
import com.intellij.ui.ColorChooser;
import com.intellij.ui.ColorPickerListenerFactory;
import com.intellij.util.IncorrectOperationException;
import java.awt.Color;
import java.awt.Component;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CssChooseColorIntention
extends CssColorIntentionBase
implements Iconable,
HighPriorityAction {
    public void invoke(@NotNull Project project, Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        Color color;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/psi/css/actions/colors/CssChooseColorIntention", "invoke"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/css/actions/colors/CssChooseColorIntention", "invoke"));
        }
        PsiElement colorTerm = CssChooseColorIntention.getPossibleColorTerm(element);
        if (colorTerm != null && (color = CssPsiColorUtil.getColor(colorTerm)) != null) {
            CssChooseColorIntention.changeColorWithPicker(editor, color, ColorDeclarationType.fromColorTerm(colorTerm), colorTerm);
        }
    }

    @Override
    public boolean isAvailable(@NotNull Project project, Editor editor, @NotNull PsiElement element) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/psi/css/actions/colors/CssChooseColorIntention", "isAvailable"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/css/actions/colors/CssChooseColorIntention", "isAvailable"));
        }
        if (!super.isAvailable(project, editor, element)) {
            return false;
        }
        PsiElement colorTerm = CssChooseColorIntention.getPossibleColorTerm(element);
        if (colorTerm != null) {
            return CssPsiColorUtil.getColor(colorTerm) != null;
        }
        return false;
    }

    @NotNull
    public String getText() {
        String string = this.getFamilyName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/actions/colors/CssChooseColorIntention", "getText"));
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = CssBundle.message((String)"css.intentions.color.change", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/actions/colors/CssChooseColorIntention", "getFamilyName"));
        }
        return string;
    }

    public static void changeColorWithPicker(@Nullable Editor editor, @NotNull Color color, @NotNull ColorDeclarationType type, @Nullable PsiElement element) {
        if (color == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "color", "com/intellij/psi/css/actions/colors/CssChooseColorIntention", "changeColorWithPicker"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/psi/css/actions/colors/CssChooseColorIntention", "changeColorWithPicker"));
        }
        if (editor != null) {
            if (element == null || !element.isValid()) {
                return;
            }
            List listeners = ColorPickerListenerFactory.createListenersFor((PsiElement)element);
            Color newColor = ColorChooser.chooseColor((Component)editor.getComponent(), (String)CssBundle.message((String)"css.choose.color.dialog.title", (Object[])new Object[0]), (Color)color, (boolean)true, (List)listeners, (boolean)true);
            if (newColor != null) {
                CssChooseColorIntention.changeColor(editor, CssPsiColorUtil.convertTo(type, newColor), element);
            }
        }
    }

    private static void changeColor(@NotNull Editor editor, @NotNull String hexColor, @Nullable PsiElement element) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/psi/css/actions/colors/CssChooseColorIntention", "changeColor"));
        }
        if (hexColor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hexColor", "com/intellij/psi/css/actions/colors/CssChooseColorIntention", "changeColor"));
        }
        if (element != null && element.isValid()) {
            Project project = element.getProject();
            WriteCommandAction.runWriteCommandAction((Project)project, (String)"Update CSS color", null, () -> {
                if (editor == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/psi/css/actions/colors/CssChooseColorIntention", "lambda$changeColor$0"));
                }
                if (hexColor == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hexColor", "com/intellij/psi/css/actions/colors/CssChooseColorIntention", "lambda$changeColor$0"));
                }
                if (project.isDisposed() || editor.isDisposed()) {
                    return;
                }
                PsiDocumentManager.getInstance((Project)project).commitDocument(editor.getDocument());
                if (!element.isValid()) {
                    return;
                }
                if (!FileModificationService.getInstance().prepareFileForWrite(element.getContainingFile())) {
                    return;
                }
                CssElementFactory elementFactory = CssElementFactory.getInstance((Project)project);
                CssTermList termList = elementFactory.createPropertyValue(hexColor, CssPsiUtil.getStylesheetLanguage((PsiElement)element));
                if (element instanceof CssTermList) {
                    element.replace((PsiElement)termList);
                } else if (element instanceof CssTerm) {
                    element.replace(termList.getFirstChild());
                } else {
                    PsiElement term = termList.getFirstChild();
                    element.replace(term.getFirstChild());
                }
            }, (PsiFile[])new PsiFile[]{element.getContainingFile()});
        }
    }

    public Icon getIcon(@Iconable.IconFlags int flags) {
        return AllIcons.Gutter.Colors;
    }
}

