/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.actions.ruleset;

import com.intellij.lang.LanguageUtil;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.impl.SimpleDataContext;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.ex.IdeDocumentHistory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.openapi.util.Pass;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.css.StylesheetFile;
import com.intellij.psi.css.actions.ruleset.CurrentFileStyleCreator;
import com.intellij.psi.css.actions.ruleset.ExistingFileStyleCreator;
import com.intellij.psi.css.actions.ruleset.ExistingFileStyleCreatorWithChooser;
import com.intellij.psi.css.actions.ruleset.NewFileStyleCreator;
import com.intellij.psi.css.actions.ruleset.StyleCreator;
import com.intellij.psi.css.resolve.CssResolveManager;
import com.intellij.psi.css.resolve.CssResolver;
import com.intellij.psi.xml.XmlFile;
import com.intellij.util.containers.ContainerUtil;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class CssSelectTargetPopupFactory
extends BaseListPopupStep<StyleCreator> {
    private CssSelectTargetPopupFactory() {
    }

    @NotNull
    public static ListPopup createSelectTargetPopup(@NotNull String text, @NotNull PsiFile file, @NotNull Pass<StyleCreator> chooseItemCallback) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/psi/css/actions/ruleset/CssSelectTargetPopupFactory", "createSelectTargetPopup"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/css/actions/ruleset/CssSelectTargetPopupFactory", "createSelectTargetPopup"));
        }
        if (chooseItemCallback == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "chooseItemCallback", "com/intellij/psi/css/actions/ruleset/CssSelectTargetPopupFactory", "createSelectTargetPopup"));
        }
        DefaultActionGroup group = new DefaultActionGroup("", true);
        group.add(CssSelectTargetPopupFactory.wrapWithAction(chooseItemCallback, new CurrentFileStyleCreator(file)));
        PsiDirectory parentDirectory = file.getContainingDirectory();
        if (parentDirectory != null) {
            group.add(CssSelectTargetPopupFactory.wrapWithAction(chooseItemCallback, new NewFileStyleCreator(file)));
        }
        group.add(CssSelectTargetPopupFactory.wrapWithAction(chooseItemCallback, new ExistingFileStyleCreatorWithChooser(file)));
        HashSet filesToIgnore = ContainerUtil.newHashSet();
        CssSelectTargetPopupFactory.addCreatorsForLinkedFiles(file, group, filesToIgnore, chooseItemCallback);
        CssSelectTargetPopupFactory.addCreatorsForOpenFiles(file, group, filesToIgnore, chooseItemCallback);
        CssSelectTargetPopupFactory.addCreatorsForRecentFiles(file, group, filesToIgnore, chooseItemCallback);
        ListPopup listPopup = JBPopupFactory.getInstance().createActionGroupPopup(text, (ActionGroup)group, SimpleDataContext.getProjectContext((Project)file.getProject()), JBPopupFactory.ActionSelectionAid.SPEEDSEARCH, false, null, 10);
        if (listPopup == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/actions/ruleset/CssSelectTargetPopupFactory", "createSelectTargetPopup"));
        }
        return listPopup;
    }

    private static void addCreatorsForLinkedFiles(@NotNull PsiFile file, @NotNull DefaultActionGroup rootGroup, @NotNull Set<VirtualFile> filesToIgnore, @NotNull Pass<StyleCreator> chooseItemCallback) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/css/actions/ruleset/CssSelectTargetPopupFactory", "addCreatorsForLinkedFiles"));
        }
        if (rootGroup == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootGroup", "com/intellij/psi/css/actions/ruleset/CssSelectTargetPopupFactory", "addCreatorsForLinkedFiles"));
        }
        if (filesToIgnore == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filesToIgnore", "com/intellij/psi/css/actions/ruleset/CssSelectTargetPopupFactory", "addCreatorsForLinkedFiles"));
        }
        if (chooseItemCallback == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "chooseItemCallback", "com/intellij/psi/css/actions/ruleset/CssSelectTargetPopupFactory", "addCreatorsForLinkedFiles"));
        }
        if (file instanceof XmlFile) {
            CssResolver resolver = CssResolveManager.getInstance().getNewResolver();
            resolver.setStrictResolveMode(true);
            StylesheetFile[] stylesheetFiles = resolver.resolveStyleSheets((XmlFile)file, null);
            DefaultActionGroup linkedFilesGroup = new DefaultActionGroup("", true);
            linkedFilesGroup.addSeparator("Linked Files");
            if (!LanguageUtil.isInTemplateLanguageFile((PsiElement)file)) {
                for (StylesheetFile stylesheetFile : stylesheetFiles) {
                    linkedFilesGroup.add(CssSelectTargetPopupFactory.wrapWithAction(chooseItemCallback, new ExistingFileStyleCreator(file, stylesheetFile)));
                    filesToIgnore.add(stylesheetFile.getVirtualFile());
                }
            }
            if (linkedFilesGroup.getChildrenCount() > 0) {
                rootGroup.addAll((ActionGroup)linkedFilesGroup);
            }
        }
    }

    private static void addCreatorsForRecentFiles(@NotNull PsiFile contextFile, @NotNull DefaultActionGroup rootGroup, @NotNull Set<VirtualFile> filesToIgnore, @NotNull Pass<StyleCreator> chooseItemCallback) {
        if (contextFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contextFile", "com/intellij/psi/css/actions/ruleset/CssSelectTargetPopupFactory", "addCreatorsForRecentFiles"));
        }
        if (rootGroup == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootGroup", "com/intellij/psi/css/actions/ruleset/CssSelectTargetPopupFactory", "addCreatorsForRecentFiles"));
        }
        if (filesToIgnore == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filesToIgnore", "com/intellij/psi/css/actions/ruleset/CssSelectTargetPopupFactory", "addCreatorsForRecentFiles"));
        }
        if (chooseItemCallback == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "chooseItemCallback", "com/intellij/psi/css/actions/ruleset/CssSelectTargetPopupFactory", "addCreatorsForRecentFiles"));
        }
        DefaultActionGroup recentFilesGroup = new DefaultActionGroup("", true);
        recentFilesGroup.addSeparator("Recent Files");
        VirtualFile[] recentEditedFiles = IdeDocumentHistory.getInstance((Project)contextFile.getProject()).getChangedFiles();
        CssSelectTargetPopupFactory.addStylesheetFilesToGroup(recentEditedFiles, contextFile, chooseItemCallback, filesToIgnore, recentFilesGroup);
        if (recentFilesGroup.getChildrenCount() > 0) {
            rootGroup.addAll((ActionGroup)recentFilesGroup);
        }
    }

    private static void addCreatorsForOpenFiles(@NotNull PsiFile contextFile, @NotNull DefaultActionGroup rootGroup, @NotNull Set<VirtualFile> filesToIgnore, @NotNull Pass<StyleCreator> chooseItemCallback) {
        if (contextFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contextFile", "com/intellij/psi/css/actions/ruleset/CssSelectTargetPopupFactory", "addCreatorsForOpenFiles"));
        }
        if (rootGroup == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootGroup", "com/intellij/psi/css/actions/ruleset/CssSelectTargetPopupFactory", "addCreatorsForOpenFiles"));
        }
        if (filesToIgnore == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filesToIgnore", "com/intellij/psi/css/actions/ruleset/CssSelectTargetPopupFactory", "addCreatorsForOpenFiles"));
        }
        if (chooseItemCallback == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "chooseItemCallback", "com/intellij/psi/css/actions/ruleset/CssSelectTargetPopupFactory", "addCreatorsForOpenFiles"));
        }
        DefaultActionGroup recentFilesGroup = new DefaultActionGroup("", true);
        recentFilesGroup.addSeparator("Opened Files");
        VirtualFile[] openFiles = FileEditorManager.getInstance((Project)contextFile.getProject()).getOpenFiles();
        CssSelectTargetPopupFactory.addStylesheetFilesToGroup(openFiles, contextFile, chooseItemCallback, filesToIgnore, recentFilesGroup);
        if (recentFilesGroup.getChildrenCount() > 0) {
            rootGroup.addAll((ActionGroup)recentFilesGroup);
        }
    }

    private static void addStylesheetFilesToGroup(@NotNull VirtualFile[] files, @NotNull PsiFile contextFile, @NotNull Pass<StyleCreator> callback, @NotNull Set<VirtualFile> filesToIgnore, @NotNull DefaultActionGroup targetGroup) {
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "com/intellij/psi/css/actions/ruleset/CssSelectTargetPopupFactory", "addStylesheetFilesToGroup"));
        }
        if (contextFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contextFile", "com/intellij/psi/css/actions/ruleset/CssSelectTargetPopupFactory", "addStylesheetFilesToGroup"));
        }
        if (callback == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callback", "com/intellij/psi/css/actions/ruleset/CssSelectTargetPopupFactory", "addStylesheetFilesToGroup"));
        }
        if (filesToIgnore == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filesToIgnore", "com/intellij/psi/css/actions/ruleset/CssSelectTargetPopupFactory", "addStylesheetFilesToGroup"));
        }
        if (targetGroup == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targetGroup", "com/intellij/psi/css/actions/ruleset/CssSelectTargetPopupFactory", "addStylesheetFilesToGroup"));
        }
        PsiManager psiManager = contextFile.getManager();
        for (VirtualFile virtualFile : files) {
            PsiFile psiFile;
            if (filesToIgnore.contains(virtualFile) || (psiFile = psiManager.findFile(virtualFile)) == null || !(psiFile instanceof StylesheetFile)) continue;
            targetGroup.add(CssSelectTargetPopupFactory.wrapWithAction(callback, new ExistingFileStyleCreator(contextFile, (StylesheetFile)psiFile)));
            filesToIgnore.add(virtualFile);
        }
    }

    @NotNull
    private static AnAction wrapWithAction(final @NotNull Pass<StyleCreator> pass, final @NotNull StyleCreator creator) {
        if (pass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pass", "com/intellij/psi/css/actions/ruleset/CssSelectTargetPopupFactory", "wrapWithAction"));
        }
        if (creator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "creator", "com/intellij/psi/css/actions/ruleset/CssSelectTargetPopupFactory", "wrapWithAction"));
        }
        AnAction anAction = new AnAction(){

            public void update(@NotNull AnActionEvent e) {
                if (e == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/psi/css/actions/ruleset/CssSelectTargetPopupFactory$1", "update"));
                }
                e.getPresentation().setText(creator.getName(), false);
            }

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/psi/css/actions/ruleset/CssSelectTargetPopupFactory$1", "actionPerformed"));
                }
                pass.pass((Object)creator);
            }
        };
        if (anAction == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/actions/ruleset/CssSelectTargetPopupFactory", "wrapWithAction"));
        }
        return anAction;
    }
}

