/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.impl.descriptor.value;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.css.descriptor.value.CssValueDescriptorVisitor;
import com.intellij.psi.css.impl.descriptor.CssCommonDescriptorData;
import com.intellij.psi.css.impl.descriptor.value.CssValueDescriptorBase;
import com.intellij.psi.css.impl.descriptor.value.CssValueDescriptorData;
import com.intellij.psi.css.impl.descriptor.value.CssValueDescriptorVisitorImpl;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CssFunctionInvocationValue
extends CssValueDescriptorBase {
    @NotNull
    private final String myFunctionName;

    public CssFunctionInvocationValue(@Nullable String functionName, @NotNull CssCommonDescriptorData commonDescriptorData, @NotNull CssValueDescriptorData valueDescriptorData) {
        if (commonDescriptorData == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commonDescriptorData", "com/intellij/psi/css/impl/descriptor/value/CssFunctionInvocationValue", "<init>"));
        }
        if (valueDescriptorData == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "valueDescriptorData", "com/intellij/psi/css/impl/descriptor/value/CssFunctionInvocationValue", "<init>"));
        }
        super(commonDescriptorData, valueDescriptorData);
        this.myFunctionName = StringUtil.notNullize((String)functionName, (String)this.getId());
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)this.myFunctionName) ? 1 : 0) != 0);
    }

    @NotNull
    public String getFunctionName() {
        String string = this.myFunctionName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/descriptor/value/CssFunctionInvocationValue", "getFunctionName"));
        }
        return string;
    }

    @Override
    public void accept(CssValueDescriptorVisitor visitor) {
        if (visitor instanceof CssValueDescriptorVisitorImpl) {
            ((CssValueDescriptorVisitorImpl)visitor).visitFunctionValue(this);
        } else {
            super.accept(visitor);
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CssFunctionInvocationValue)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        CssFunctionInvocationValue value = (CssFunctionInvocationValue)o;
        return this.myFunctionName.equals(value.myFunctionName);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.myFunctionName.hashCode();
        return result;
    }
}

