/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.impl.util.table;

import com.google.common.collect.Ordering;
import com.google.common.collect.Sets;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.css.CssDeclaration;
import com.intellij.psi.css.CssPropertyDescriptor;
import com.intellij.psi.css.CssPropertyValue;
import com.intellij.psi.css.impl.util.table.CssElementDescriptorConstants;
import com.intellij.util.ArrayUtilRt;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.jetbrains.annotations.NotNull;

public class CssPropertyUtil {
    @NotNull
    public static String getVendorPrefix(@NotNull String propertyName) {
        if (propertyName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertyName", "com/intellij/psi/css/impl/util/table/CssPropertyUtil", "getVendorPrefix"));
        }
        if (propertyName.length() >= 4) {
            for (String s : CssElementDescriptorConstants.VENDOR_SPECIFIC_ELEMENT_PREFIXES) {
                if (!propertyName.startsWith(s)) continue;
                String string = s;
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/util/table/CssPropertyUtil", "getVendorPrefix"));
                }
                return string;
            }
        }
        if ("" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/util/table/CssPropertyUtil", "getVendorPrefix"));
        }
        return "";
    }

    public static boolean isVendorSpecificElement(@NotNull String propertyName) {
        if (propertyName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertyName", "com/intellij/psi/css/impl/util/table/CssPropertyUtil", "isVendorSpecificElement"));
        }
        if (propertyName.length() < 4) {
            return false;
        }
        for (String s : CssElementDescriptorConstants.VENDOR_SPECIFIC_ELEMENT_PREFIXES) {
            if (!propertyName.startsWith(s)) continue;
            return true;
        }
        return ArrayUtilRt.find((Object[])CssElementDescriptorConstants.IE_PROPERTIES, (Object)propertyName) >= 0;
    }

    @NotNull
    public static String getElementNameWithoutVendorPrefix(@NotNull String elementName) {
        if (elementName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementName", "com/intellij/psi/css/impl/util/table/CssPropertyUtil", "getElementNameWithoutVendorPrefix"));
        }
        if (elementName.length() < 4) {
            String string = elementName;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/util/table/CssPropertyUtil", "getElementNameWithoutVendorPrefix"));
            }
            return string;
        }
        for (String s : CssElementDescriptorConstants.VENDOR_SPECIFIC_ELEMENT_PREFIXES) {
            if (!elementName.startsWith(s)) continue;
            String string = elementName.substring(s.length());
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/util/table/CssPropertyUtil", "getElementNameWithoutVendorPrefix"));
            }
            return string;
        }
        String string = elementName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/util/table/CssPropertyUtil", "getElementNameWithoutVendorPrefix"));
        }
        return string;
    }

    public static Map<String, String> getExpandedShorthandValues(CssDeclaration declaration, String[] properties) {
        HashSet<String> usedValues = new HashSet<String>();
        HashMap<String, Set<String>> ambiguousValues = new HashMap<String, Set<String>>();
        TreeMap<String, String> result = new TreeMap<String, String>();
        for (String name : properties) {
            String[] value = declaration.getShorthandValue(name);
            if (value == null || value.length <= 0) continue;
            LinkedHashSet<String> valuesSet = new LinkedHashSet<String>(Arrays.asList(value));
            if (valuesSet.size() == 1) {
                result.put(name, StringUtil.join(valuesSet, (String)CssPropertyUtil.getValuesDelimiter(declaration, name)));
                usedValues.addAll(valuesSet);
                continue;
            }
            ambiguousValues.put(name, valuesSet);
        }
        CssPropertyUtil.fillAmbiguousValuesProperties(result, ambiguousValues, usedValues, declaration);
        return result;
    }

    private static void fillAmbiguousValuesProperties(Map<String, String> name2value, Map<String, Set<String>> ambiguousValues, Set<String> usedValues, CssDeclaration declaration) {
        List<Map.Entry<String, Set<String>>> sortedAmbiguousValues = CssPropertyUtil.getSortedAmbiguousValuesBySuggestionsCount(ambiguousValues);
        for (Map.Entry<String, Set<String>> entry : sortedAmbiguousValues) {
            String propertyName = entry.getKey();
            Set<String> values = entry.getValue();
            values.removeAll((Collection<?>)Sets.intersection(usedValues, values));
            if (values.isEmpty()) continue;
            name2value.put(propertyName, StringUtil.join(values, (String)CssPropertyUtil.getValuesDelimiter(declaration, propertyName)));
            usedValues.addAll(values);
        }
    }

    private static List<Map.Entry<String, Set<String>>> getSortedAmbiguousValuesBySuggestionsCount(Map<String, Set<String>> ambiguousValues) {
        return Ordering.from((Comparator)new Comparator<Map.Entry<String, Set<String>>>(){

            @Override
            public int compare(Map.Entry<String, Set<String>> o1, Map.Entry<String, Set<String>> o2) {
                return o1.getValue().size() - o2.getValue().size();
            }
        }).sortedCopy(ambiguousValues.entrySet());
    }

    private static String getValuesDelimiter(CssDeclaration cssDeclaration, String propertyName) {
        CssPropertyDescriptor descriptor = cssDeclaration.getDescriptor();
        CssPropertyValue cssPropertyValue = descriptor != null ? descriptor.getReferencedPropertyValue(propertyName) : null;
        return cssPropertyValue != null ? cssPropertyValue.getValuesDelimiter() : " ";
    }
}

