/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.inspections;

import com.google.common.collect.Sets;
import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.css.CssBlock;
import com.intellij.psi.css.CssBundle;
import com.intellij.psi.css.CssDeclaration;
import com.intellij.psi.css.CssElementVisitor;
import com.intellij.psi.css.CssTermList;
import com.intellij.psi.css.impl.util.table.CssDescriptorsUtil;
import com.intellij.psi.css.inspections.CssBaseInspection;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CssOptimizeSimilarPropertiesInspection
extends CssBaseInspection {
    @Nls
    @NotNull
    public String getDisplayName() {
        String string = CssBundle.message((String)"css.inspections.optimize.similar.properties", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/inspections/CssOptimizeSimilarPropertiesInspection", "getDisplayName"));
        }
        return string;
    }

    @NotNull
    public HighlightDisplayLevel getDefaultLevel() {
        HighlightDisplayLevel highlightDisplayLevel = HighlightDisplayLevel.WEAK_WARNING;
        if (highlightDisplayLevel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/inspections/CssOptimizeSimilarPropertiesInspection", "getDefaultLevel"));
        }
        return highlightDisplayLevel;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/psi/css/inspections/CssOptimizeSimilarPropertiesInspection", "buildVisitor"));
        }
        CssElementVisitor cssElementVisitor = new CssElementVisitor(){

            public void visitCssBlock(CssBlock block) {
                super.visitCssBlock(block);
                ShorthandRuleContainer container = new ShorthandRuleContainer();
                for (CssDeclaration decl : block.getDeclarations()) {
                    ShorthandRule rule;
                    if (decl.isHack() || (rule = container.getOrCreateRule(decl)) == null) continue;
                    rule.addDeclaration(decl);
                }
                for (ShorthandRule rule : container.getRules()) {
                    if (!rule.isValid()) continue;
                    rule.registerProblem(holder);
                }
            }
        };
        if (cssElementVisitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/inspections/CssOptimizeSimilarPropertiesInspection", "buildVisitor"));
        }
        return cssElementVisitor;
    }

    private static class SafariBorderImageRule
    extends BorderImageRule {
        private static final String prefix = "-webkit-";

        public SafariBorderImageRule() {
            super(prefix);
        }
    }

    private static class MozillaBorderImageRule
    extends BorderImageRule {
        private static final String prefix = "-moz-";

        public MozillaBorderImageRule() {
            super(prefix);
        }
    }

    private static class BorderImageRule
    extends BorderRule {
        private final String myPrefix;
        private static final String PROPETY_NAME = "border-image";

        public BorderImageRule(String prefix) {
            super(prefix + PROPETY_NAME);
            this.myPrefix = prefix;
        }

        public BorderImageRule() {
            this("");
        }

        @Override
        protected String get(@NotNull @NonNls String side, @NotNull @NonNls String suffix) {
            if (side == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "side", "com/intellij/psi/css/inspections/CssOptimizeSimilarPropertiesInspection$BorderImageRule", "get"));
            }
            if (suffix == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "suffix", "com/intellij/psi/css/inspections/CssOptimizeSimilarPropertiesInspection$BorderImageRule", "get"));
            }
            return (String)this.myPropertiesMap.get(this.myPrefix + "border-" + side + "-" + suffix);
        }

        private static boolean hasMoreThanOneUrl(String attributes) {
            int cnt = 0;
            int index;
            while ((index = attributes.indexOf("url")) != -1) {
                ++cnt;
                attributes = attributes.substring(index + 1);
            }
            return cnt > 1;
        }

        @Override
        @NotNull
        protected Map<String, String> optimizeBorder() {
            com.intellij.util.containers.HashMap map;
            String[] images = new String[4];
            this.fill("image", images);
            boolean canBeOptimized = true;
            String commonValue = null;
            for (String value : images) {
                if (!canBeOptimized) break;
                if (value == null) continue;
                if ("inherit".equals(value)) {
                    if (commonValue != null && !commonValue.equals(value)) {
                        canBeOptimized = false;
                        continue;
                    }
                    commonValue = value;
                    continue;
                }
                if (BorderImageRule.hasMoreThanOneUrl(value)) {
                    canBeOptimized = false;
                    continue;
                }
                if (commonValue == null) {
                    commonValue = value;
                    continue;
                }
                if (commonValue.equals(value)) continue;
                commonValue = "";
            }
            if (!canBeOptimized) {
                Map map2 = this.myPropertiesMap;
                if (map2 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/inspections/CssOptimizeSimilarPropertiesInspection$BorderImageRule", "optimizeBorder"));
                }
                return map2;
            }
            if (commonValue != null && !commonValue.isEmpty()) {
                map = new com.intellij.util.containers.HashMap();
                map.put((Object)(this.myPrefix + PROPETY_NAME), (Object)commonValue);
                com.intellij.util.containers.HashMap hashMap = map;
                if (hashMap == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/inspections/CssOptimizeSimilarPropertiesInspection$BorderImageRule", "optimizeBorder"));
                }
                return hashMap;
            }
            map = new com.intellij.util.containers.HashMap();
            String attribute = "";
            for (int i = 0; i < 4; ++i) {
                attribute = images[i] == null ? attribute + " none" : attribute + " " + images[i];
            }
            map.put((Object)(this.myPrefix + PROPETY_NAME), (Object)attribute);
            com.intellij.util.containers.HashMap hashMap = map;
            if (hashMap == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/inspections/CssOptimizeSimilarPropertiesInspection$BorderImageRule", "optimizeBorder"));
            }
            return hashMap;
        }
    }

    private static class BorderCornerImageRule
    extends CornerRule {
        private static final String PROPERTY_NAME = "border-corner-image";

        public BorderCornerImageRule(String prefix) {
            super(prefix, PROPERTY_NAME);
        }

        public BorderCornerImageRule() {
            super("", PROPERTY_NAME);
        }

        @Override
        @NotNull
        protected Map<String, String> optimizeBorder() {
            String[] images = new String[4];
            this.fill("image", images);
            boolean allNone = true;
            boolean allInherit = true;
            boolean allNotNull = true;
            String commonValue = images[0];
            for (String image : images) {
                if (image == null) {
                    allNotNull = false;
                    continue;
                }
                boolean isValue = true;
                if (!"none".equals(image)) {
                    allNone = false;
                } else {
                    isValue = false;
                }
                if (!"inherit".equals(image)) {
                    allInherit = false;
                } else {
                    isValue = false;
                }
                if (isValue && commonValue != null && !commonValue.equals(image)) {
                    commonValue = null;
                }
                if (isValue) continue;
                commonValue = null;
            }
            LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
            if (allNotNull) {
                if (allNone) {
                    result.put(this.myPrefix + PROPERTY_NAME, "none");
                } else if (allInherit) {
                    result.put(this.myPrefix + PROPERTY_NAME, "inherit");
                } else if (commonValue != null) {
                    result.put(this.myPrefix + PROPERTY_NAME, commonValue);
                } else {
                    StringBuilder builder = new StringBuilder();
                    for (int i = 0; i < 4; ++i) {
                        builder.append(images[i] == null ? "none" : images[i]);
                        builder.append(" ");
                    }
                    if (builder.length() > 0) {
                        builder.replace(builder.length() - 1, builder.length(), "");
                    }
                    result.put(this.myPrefix + PROPERTY_NAME, builder.toString());
                }
                LinkedHashMap<String, String> linkedHashMap = result;
                if (linkedHashMap == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/inspections/CssOptimizeSimilarPropertiesInspection$BorderCornerImageRule", "optimizeBorder"));
                }
                return linkedHashMap;
            }
            if (allNone) {
                result.put(this.myPrefix + PROPERTY_NAME, "none");
                LinkedHashMap<String, String> linkedHashMap = result;
                if (linkedHashMap == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/inspections/CssOptimizeSimilarPropertiesInspection$BorderCornerImageRule", "optimizeBorder"));
                }
                return linkedHashMap;
            }
            Map map = this.myPropertiesMap;
            if (map == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/inspections/CssOptimizeSimilarPropertiesInspection$BorderCornerImageRule", "optimizeBorder"));
            }
            return map;
        }
    }

    private static class SafariBorderRadiusRule
    extends BorderRadiusRule {
        private static final String prefix = "-webkit-";

        public SafariBorderRadiusRule() {
            super(prefix);
        }
    }

    private static class MozillaBorderRadiusRule
    extends BorderRadiusRule {
        private static final String prefix = "-moz-";

        public MozillaBorderRadiusRule() {
            super(prefix);
        }

        @Override
        protected String get(@NotNull @NonNls String side, @NotNull @NonNls String suffix) {
            if (side == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "side", "com/intellij/psi/css/inspections/CssOptimizeSimilarPropertiesInspection$MozillaBorderRadiusRule", "get"));
            }
            if (suffix == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "suffix", "com/intellij/psi/css/inspections/CssOptimizeSimilarPropertiesInspection$MozillaBorderRadiusRule", "get"));
            }
            return (String)this.myPropertiesMap.get(this.myPrefix + "border-" + suffix + '-' + side.replace("-", ""));
        }
    }

    private static class BorderRadiusRule
    extends CornerRule {
        protected BorderRadiusRule(@NonNls String prefix) {
            super(prefix, "border-radius");
        }

        public BorderRadiusRule() {
            this("");
        }

        @Override
        @NotNull
        protected Map<String, String> optimizeBorder() {
            String[] radius = new String[4];
            boolean fullRadius = this.fill("radius", radius);
            String border = null;
            if (fullRadius) {
                border = BorderRadiusRule.commonValue(radius);
            }
            LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
            boolean allDefined = true;
            for (int i = 0; i < 4; ++i) {
                if (radius[i] != null) continue;
                allDefined = false;
            }
            if (allDefined) {
                String argument = radius[0];
                boolean hasDifferent = false;
                for (int i = 1; i < 4; ++i) {
                    argument = argument + " " + radius[i];
                    if (radius[0].equals(radius[i])) continue;
                    hasDifferent = true;
                }
                BorderRadiusRule.createValue(result, this.myPrefix + "border-radius", hasDifferent ? argument : border, null);
                LinkedHashMap<String, String> linkedHashMap = result;
                if (linkedHashMap == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/inspections/CssOptimizeSimilarPropertiesInspection$BorderRadiusRule", "optimizeBorder"));
                }
                return linkedHashMap;
            }
            BorderRadiusRule.createValue(result, this.myPrefix + "border-radius", border, null);
            BorderRadiusRule.createValue(result, this.myPrefix + "border-top-left-radius", radius[0], border);
            BorderRadiusRule.createValue(result, this.myPrefix + "border-top-right-radius", radius[1], border);
            BorderRadiusRule.createValue(result, this.myPrefix + "border-bottom-right-radius", radius[2], border);
            BorderRadiusRule.createValue(result, this.myPrefix + "border-bottom-left-radius", radius[3], border);
            LinkedHashMap<String, String> linkedHashMap = result;
            if (linkedHashMap == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/inspections/CssOptimizeSimilarPropertiesInspection$BorderRadiusRule", "optimizeBorder"));
            }
            return linkedHashMap;
        }

        @Nullable
        private static String commonValue(@NotNull String[] values) {
            if (values == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "values", "com/intellij/psi/css/inspections/CssOptimizeSimilarPropertiesInspection$BorderRadiusRule", "commonValue"));
            }
            for (int i = 0; i < 4; ++i) {
                int equals = 0;
                for (int j = 0; j < 4; ++j) {
                    if (!values[i].equals(values[j])) continue;
                    ++equals;
                }
                if (equals <= true) continue;
                return values[i];
            }
            return null;
        }

        private static void createValue(Map<String, String> map, @NonNls String key, String value, @Nullable String defaultValue) {
            if (value != null && !value.equals(defaultValue)) {
                map.put(key, value);
            }
        }
    }

    private static class CornerRule
    extends BorderRule {
        @NonNls
        protected final String myPrefix;
        @NonNls
        protected final String myMainPropertyName;

        protected CornerRule(@NonNls String prefix, @NonNls String propertyName) {
            super(prefix + propertyName);
            this.myPrefix = prefix;
            this.myMainPropertyName = propertyName;
        }

        @Override
        protected String get(@NotNull @NonNls String side, @NotNull @NonNls String suffix) {
            if (side == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "side", "com/intellij/psi/css/inspections/CssOptimizeSimilarPropertiesInspection$CornerRule", "get"));
            }
            if (suffix == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "suffix", "com/intellij/psi/css/inspections/CssOptimizeSimilarPropertiesInspection$CornerRule", "get"));
            }
            return (String)this.myPropertiesMap.get(this.myPrefix + "border-" + side + "-" + suffix);
        }

        @Override
        @NonNls
        protected String[] getDefinedValues(@NotNull @NonNls String suffix) {
            String[] sides;
            if (suffix == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "suffix", "com/intellij/psi/css/inspections/CssOptimizeSimilarPropertiesInspection$CornerRule", "getDefinedValues"));
            }
            ArrayList<String> result = new ArrayList<String>();
            for (String side : sides = new String[]{"top-left", "top-right", "bottom-right", "bottom-left"}) {
                if (null == this.get(side, suffix)) continue;
                result.add(side);
            }
            return ArrayUtil.toStringArray(result);
        }

        @Override
        protected boolean fill(@NotNull @NonNls String suffix, @NotNull String[] values) {
            String[] sideValues;
            if (suffix == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "suffix", "com/intellij/psi/css/inspections/CssOptimizeSimilarPropertiesInspection$CornerRule", "fill"));
            }
            if (values == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "values", "com/intellij/psi/css/inspections/CssOptimizeSimilarPropertiesInspection$CornerRule", "fill"));
            }
            for (String side : sideValues = this.getDefinedValues(suffix)) {
                if ("top-left".equals(side)) {
                    values[0] = this.get(side, suffix);
                    continue;
                }
                if ("top-right".equals(side)) {
                    values[1] = this.get(side, suffix);
                    continue;
                }
                if ("bottom-right".equals(side)) {
                    values[2] = this.get(side, suffix);
                    continue;
                }
                if (!"bottom-left".equals(side)) continue;
                values[3] = this.get(side, suffix);
            }
            return sideValues.length == 4;
        }
    }

    private static class BorderRule
    extends BackgroundRule {
        protected Map<String, String> myOptimizedBorder;

        public BorderRule() {
            super("border");
        }

        protected BorderRule(@NonNls String s) {
            super(s);
        }

        @Override
        public boolean isValid() {
            List<CssDeclaration> properties = this.getProperties();
            if (properties.size() < 2) {
                return false;
            }
            if (!this.fillPropertiesMap()) {
                return false;
            }
            this.myOptimizedBorder = this.optimizeBorder();
            return this.myOptimizedBorder.size() < properties.size();
        }

        @NotNull
        protected Map<String, String> optimizeBorder() {
            boolean moreThanOneFilledValues;
            String[] width = new String[4];
            String[] color = new String[4];
            String[] style = new String[4];
            boolean fullWidth = this.fill("width", width);
            boolean fullColor = this.fill("color", color);
            boolean fullStyle = this.fill("style", style);
            String[] border = new String[3];
            boolean bl = moreThanOneFilledValues = fullColor && fullWidth && fullStyle || !(fullColor ^ fullWidth ^ fullStyle);
            if (fullWidth) {
                Pair<String, String[]> widthPair = BorderRule.common(width);
                if (moreThanOneFilledValues || BorderRule.isNullArray((String[])widthPair.second)) {
                    border[0] = (String)widthPair.first;
                    String[] stringArray = width = border[0] == null ? width : (String[])widthPair.second;
                }
            }
            if (fullStyle) {
                Pair<String, String[]> stylePair = BorderRule.common(style);
                if (moreThanOneFilledValues || BorderRule.isNullArray((String[])stylePair.second)) {
                    border[1] = (String)stylePair.first;
                    String[] stringArray = style = border[1] == null ? style : (String[])stylePair.second;
                }
            }
            if (fullColor) {
                Pair<String, String[]> colorPair = BorderRule.common(color);
                if (moreThanOneFilledValues || BorderRule.isNullArray((String[])colorPair.second)) {
                    border[2] = (String)colorPair.first;
                    color = border[2] == null ? color : (String[])colorPair.second;
                }
            }
            LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
            this.createValue("border", result, border[0], border[1], border[2]);
            this.createValue("border-top", result, width[0], style[0], color[0]);
            this.createValue("border-right", result, width[1], style[1], color[1]);
            this.createValue("border-bottom", result, width[2], style[2], color[2]);
            this.createValue("border-left", result, width[3], style[3], color[3]);
            LinkedHashMap<String, String> linkedHashMap = result;
            if (linkedHashMap == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/inspections/CssOptimizeSimilarPropertiesInspection$BorderRule", "optimizeBorder"));
            }
            return linkedHashMap;
        }

        private static boolean isNullArray(String[] array) {
            for (String s : array) {
                if (s == null) continue;
                return false;
            }
            return true;
        }

        private void createValue(@NotNull @NonNls String prefix, @NotNull Map<String, String> result, @Nullable String width, @Nullable String style, @Nullable String color) {
            if (prefix == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "prefix", "com/intellij/psi/css/inspections/CssOptimizeSimilarPropertiesInspection$BorderRule", "createValue"));
            }
            if (result == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/psi/css/inspections/CssOptimizeSimilarPropertiesInspection$BorderRule", "createValue"));
            }
            StringBuilder sb = new StringBuilder();
            if (width != null) {
                if (style == null && color == null) {
                    result.put(prefix + "-width", width);
                    return;
                }
                sb.append(width);
            }
            if (style != null) {
                if (width == null && color == null) {
                    result.put(prefix + "-style", style);
                    return;
                }
                sb.append(' ').append(style);
            }
            if (color != null) {
                if (width == null && style == null) {
                    result.put(prefix + "-color", color);
                    return;
                }
                sb.append(' ').append(color);
            }
            if (sb.length() > 0) {
                if (this.myImportant) {
                    sb.append(" !important");
                }
                result.put(prefix, sb.toString().trim());
            }
        }

        @NotNull
        protected static Pair<String, String[]> common(@NotNull String[] values) {
            if (values == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "values", "com/intellij/psi/css/inspections/CssOptimizeSimilarPropertiesInspection$BorderRule", "common"));
            }
            String[] result = null;
            int max_count = 0;
            String result_value = null;
            for (int i = 0; i < 4; ++i) {
                String v = values[i];
                int count = 4;
                String[] temp = new String[4];
                for (int k = 0; k < 4; ++k) {
                    if (values[k].equals(v)) continue;
                    temp[k] = values[k];
                    --count;
                }
                if (max_count >= count) continue;
                result = temp;
                max_count = count;
                result_value = v;
                if (max_count > 1) break;
            }
            Pair pair = Pair.create(result_value, result);
            if (pair == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/inspections/CssOptimizeSimilarPropertiesInspection$BorderRule", "common"));
            }
            return pair;
        }

        protected boolean fill(@NotNull @NonNls String suffix, @NotNull String[] values) {
            String[] sideValues;
            if (suffix == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "suffix", "com/intellij/psi/css/inspections/CssOptimizeSimilarPropertiesInspection$BorderRule", "fill"));
            }
            if (values == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "values", "com/intellij/psi/css/inspections/CssOptimizeSimilarPropertiesInspection$BorderRule", "fill"));
            }
            for (String side : sideValues = this.getDefinedValues(suffix)) {
                if ("top".equals(side)) {
                    values[0] = this.get(side, suffix);
                    continue;
                }
                if ("right".equals(side)) {
                    values[1] = this.get(side, suffix);
                    continue;
                }
                if ("bottom".equals(side)) {
                    values[2] = this.get(side, suffix);
                    continue;
                }
                if (!"left".equals(side)) continue;
                values[3] = this.get(side, suffix);
            }
            return sideValues.length == 4;
        }

        @Nullable
        @NonNls
        protected String get(@NotNull @NonNls String side, @NotNull @NonNls String suffix) {
            if (side == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "side", "com/intellij/psi/css/inspections/CssOptimizeSimilarPropertiesInspection$BorderRule", "get"));
            }
            if (suffix == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "suffix", "com/intellij/psi/css/inspections/CssOptimizeSimilarPropertiesInspection$BorderRule", "get"));
            }
            return (String)this.myPropertiesMap.get("border-" + side + "-" + suffix);
        }

        protected String[] getDefinedValues(@NotNull @NonNls String suffix) {
            if (suffix == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "suffix", "com/intellij/psi/css/inspections/CssOptimizeSimilarPropertiesInspection$BorderRule", "getDefinedValues"));
            }
            ArrayList<String> result = new ArrayList<String>();
            String[] sides = new String[]{"top", "right", "bottom", "left"};
            for (int i = 0; i < sides.length; ++i) {
                String side = sides[i];
                if (null == this.get(side, suffix)) continue;
                result.add(side);
            }
            return ArrayUtil.toStringArray(result);
        }

        @Override
        protected void doApplyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/psi/css/inspections/CssOptimizeSimilarPropertiesInspection$BorderRule", "doApplyFix"));
            }
            if (descriptor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/psi/css/inspections/CssOptimizeSimilarPropertiesInspection$BorderRule", "doApplyFix"));
            }
            try {
                CssBlock block = (CssBlock)PsiTreeUtil.getParentOfType((PsiElement)descriptor.getPsiElement(), CssBlock.class);
                if (block == null) {
                    return;
                }
                List<CssDeclaration> properties = this.calcMyProperties(block);
                if (properties.isEmpty()) {
                    return;
                }
                CssDeclaration anchor = properties.get(properties.size() - 1);
                Set<String> names = this.myOptimizedBorder.keySet();
                ArrayList<String> reversed = new ArrayList<String>(names);
                Collections.reverse(reversed);
                for (String name : reversed) {
                    block.addDeclaration(name, this.myOptimizedBorder.get(name), anchor);
                }
                for (CssDeclaration property : properties) {
                    block.removeDeclaration(property);
                }
            }
            catch (IncorrectOperationException e) {
                CssBaseInspection.LOG.error((Throwable)e);
            }
        }
    }

    private static class PaddingRule
    extends MarginRule {
        public PaddingRule() {
            super("padding");
        }

        @Override
        @NonNls
        @NotNull
        protected String getPrefix() {
            if ("padding-" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/inspections/CssOptimizeSimilarPropertiesInspection$PaddingRule", "getPrefix"));
            }
            return "padding-";
        }
    }

    private static class MarginRule
    extends BackgroundRule {
        public MarginRule() {
            super("margin");
        }

        protected MarginRule(@NotNull @NonNls String shorthandName) {
            if (shorthandName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "shorthandName", "com/intellij/psi/css/inspections/CssOptimizeSimilarPropertiesInspection$MarginRule", "<init>"));
            }
            super(shorthandName);
        }

        @Override
        public boolean isValid() {
            if (this.getProperties().size() < 2) {
                return false;
            }
            if (!this.fillPropertiesMap()) {
                return false;
            }
            return this.myPropertiesMap.size() >= 4;
        }

        @NonNls
        @NotNull
        private String get(@NotNull @NonNls String prefix) {
            if (prefix == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "prefix", "com/intellij/psi/css/inspections/CssOptimizeSimilarPropertiesInspection$MarginRule", "get"));
            }
            String string = (String)this.myPropertiesMap.get(this.getPrefix() + prefix);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/inspections/CssOptimizeSimilarPropertiesInspection$MarginRule", "get"));
            }
            return string;
        }

        @NonNls
        @NotNull
        protected String getPrefix() {
            if ("margin-" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/inspections/CssOptimizeSimilarPropertiesInspection$MarginRule", "getPrefix"));
            }
            return "margin-";
        }

        @Override
        protected void doApplyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/psi/css/inspections/CssOptimizeSimilarPropertiesInspection$MarginRule", "doApplyFix"));
            }
            if (descriptor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/psi/css/inspections/CssOptimizeSimilarPropertiesInspection$MarginRule", "doApplyFix"));
            }
            try {
                CssBlock block;
                String top = this.get("top");
                String right = this.get("right");
                String bottom = this.get("bottom");
                String left = this.get("left");
                StringBuilder sb = new StringBuilder();
                if (top.equals(bottom) && left.equals(right)) {
                    if (top.equals(right)) {
                        sb.append(top);
                    } else {
                        sb.append(top).append(' ').append(right);
                    }
                } else if (left.equals(right)) {
                    sb.append(top).append(' ').append(right).append(' ').append(bottom);
                } else {
                    sb.append(top).append(' ').append(right).append(' ').append(bottom).append(' ').append(left);
                }
                if (this.myImportant) {
                    sb.append(" !important");
                }
                if ((block = (CssBlock)PsiTreeUtil.getParentOfType((PsiElement)descriptor.getPsiElement(), CssBlock.class)) == null) {
                    return;
                }
                List<CssDeclaration> properties = this.calcMyProperties(block);
                if (properties.isEmpty()) {
                    return;
                }
                CssDeclaration anchor = properties.get(properties.size() - 1);
                block.addDeclaration(this.getShorthandName(), sb.toString().trim(), anchor);
                for (CssDeclaration property : properties) {
                    block.removeDeclaration(property);
                }
            }
            catch (IncorrectOperationException e) {
                CssBaseInspection.LOG.error((Throwable)e);
            }
        }
    }

    private static class OutlineRule
    extends BackgroundRule {
        public OutlineRule() {
            super("outline");
        }

        @Override
        @NonNls
        protected String[] getShorthandProperties() {
            return new String[]{"outline-color", "outline-style", "outline-width"};
        }
    }

    private static class CueRule
    extends BackgroundRule {
        public CueRule() {
            super("cue");
        }

        @Override
        @NonNls
        protected String[] getShorthandProperties() {
            return new String[]{"cue-before", "cue-after"};
        }
    }

    private static class ListStyleRule
    extends BackgroundRule {
        public ListStyleRule() {
            super("list-style");
        }

        @Override
        @NonNls
        protected String[] getShorthandProperties() {
            return new String[]{"list-style-type", "list-style-position", "list-style-image"};
        }
    }

    private static class BackgroundRule
    extends ShorthandRule {
        private static final Logger LOG = Logger.getInstance((String)"com.intellij.psi.css.inspections.CssOptimizeSimilarPropertiesInspection#BackgroundRule");
        protected final Map<String, String> myPropertiesMap;
        protected boolean myImportant;

        public BackgroundRule() {
            super("background");
            this.myPropertiesMap = new com.intellij.util.containers.HashMap();
        }

        protected BackgroundRule(@NotNull @NonNls String shorthandName) {
            if (shorthandName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "shorthandName", "com/intellij/psi/css/inspections/CssOptimizeSimilarPropertiesInspection$BackgroundRule", "<init>"));
            }
            super(shorthandName);
            this.myPropertiesMap = new com.intellij.util.containers.HashMap();
        }

        @NonNls
        protected String[] getShorthandProperties() {
            return new String[]{"background-color", "background-image", "background-repeat", "background-attachment", "background-position"};
        }

        @Override
        public boolean isValid() {
            List<CssDeclaration> properties = this.getProperties();
            if (properties.size() < 2) {
                return false;
            }
            if (!this.fillPropertiesMap()) {
                return false;
            }
            int inheritCount = 0;
            for (String value : this.myPropertiesMap.values()) {
                if (!"inherit".equals(value)) continue;
                ++inheritCount;
            }
            return properties.size() > inheritCount + 1;
        }

        protected boolean fillPropertiesMap() {
            ArrayList<String> importantProperties = new ArrayList<String>();
            HashSet seenDeclarationNames = Sets.newHashSet();
            for (CssDeclaration property : this.getProperties()) {
                String propertyName = CssDescriptorsUtil.getCanonicalPropertyName((CssDeclaration)property);
                if (seenDeclarationNames.contains(propertyName)) {
                    return false;
                }
                seenDeclarationNames.add(propertyName);
                if (property.isShorthandProperty()) {
                    String[] names;
                    for (String name : names = property.expandShorthandProperty()) {
                        String[] values = property.getShorthandValue(name);
                        if (values == null) continue;
                        if (values.length == 1) {
                            if (!property.isImportant() && importantProperties.contains(name)) continue;
                            this.myPropertiesMap.put(name, values[0]);
                            if (!property.isImportant()) continue;
                            importantProperties.add(name);
                            continue;
                        }
                        StringBuilder sb = new StringBuilder();
                        for (String value : values) {
                            if ("inherit".equals(value.toLowerCase())) continue;
                            sb.append(value).append(' ');
                        }
                        if (!property.isImportant() && importantProperties.contains(name)) continue;
                        this.myPropertiesMap.put(name, sb.toString().trim());
                        if (!property.isImportant()) continue;
                        importantProperties.add(name);
                    }
                    continue;
                }
                CssTermList propertyValue = property.getValue();
                if (propertyValue == null) {
                    return false;
                }
                if (!property.isImportant() && importantProperties.contains(propertyName)) continue;
                this.myPropertiesMap.put(propertyName, propertyValue.getText());
                if (!property.isImportant()) continue;
                importantProperties.add(propertyName);
            }
            if (importantProperties.isEmpty()) {
                this.myImportant = false;
                return true;
            }
            if (importantProperties.size() == this.myPropertiesMap.size()) {
                this.myImportant = true;
                return true;
            }
            return false;
        }

        @Override
        public void registerProblem(@NotNull ProblemsHolder holder) {
            if (holder == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/psi/css/inspections/CssOptimizeSimilarPropertiesInspection$BackgroundRule", "registerProblem"));
            }
            for (CssDeclaration decl : this.getProperties()) {
                holder.registerProblem((PsiElement)decl, this.getName(), new LocalQuickFix[]{this});
            }
            this.getProperties().clear();
        }

        @Override
        protected void doApplyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/psi/css/inspections/CssOptimizeSimilarPropertiesInspection$BackgroundRule", "doApplyFix"));
            }
            if (descriptor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/psi/css/inspections/CssOptimizeSimilarPropertiesInspection$BackgroundRule", "doApplyFix"));
            }
            try {
                CssBlock block;
                com.intellij.util.containers.HashMap inherits = new com.intellij.util.containers.HashMap();
                StringBuilder sb = new StringBuilder();
                for (String name : this.getShorthandProperties()) {
                    String value = this.myPropertiesMap.get(name);
                    if (value == null) continue;
                    if ("inherit".equals(value.toLowerCase())) {
                        inherits.put(name, value);
                        continue;
                    }
                    sb.append(value).append(' ');
                }
                if (this.myImportant) {
                    sb.append("!important");
                }
                if ((block = (CssBlock)PsiTreeUtil.getParentOfType((PsiElement)descriptor.getPsiElement(), CssBlock.class)) == null) {
                    return;
                }
                List<CssDeclaration> properties = this.calcMyProperties(block);
                if (properties.isEmpty()) {
                    return;
                }
                CssDeclaration anchor = properties.get(properties.size() - 1);
                for (String inheritedProperty : inherits.keySet()) {
                    block.addDeclaration(inheritedProperty, (String)inherits.get(inheritedProperty), anchor);
                }
                block.addDeclaration(this.getShorthandName(), sb.toString().trim(), anchor);
                for (CssDeclaration property : properties) {
                    block.removeDeclaration(property);
                }
            }
            catch (IncorrectOperationException e) {
                LOG.error((Throwable)e);
            }
        }
    }

    private static abstract class ShorthandRule
    implements LocalQuickFix {
        private final List<CssDeclaration> myDeclarations;
        private final String myShorthandName;

        protected ShorthandRule(@NotNull @NonNls String shorthandName) {
            if (shorthandName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "shorthandName", "com/intellij/psi/css/inspections/CssOptimizeSimilarPropertiesInspection$ShorthandRule", "<init>"));
            }
            this.myDeclarations = new ArrayList<CssDeclaration>();
            this.myShorthandName = shorthandName;
        }

        public String getShorthandName() {
            return this.myShorthandName;
        }

        public void addDeclaration(@NotNull CssDeclaration declaration) {
            if (declaration == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declaration", "com/intellij/psi/css/inspections/CssOptimizeSimilarPropertiesInspection$ShorthandRule", "addDeclaration"));
            }
            this.myDeclarations.add(declaration);
        }

        @NotNull
        public String getName() {
            String string = CssBundle.message((String)"css.inspections.optimize.similar.properties.message", (Object[])new Object[]{this.myShorthandName});
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/inspections/CssOptimizeSimilarPropertiesInspection$ShorthandRule", "getName"));
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            String string = this.getName();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/inspections/CssOptimizeSimilarPropertiesInspection$ShorthandRule", "getFamilyName"));
            }
            return string;
        }

        protected List<CssDeclaration> getProperties() {
            return this.myDeclarations;
        }

        protected List<CssDeclaration> calcMyProperties(@NotNull CssBlock block) {
            if (block == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "block", "com/intellij/psi/css/inspections/CssOptimizeSimilarPropertiesInspection$ShorthandRule", "calcMyProperties"));
            }
            ArrayList<CssDeclaration> result = new ArrayList<CssDeclaration>();
            ShorthandRuleContainer container = new ShorthandRuleContainer();
            for (CssDeclaration decl : block.getDeclarations()) {
                ShorthandRule rule;
                if (decl.isHack() || (rule = container.getOrCreateRule(decl)) == null || rule.getClass() != this.getClass()) continue;
                result.add(decl);
            }
            return result;
        }

        protected static boolean prepareDocument(ProblemDescriptor descriptor) {
            PsiElement element = descriptor.getPsiElement();
            if (element == null) {
                return false;
            }
            PsiFile containingFile = element.getContainingFile();
            return FileModificationService.getInstance().prepareFileForWrite(containingFile);
        }

        public final void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/psi/css/inspections/CssOptimizeSimilarPropertiesInspection$ShorthandRule", "applyFix"));
            }
            if (descriptor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/psi/css/inspections/CssOptimizeSimilarPropertiesInspection$ShorthandRule", "applyFix"));
            }
            if (ShorthandRule.prepareDocument(descriptor)) {
                this.doApplyFix(project, descriptor);
            }
        }

        protected abstract void doApplyFix(@NotNull Project var1, @NotNull ProblemDescriptor var2);

        public abstract boolean isValid();

        public abstract void registerProblem(@NotNull ProblemsHolder var1);
    }

    private static class ShorthandRuleContainer {
        private static final Map<String, Class<? extends ShorthandRule>> ourName2Class = new com.intellij.util.containers.HashMap();
        private final Map<Class<? extends ShorthandRule>, ShorthandRule> myClass2Rule = new HashMap<Class<? extends ShorthandRule>, ShorthandRule>();

        private ShorthandRuleContainer() {
        }

        public static void register(@NotNull Class<? extends ShorthandRule> ruleClass, String ... properties) {
            if (ruleClass == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ruleClass", "com/intellij/psi/css/inspections/CssOptimizeSimilarPropertiesInspection$ShorthandRuleContainer", "register"));
            }
            if (properties == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "properties", "com/intellij/psi/css/inspections/CssOptimizeSimilarPropertiesInspection$ShorthandRuleContainer", "register"));
            }
            for (String propertyName : properties) {
                ourName2Class.put(propertyName, ruleClass);
            }
        }

        @Nullable
        public final ShorthandRule getOrCreateRule(@NotNull CssDeclaration decl) {
            if (decl == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "decl", "com/intellij/psi/css/inspections/CssOptimizeSimilarPropertiesInspection$ShorthandRuleContainer", "getOrCreateRule"));
            }
            String propertyName = CssDescriptorsUtil.getCanonicalPropertyName((CssDeclaration)decl);
            Class<? extends ShorthandRule> ruleClassName = ourName2Class.get(propertyName);
            if (ruleClassName != null) {
                ShorthandRule rule = this.myClass2Rule.get(ruleClassName);
                if (rule != null) {
                    return rule;
                }
                try {
                    rule = ruleClassName.newInstance();
                    this.myClass2Rule.put(ruleClassName, rule);
                    return rule;
                }
                catch (InstantiationException e) {
                    CssBaseInspection.LOG.error((Throwable)e);
                }
                catch (IllegalAccessException e) {
                    CssBaseInspection.LOG.error((Throwable)e);
                }
            }
            return null;
        }

        public Collection<ShorthandRule> getRules() {
            return this.myClass2Rule.values();
        }

        static {
            ShorthandRuleContainer.register(BackgroundRule.class, "background", "background-color", "background-image", "background-repeat", "background-attachment", "background-position");
            ShorthandRuleContainer.register(ListStyleRule.class, "list-style", "list-style-type", "list-style-position", "list-style-image");
            ShorthandRuleContainer.register(CueRule.class, "cue", "cue-before", "cue-after");
            ShorthandRuleContainer.register(OutlineRule.class, "outline", "outline-color", "outline-style", "outline-width");
            ShorthandRuleContainer.register(MarginRule.class, "margin", "margin-left", "margin-right", "margin-top", "margin-bottom");
            ShorthandRuleContainer.register(PaddingRule.class, "padding", "padding-left", "padding-right", "padding-top", "padding-bottom");
            ShorthandRuleContainer.register(BorderRule.class, "border", "border-width", "border-color", "border-style", "border-left", "border-right", "border-top", "border-bottom", "border-top-color", "border-top-style", "border-top-width", "border-right-color", "border-right-style", "border-right-width", "border-bottom-color", "border-bottom-style", "border-bottom-width", "border-left-color", "border-left-style", "border-left-width");
            ShorthandRuleContainer.register(BorderRadiusRule.class, "border-radius", "border-bottom-left-radius", "border-top-left-radius", "border-bottom-right-radius", "border-top-right-radius");
            ShorthandRuleContainer.register(MozillaBorderRadiusRule.class, "-moz-border-radius", "-moz-border-radius-bottomleft", "-moz-border-radius-topleft", "-moz-border-radius-bottomright", "-moz-border-radius-topright");
            ShorthandRuleContainer.register(SafariBorderRadiusRule.class, "-webkit-border-radius", "-webkit-border-bottom-left-radius", "-webkit-border-top-left-radius", "-webkit-border-bottom-right-radius", "-webkit-border-top-right-radius");
            ShorthandRuleContainer.register(BorderImageRule.class, "border-image", "border-top-image", "border-left-image", "border-bottom-image", "border-right-image");
            ShorthandRuleContainer.register(MozillaBorderImageRule.class, "-moz-border-image", "-moz-border-top-image", "-moz-border-left-image", "-moz-border-bottom-image", "-moz-border-right-image");
            ShorthandRuleContainer.register(SafariBorderImageRule.class, "-webkit-border-image", "-webkit-border-top-image", "-webkit-border-left-image", "-webkit-border-bottom-image", "-webkit-border-right-image");
            ShorthandRuleContainer.register(BorderCornerImageRule.class, "border-corner-image", "border-bottom-left-image", "border-top-left-image", "border-bottom-right-image", "border-top-right-image");
        }
    }
}

