/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.inspections;

import com.intellij.codeInspection.InspectionProfile;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.css.CssBundle;
import com.intellij.psi.css.inspections.CssUnknownPropertyInspectionBase;
import org.jetbrains.annotations.NotNull;

public class CssUnknownPropertyIntentionAction
implements LocalQuickFix {
    private final String myPropertyName;

    public CssUnknownPropertyIntentionAction(@NotNull String propertyName) {
        if (propertyName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertyName", "com/intellij/psi/css/inspections/CssUnknownPropertyIntentionAction", "<init>"));
        }
        this.myPropertyName = propertyName;
    }

    @NotNull
    public String getName() {
        String string = CssBundle.message((String)"css.unknown.property.fix.name", (Object[])new Object[]{this.myPropertyName});
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/inspections/CssUnknownPropertyIntentionAction", "getName"));
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = this.getName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/inspections/CssUnknownPropertyIntentionAction", "getFamilyName"));
        }
        return string;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/psi/css/inspections/CssUnknownPropertyIntentionAction", "applyFix"));
        }
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/psi/css/inspections/CssUnknownPropertyIntentionAction", "applyFix"));
        }
        PsiElement element = descriptor.getPsiElement();
        InspectionProfile profile = InspectionProjectProfileManager.getInstance((Project)project).getCurrentProfile();
        profile.modifyToolSettings(CssUnknownPropertyInspectionBase.SHORT_NAME_KEY, element, tool -> tool.addCustomPropertyName(this.myPropertyName));
    }
}

