/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.inspections.fixes;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.css.CssBundle;
import org.jetbrains.annotations.NotNull;

public class RemoveElementAction
implements LocalQuickFix {
    private final String myName;

    public RemoveElementAction(String element) {
        this.myName = element;
    }

    @NotNull
    public String getName() {
        String string = CssBundle.message((String)"css.remove.element", (Object[])new Object[]{this.myName});
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/inspections/fixes/RemoveElementAction", "getName"));
        }
        return string;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/psi/css/inspections/fixes/RemoveElementAction", "applyFix"));
        }
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/psi/css/inspections/fixes/RemoveElementAction", "applyFix"));
        }
        final PsiElement element = descriptor.getStartElement();
        if (element == null) {
            return;
        }
        new WriteCommandAction(element.getProject(), new PsiFile[]{element.getContainingFile()}){

            protected void run(@NotNull Result result) throws Throwable {
                if (result == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/psi/css/inspections/fixes/RemoveElementAction$1", "run"));
                }
                assert (element.isValid());
                element.delete();
            }
        }.execute();
    }

    @NotNull
    public String getFamilyName() {
        String string = this.getName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/inspections/fixes/RemoveElementAction", "getFamilyName"));
        }
        return string;
    }
}

