/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.inspections.invalid;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.htmlInspections.AddCustomHtmlElementIntentionAction;
import com.intellij.codeInspection.htmlInspections.HtmlUnknownTagInspectionBase;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.css.CssBundle;
import com.intellij.psi.css.CssElementVisitor;
import com.intellij.psi.css.CssSelector;
import com.intellij.psi.css.CssSimpleSelector;
import com.intellij.psi.css.impl.util.CssUtil;
import com.intellij.psi.css.impl.util.table.CssDescriptorsUtil;
import com.intellij.psi.css.inspections.CssBaseInspection;
import com.intellij.psi.css.inspections.CssReplaceHtmlTagReferenceWithClassIntentionAction;
import com.intellij.psi.css.inspections.CssReplaceHtmlTagReferenceWithIdIntentionAction;
import com.intellij.xml.XmlBundle;
import java.util.ArrayList;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class CssInvalidHtmlTagReferenceInspection
extends CssBaseInspection {
    @Nls
    @NotNull
    public String getDisplayName() {
        String string = CssBundle.message((String)"invalid.css.selector", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/inspections/invalid/CssInvalidHtmlTagReferenceInspection", "getDisplayName"));
        }
        return string;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/psi/css/inspections/invalid/CssInvalidHtmlTagReferenceInspection", "buildVisitor"));
        }
        UnknownTagVisitor unknownTagVisitor = new UnknownTagVisitor(holder);
        if (unknownTagVisitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/inspections/invalid/CssInvalidHtmlTagReferenceInspection", "buildVisitor"));
        }
        return unknownTagVisitor;
    }

    private static class UnknownTagVisitor
    extends CssElementVisitor {
        private final ProblemsHolder myHolder;

        public UnknownTagVisitor(ProblemsHolder holder) {
            this.myHolder = holder;
        }

        public void visitCssSelector(CssSelector selector) {
        }

        public void visitCssSimpleSelector(CssSimpleSelector selector) {
            String tagName = selector.getElementName();
            PsiElement element = selector.getNameIdentifier();
            if (element == null || CssUtil.containsStrangeCharacter(tagName) || tagName.isEmpty()) {
                return;
            }
            if (!CssDescriptorsUtil.isPossibleSelector((String)tagName, (PsiElement)selector)) {
                String message = CssBundle.message((String)"css.selector.matches.unknown.element", (Object[])new Object[]{tagName});
                ArrayList<Object> quickFixes = new ArrayList<Object>();
                quickFixes.addAll(CssDescriptorsUtil.getQuickFixesForUnknownSimpleSelector((String)tagName, (PsiElement)selector, (boolean)this.myHolder.isOnTheFly()));
                quickFixes.add(new AddCustomHtmlElementIntentionAction(HtmlUnknownTagInspectionBase.TAG_KEY, tagName, XmlBundle.message((String)"add.custom.html.tag", (Object[])new Object[]{tagName})));
                quickFixes.add(new CssReplaceHtmlTagReferenceWithIdIntentionAction(tagName));
                quickFixes.add(new CssReplaceHtmlTagReferenceWithClassIntentionAction(tagName));
                this.myHolder.registerProblem(element, message, ProblemHighlightType.ERROR, quickFixes.toArray(new LocalQuickFix[quickFixes.size()]));
            }
        }
    }
}

