/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.inspections.invalid;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.LocalQuickFixBase;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.css.util.CssPsiUtil;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.css.CssBundle;
import com.intellij.psi.css.CssElementFactory;
import com.intellij.psi.css.CssElementVisitor;
import com.intellij.psi.css.CssImport;
import com.intellij.psi.css.CssImportList;
import com.intellij.psi.css.CssStylesheet;
import com.intellij.psi.css.impl.CssElementTypes;
import com.intellij.psi.css.inspections.CssBaseInspection;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class CssInvalidImportInspection
extends CssBaseInspection {
    private static final LocalQuickFix REMOVE_MISPLACED_IMPORT = new LocalQuickFixBase(CssBundle.message((String)"css.invalid.import.remove.fix.name", (Object[])new Object[0])){

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/psi/css/inspections/invalid/CssInvalidImportInspection$1", "applyFix"));
            }
            if (descriptor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/psi/css/inspections/invalid/CssInvalidImportInspection$1", "applyFix"));
            }
            final PsiElement element = descriptor.getPsiElement();
            if (element instanceof CssImport) {
                new WriteCommandAction(project, new PsiFile[]{element.getContainingFile()}){

                    protected void run(@NotNull Result result) throws Throwable {
                        if (result == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/psi/css/inspections/invalid/CssInvalidImportInspection$1$1", "run"));
                        }
                        element.delete();
                    }
                }.execute();
            }
        }
    };
    private static final LocalQuickFix MOVE_IMPORT_TO_IMPORT_LIST_FIX = new LocalQuickFixBase(CssBundle.message((String)"css.invalid.import.fix.name", (Object[])new Object[0])){

        public void applyFix(final @NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/psi/css/inspections/invalid/CssInvalidImportInspection$2", "applyFix"));
            }
            if (descriptor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/psi/css/inspections/invalid/CssInvalidImportInspection$2", "applyFix"));
            }
            final PsiElement element = descriptor.getPsiElement();
            if (!(element instanceof CssImport)) {
                return;
            }
            final CssStylesheet stylesheet = (CssStylesheet)PsiTreeUtil.getParentOfType((PsiElement)element, CssStylesheet.class);
            if (stylesheet != null) {
                new WriteCommandAction(project, new PsiFile[]{element.getContainingFile()}){

                    protected void run(@NotNull Result result) throws Throwable {
                        if (result == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/psi/css/inspections/invalid/CssInvalidImportInspection$2$1", "run"));
                        }
                        CssImport lastImport = (CssImport)ContainerUtil.getLastItem((List)stylesheet.getImports());
                        if (lastImport != null) {
                            PsiElement importList = lastImport.getParent();
                            if (importList != null) {
                                importList.addAfter(element, (PsiElement)lastImport);
                            }
                        } else {
                            CssElementFactory elementFactory = CssElementFactory.getInstance((Project)project);
                            CssImportList importList = elementFactory.createImportList(CssPsiUtil.getStylesheetLanguage((PsiElement)element), new String[]{element.getText()});
                            stylesheet.addBefore((PsiElement)importList, (PsiElement)stylesheet.getRulesetList());
                        }
                        element.delete();
                    }
                }.execute();
            }
        }
    };

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/psi/css/inspections/invalid/CssInvalidImportInspection", "buildVisitor"));
        }
        CssElementVisitor cssElementVisitor = new CssElementVisitor(){

            public void visitCssImport(CssImport cssImport) {
                if (!CssInvalidImportInspection.isSuitableElement((PsiElement)cssImport)) {
                    return;
                }
                PsiElement parent = cssImport.getParent();
                ASTNode node = parent.getNode();
                if (node != null && node.getElementType() != CssElementTypes.CSS_IMPORT_LIST) {
                    holder.registerProblem((PsiElement)cssImport, CssBundle.message((String)"css.inspections.invalid.import", (Object[])new Object[0]), new LocalQuickFix[]{MOVE_IMPORT_TO_IMPORT_LIST_FIX, REMOVE_MISPLACED_IMPORT});
                }
            }
        };
        if (cssElementVisitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/inspections/invalid/CssInvalidImportInspection", "buildVisitor"));
        }
        return cssElementVisitor;
    }
}

