/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.inspections.invalid;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiReference;
import com.intellij.psi.css.CssDeclaration;
import com.intellij.psi.css.CssElementVisitor;
import com.intellij.psi.css.CssTerm;
import com.intellij.psi.css.CssTermList;
import com.intellij.psi.css.impl.CssTermTypes;
import com.intellij.psi.css.inspections.CssBaseInspection;
import com.intellij.psi.css.resolve.CssComposesClassReference;
import com.intellij.psi.css.resolve.CssResolveManager;
import com.intellij.util.ArrayUtil;
import org.jetbrains.annotations.NotNull;

public class CssUnresolvedClassInspection
extends CssBaseInspection {
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/psi/css/inspections/invalid/CssUnresolvedClassInspection", "buildVisitor"));
        }
        CssElementVisitor cssElementVisitor = new CssElementVisitor(){

            public void visitCssDeclaration(CssDeclaration declaration) {
                CssTermList value = declaration.getValue();
                if (value == null || !"composes".equals(declaration.getPropertyName())) {
                    return;
                }
                Object[] terms = value.getTerms();
                CssTerm lastTerm = (CssTerm)ArrayUtil.getLastElement((Object[])terms);
                if (lastTerm == null) {
                    return;
                }
                if (lastTerm.getTermType() == CssTermTypes.STRING && ArrayUtil.isEmpty((Object[])CssResolveManager.getInstance().resolveFiles(lastTerm.getFirstChild(), lastTerm.getContainingFile()))) {
                    return;
                }
                for (Object term : terms) {
                    PsiElement child = term.getFirstChild();
                    for (PsiReference reference : child.getReferences()) {
                        if (!(reference instanceof CssComposesClassReference) || !ArrayUtil.isEmpty((Object[])((CssComposesClassReference)reference).multiResolve(false))) continue;
                        holder.registerProblem(child, ((CssComposesClassReference)reference).getUnresolvedMessagePattern(), new LocalQuickFix[0]);
                    }
                }
            }
        };
        if (cssElementVisitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/inspections/invalid/CssUnresolvedClassInspection", "buildVisitor"));
        }
        return cssElementVisitor;
    }
}

