/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.resolve;

import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Conditions;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.css.CssClass;
import com.intellij.psi.css.CssDeclaration;
import com.intellij.psi.css.CssRuleset;
import com.intellij.psi.css.CssTerm;
import com.intellij.psi.css.impl.CssTermTypes;
import com.intellij.psi.css.impl.stubs.index.CssIndexUtil;
import com.intellij.psi.css.impl.util.CssUtil;
import com.intellij.psi.css.resolve.CssClassOrIdReference;
import com.intellij.psi.css.resolve.CssResolveManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CssComposesClassReference
extends CssClassOrIdReference {
    public CssComposesClassReference(PsiElement element) {
        super(element, null);
    }

    @Override
    public boolean isSoft() {
        return false;
    }

    @Override
    protected boolean isId() {
        return false;
    }

    @Override
    protected GlobalSearchScope getSearchScope() {
        CssTerm lastTerm = CssComposesClassReference.getDeclarationLastTerm(CssUtil.getDeclaration(this.myElement));
        if (lastTerm == null) {
            return GlobalSearchScope.EMPTY_SCOPE;
        }
        PsiFile containingFile = this.myElement.getContainingFile().getOriginalFile();
        if (lastTerm.getTermType() == CssTermTypes.STRING) {
            PsiFile[] psiFiles = CssResolveManager.getInstance().resolveFiles(lastTerm.getFirstChild(), containingFile);
            return GlobalSearchScope.filesScope((Project)this.myElement.getProject(), (Collection)Arrays.stream(psiFiles).map(PsiFile::getVirtualFile).collect(Collectors.toList()));
        }
        return GlobalSearchScope.fileScope((PsiFile)containingFile);
    }

    @Override
    @NotNull
    public Object[] getVariants() {
        Project project = this.myElement.getProject();
        GlobalSearchScope scope = this.getSearchScope();
        ArrayList result = ContainerUtil.newArrayList();
        Collection<String> notAllowed = this.getNotAllowedCompletionClassNames();
        CssIndexUtil.processAllClassNamesInScope(project, scope, (Processor<String>)((Processor)name -> {
            if (!notAllowed.contains(name)) {
                result.add(LookupElementBuilder.create((String)name).withIcon(AllIcons.Xml.Css_class));
            }
            return true;
        }));
        Object[] objectArray = ArrayUtil.toObjectArray((Collection)result);
        if (objectArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/resolve/CssComposesClassReference", "getVariants"));
        }
        return objectArray;
    }

    @NotNull
    private Collection<String> getNotAllowedCompletionClassNames() {
        boolean isLocal;
        CssTerm lastTerm = CssComposesClassReference.getDeclarationLastTerm(CssUtil.getDeclaration(this.myElement));
        if (lastTerm == null) {
            Set<String> set = Collections.emptySet();
            if (set == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/resolve/CssComposesClassReference", "getNotAllowedCompletionClassNames"));
            }
            return set;
        }
        CssRuleset ruleset = (CssRuleset)PsiTreeUtil.getParentOfType((PsiElement)this.myElement, CssRuleset.class);
        if (ruleset == null) {
            Set<String> set = Collections.emptySet();
            if (set == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/resolve/CssComposesClassReference", "getNotAllowedCompletionClassNames"));
            }
            return set;
        }
        HashSet notAllowed = ContainerUtil.newHashSet();
        boolean bl = isLocal = lastTerm.getTermType() != CssTermTypes.STRING;
        if (isLocal) {
            List elements = ((SyntaxTraverser)SyntaxTraverser.psiTraverser((PsiElement)ruleset.getSelectorList()).filter(Conditions.instanceOf(CssClass.class))).toList();
            notAllowed.addAll(elements.stream().map(e -> ((CssClass)e).getName()).collect(Collectors.toList()));
        }
        if (ruleset.getBlock() != null) {
            List classesFromSameFile = Arrays.stream(ruleset.getBlock().getDeclarations()).filter(d -> CssComposesClassReference.isComposesDeclarationWithSamePath(d, isLocal ? null : lastTerm.getText())).flatMap(d -> CssComposesClassReference.getClassNames(d, isLocal)).collect(Collectors.toList());
            notAllowed.addAll(classesFromSameFile);
        }
        HashSet hashSet = notAllowed;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/resolve/CssComposesClassReference", "getNotAllowedCompletionClassNames"));
        }
        return hashSet;
    }

    private static Stream<String> getClassNames(@NotNull CssDeclaration declaration, boolean isLocal) {
        if (declaration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declaration", "com/intellij/psi/css/resolve/CssComposesClassReference", "getClassNames"));
        }
        if (declaration.getValue() == null) {
            return Stream.empty();
        }
        CssTerm[] terms = declaration.getValue().getTerms();
        ArrayList classNames = ContainerUtil.newArrayList();
        int lastIndex = terms.length - (isLocal ? 0 : 2);
        for (int i = 0; i < lastIndex; ++i) {
            classNames.add(terms[i].getText());
        }
        return classNames.stream();
    }

    private static boolean isComposesDeclarationWithSamePath(@NotNull CssDeclaration declaration, @Nullable String path) {
        if (declaration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declaration", "com/intellij/psi/css/resolve/CssComposesClassReference", "isComposesDeclarationWithSamePath"));
        }
        if (!"composes".equals(declaration.getPropertyName())) {
            return false;
        }
        CssTerm lastTerm = CssComposesClassReference.getDeclarationLastTerm(declaration);
        if (lastTerm == null) {
            return false;
        }
        if (path == null && lastTerm.getTermType() != CssTermTypes.STRING) {
            return true;
        }
        return path != null && path.equals(lastTerm.getText());
    }

    @Nullable
    private static CssTerm getDeclarationLastTerm(@Nullable CssDeclaration declaration) {
        if (declaration == null || declaration.getValue() == null) {
            return null;
        }
        return (CssTerm)ArrayUtil.getLastElement((Object[])declaration.getValue().getTerms());
    }
}

