/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.remotesdk;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.PathEnvironmentVariableUtil;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.execution.process.ScriptRunnerUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.remote.RemoteSdkCredentials;
import com.intellij.util.PlatformUtils;
import java.io.File;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class RSyncUtil {
    private static final Logger LOG = Logger.getInstance(RSyncUtil.class);

    private static boolean checkRsyncInstalled() {
        return RSyncUtil.checkCommandExists("rsync", "--version");
    }

    private static boolean checkSshpassInstalled() {
        return RSyncUtil.checkCommandExists("sshpass", "-V");
    }

    @NotNull
    public static List<String> externalToolSuggestion(boolean isPasswordProvided) {
        if (!Registry.is((String)"ide.remote.interpreters.use.rsync")) {
            List<String> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/remotesdk/RSyncUtil", "externalToolSuggestion"));
            }
            return list;
        }
        if (!PlatformUtils.isRubyMine()) {
            List<String> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/remotesdk/RSyncUtil", "externalToolSuggestion"));
            }
            return list;
        }
        ArrayList<String> commandsToInstall = new ArrayList<String>();
        if (!RSyncUtil.checkRsyncInstalled()) {
            commandsToInstall.add("rsync");
        }
        if (isPasswordProvided && !RSyncUtil.checkSshpassInstalled()) {
            commandsToInstall.add("sshpass");
        }
        ArrayList<String> arrayList = commandsToInstall;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/remotesdk/RSyncUtil", "externalToolSuggestion"));
        }
        return arrayList;
    }

    public static boolean canUseRSync(RemoteSdkCredentials credentials) {
        if (!Registry.is((String)"ide.remote.interpreters.use.rsync")) {
            return false;
        }
        return RSyncUtil.checkRsyncInstalled() && (credentials.getPassword() == null || RSyncUtil.checkSshpassInstalled());
    }

    private static boolean checkCommandExists(String command, String versionParameter) {
        try {
            File executablePath = PathEnvironmentVariableUtil.findInPath((String)command);
            if (executablePath == null) {
                return false;
            }
            GeneralCommandLine commandLine = new GeneralCommandLine(new String[]{executablePath.getAbsolutePath(), versionParameter});
            String commandOutput = ScriptRunnerUtil.getProcessOutput((GeneralCommandLine)commandLine);
            String firstLine = commandOutput.split("\n")[0];
            if (firstLine.matches(".*command not found.*")) {
                LOG.info(command + " not found");
                return false;
            }
            LOG.info(command + " version: " + firstLine);
        }
        catch (ExecutionException e) {
            LOG.error("Error during execution of command" + command);
            return false;
        }
        return true;
    }

    public static void uploadWithRSync(String localPath, String remotePath, RemoteSdkCredentials credentials, @NotNull ProgressIndicator progressIndicator) {
        if (progressIndicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "progressIndicator", "com/jetbrains/plugins/remotesdk/RSyncUtil", "uploadWithRSync"));
        }
        Pair<String, String[]> commandAndParameters = RSyncUtil.getRSyncCommandAndParameters(localPath, remotePath, credentials, true);
        RSyncUtil.runAndListenBashCommand((String)commandAndParameters.first, (String[])commandAndParameters.second, progressIndicator);
    }

    public static void downloadWithRSync(String localPath, String remotePath, RemoteSdkCredentials credentials, @NotNull ProgressIndicator progressIndicator) {
        if (progressIndicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "progressIndicator", "com/jetbrains/plugins/remotesdk/RSyncUtil", "downloadWithRSync"));
        }
        if (!remotePath.endsWith(File.separator)) {
            remotePath = remotePath + File.separator;
        }
        FileUtil.createDirectory((File)new File(localPath));
        Pair<String, String[]> commandAndParameters = RSyncUtil.getRSyncCommandAndParameters(localPath, remotePath, credentials, false);
        RSyncUtil.runAndListenBashCommand((String)commandAndParameters.first, (String[])commandAndParameters.second, progressIndicator);
    }

    private static void runAndListenBashCommand(@NotNull String command, String[] parameters, final @NotNull ProgressIndicator progressIndicator) {
        OSProcessHandler osProcessHandler;
        if (command == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "command", "com/jetbrains/plugins/remotesdk/RSyncUtil", "runAndListenBashCommand"));
        }
        if (progressIndicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "progressIndicator", "com/jetbrains/plugins/remotesdk/RSyncUtil", "runAndListenBashCommand"));
        }
        File executablePath = PathEnvironmentVariableUtil.findInPath((String)command);
        if (executablePath == null) {
            return;
        }
        try {
            osProcessHandler = ScriptRunnerUtil.execute((String)executablePath.getPath(), null, null, (String[])parameters, (Charset)CharsetToolkit.getDefaultSystemCharset());
        }
        catch (ExecutionException e) {
            LOG.error((Throwable)e);
            return;
        }
        osProcessHandler.addProcessListener((ProcessListener)new ProcessAdapter(){

            public void onTextAvailable(ProcessEvent event, Key outputType) {
                if (outputType == ProcessOutputTypes.STDOUT) {
                    if (event.getText().contains(File.separator)) {
                        progressIndicator.setText(event.getText());
                    }
                } else if (outputType == ProcessOutputTypes.STDERR) {
                    LOG.info(event.getText());
                }
            }
        });
        osProcessHandler.startNotify();
        osProcessHandler.waitFor();
    }

    private static Pair<String, String[]> getRSyncCommandAndParameters(String localPath, String remotePath, RemoteSdkCredentials credentials, boolean isServerSideModification) {
        String[] parameters;
        String command;
        String to;
        String from;
        String fullRemotePath = String.format("%s@%s:%s", credentials.getUserName(), credentials.getHost(), remotePath);
        if (isServerSideModification) {
            from = localPath;
            to = fullRemotePath;
        } else {
            from = fullRemotePath;
            to = localPath;
        }
        if (credentials.getPassword() != null) {
            command = "sshpass";
            parameters = new String[]{"-p", credentials.getPassword(), "rsync", "-zarv", from, to};
        } else {
            command = "rsync";
            parameters = new String[]{"-zarv", from, to};
        }
        return Pair.create((Object)command, (Object)parameters);
    }
}

