/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.quickFix;

import com.intellij.codeInsight.daemon.LightDaemonAnalyzerTestCase;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.quickFix.QuickFixTestCase;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.impl.ShowIntentionActionsHandler;
import com.intellij.lang.Commenter;
import com.intellij.lang.LanguageCommenters;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.psi.PsiFile;
import com.intellij.rt.execution.junit.FileComparisonFailure;
import com.intellij.testFramework.LightPlatformTestCase;
import com.intellij.testFramework.fixtures.impl.CodeInsightTestFixtureImpl;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ui.UIUtil;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.intellij.lang.annotations.RegExp;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public abstract class LightQuickFixTestCase
extends LightDaemonAnalyzerTestCase {
    @NonNls
    protected static final String BEFORE_PREFIX = "before";
    @NonNls
    protected static final String AFTER_PREFIX = "after";
    private static QuickFixTestCase myWrapper;

    protected boolean shouldBeAvailableAfterExecution() {
        return false;
    }

    @NotNull
    protected Pair<String, Boolean> parseActionHintImpl(@NotNull PsiFile file, @NotNull String contents) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/daemon/quickFix/LightQuickFixTestCase", "parseActionHintImpl"));
        }
        if (contents == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contents", "com/intellij/codeInsight/daemon/quickFix/LightQuickFixTestCase", "parseActionHintImpl"));
        }
        Pair<String, Boolean> pair = LightQuickFixTestCase.parseActionHint(file, contents);
        if (pair == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/quickFix/LightQuickFixTestCase", "parseActionHintImpl"));
        }
        return pair;
    }

    private static void doTestFor(String testName, QuickFixTestCase quickFixTestCase) {
        String relativePath = (String)ObjectUtils.notNull((Object)quickFixTestCase.getBasePath(), (Object)"") + "/" + BEFORE_PREFIX + testName;
        String testFullPath = quickFixTestCase.getTestDataPath().replace(File.separatorChar, '/') + relativePath;
        File testFile = new File(testFullPath);
        CommandProcessor.getInstance().executeCommand(quickFixTestCase.getProject(), () -> {
            try {
                String contents = StringUtil.convertLineSeparators((String)FileUtil.loadFile((File)testFile, (Charset)CharsetToolkit.UTF8_CHARSET));
                quickFixTestCase.configureFromFileText(testFile.getName(), contents);
                quickFixTestCase.bringRealEditorBack();
                Pair<String, Boolean> pair = quickFixTestCase.parseActionHintImpl(quickFixTestCase.getFile(), contents);
                String text = (String)pair.getFirst();
                boolean actionShouldBeAvailable = (Boolean)pair.getSecond();
                quickFixTestCase.beforeActionStarted(testName, contents);
                try {
                    myWrapper = quickFixTestCase;
                    quickFixTestCase.doAction(text, actionShouldBeAvailable, testFullPath, testName);
                }
                finally {
                    myWrapper = null;
                    quickFixTestCase.afterActionCompleted(testName, contents);
                }
            }
            catch (FileComparisonFailure e) {
                throw e;
            }
            catch (Throwable e) {
                e.printStackTrace();
                LightQuickFixTestCase.fail((String)testName);
            }
        }, "", "");
    }

    protected void afterActionCompleted(String testName, String contents) {
    }

    protected void beforeActionStarted(String testName, String contents) {
    }

    @NotNull
    public static Pair<String, Boolean> parseActionHint(@NotNull PsiFile file, @NotNull String contents) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/daemon/quickFix/LightQuickFixTestCase", "parseActionHint"));
        }
        if (contents == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contents", "com/intellij/codeInsight/daemon/quickFix/LightQuickFixTestCase", "parseActionHint"));
        }
        Pair<String, Boolean> pair = LightQuickFixTestCase.parseActionHint(file, contents, " \"(.*)\" \"(true|false)\".*");
        if (pair == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/quickFix/LightQuickFixTestCase", "parseActionHint"));
        }
        return pair;
    }

    @NotNull
    public static Pair<String, Boolean> parseActionHint(@NotNull PsiFile file, @NotNull String contents, @NotNull @NonNls @RegExp String actionPattern) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/daemon/quickFix/LightQuickFixTestCase", "parseActionHint"));
        }
        if (contents == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contents", "com/intellij/codeInsight/daemon/quickFix/LightQuickFixTestCase", "parseActionHint"));
        }
        if (actionPattern == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "actionPattern", "com/intellij/codeInsight/daemon/quickFix/LightQuickFixTestCase", "parseActionHint"));
        }
        PsiFile hostFile = InjectedLanguageManager.getInstance(file.getProject()).getTopLevelFile(file);
        Commenter commenter = (Commenter)LanguageCommenters.INSTANCE.forLanguage(hostFile.getLanguage());
        String comment = commenter.getLineCommentPrefix();
        if (comment == null) {
            comment = commenter.getBlockCommentPrefix();
        }
        assert (comment != null) : commenter;
        Pattern pattern = Pattern.compile("^" + comment.replace("*", "\\*") + actionPattern, 32);
        Matcher matcher = pattern.matcher(contents);
        LightQuickFixTestCase.assertTrue((String)("No comment found in " + file.getVirtualFile()), (boolean)matcher.matches());
        String text = matcher.group(1);
        Boolean actionShouldBeAvailable = Boolean.valueOf(matcher.group(2));
        Pair pair = Pair.create((Object)text, (Object)actionShouldBeAvailable);
        if (pair == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/quickFix/LightQuickFixTestCase", "parseActionHint"));
        }
        return pair;
    }

    public static void doAction(@NotNull String text, boolean actionShouldBeAvailable, String testFullPath, String testName, QuickFixTestCase quickFix) throws Exception {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/codeInsight/daemon/quickFix/LightQuickFixTestCase", "doAction"));
        }
        IntentionAction action = quickFix.findActionWithText(text);
        if (action == null) {
            if (actionShouldBeAvailable) {
                List<IntentionAction> actions = quickFix.getAvailableActions();
                ArrayList<String> texts = new ArrayList<String>();
                for (IntentionAction intentionAction : actions) {
                    texts.add(intentionAction.getText());
                }
                List<HighlightInfo> infos = quickFix.doHighlighting();
                LightQuickFixTestCase.fail((String)("Action with text '" + text + "' is not available in test " + testFullPath + "\nAvailable actions (" + texts.size() + "): " + texts + "\n" + actions + "\nInfos:" + infos));
            }
        } else {
            IntentionAction afterAction;
            if (!actionShouldBeAvailable) {
                LightQuickFixTestCase.fail((String)("Action '" + text + "' is available (but must not) in test " + testFullPath));
            }
            quickFix.invoke(action);
            UIUtil.dispatchAllInvocationEvents();
            UIUtil.dispatchAllInvocationEvents();
            if (!quickFix.shouldBeAvailableAfterExecution() && (afterAction = quickFix.findActionWithText(text)) != null) {
                LightQuickFixTestCase.fail((String)("Action '" + text + "' is still available after its invocation in test " + testFullPath));
            }
            String expectedFilePath = (String)ObjectUtils.notNull((Object)quickFix.getBasePath(), (Object)"") + "/" + AFTER_PREFIX + testName;
            quickFix.checkResultByFile("In file :" + expectedFilePath, expectedFilePath, false);
        }
    }

    protected void doAction(@NotNull String text, boolean actionShouldBeAvailable, String testFullPath, String testName) throws Exception {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/codeInsight/daemon/quickFix/LightQuickFixTestCase", "doAction"));
        }
        LightQuickFixTestCase.doAction(text, actionShouldBeAvailable, testFullPath, testName, myWrapper);
    }

    protected void doAction(@NotNull String actionName) {
        if (actionName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "actionName", "com/intellij/codeInsight/daemon/quickFix/LightQuickFixTestCase", "doAction"));
        }
        List<IntentionAction> available = this.getAvailableActions();
        IntentionAction action = LightQuickFixTestCase.findActionWithText(available, actionName);
        LightQuickFixTestCase.assertNotNull((String)("Action '" + actionName + "' not found among " + available), (Object)action);
        LightQuickFixTestCase.invoke(action);
    }

    protected static void invoke(@NotNull IntentionAction action) throws IncorrectOperationException {
        if (action == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "action", "com/intellij/codeInsight/daemon/quickFix/LightQuickFixTestCase", "invoke"));
        }
        ShowIntentionActionsHandler.chooseActionAndInvoke((PsiFile)LightQuickFixTestCase.getFile(), (Editor)LightQuickFixTestCase.getEditor(), (IntentionAction)action, (String)action.getText());
        UIUtil.dispatchAllInvocationEvents();
    }

    protected IntentionAction findActionWithText(@NotNull String text) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/codeInsight/daemon/quickFix/LightQuickFixTestCase", "findActionWithText"));
        }
        return LightQuickFixTestCase.findActionWithText(this.getAvailableActions(), text);
    }

    public static IntentionAction findActionWithText(@NotNull List<IntentionAction> actions, @NotNull String text) {
        if (actions == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "actions", "com/intellij/codeInsight/daemon/quickFix/LightQuickFixTestCase", "findActionWithText"));
        }
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/codeInsight/daemon/quickFix/LightQuickFixTestCase", "findActionWithText"));
        }
        for (IntentionAction action : actions) {
            if (!text.equals(action.getText())) continue;
            return action;
        }
        return null;
    }

    protected void doAllTests() {
        LightQuickFixTestCase.doAllTests(this.createWrapper());
    }

    public static void doAllTests(QuickFixTestCase testCase) {
        File[] files;
        for (File file : files = LightQuickFixTestCase.getBeforeTestFiles(testCase)) {
            String testName = file.getName().substring(BEFORE_PREFIX.length());
            LightQuickFixTestCase.doTestFor(testName, testCase);
        }
    }

    @NotNull
    public static File[] getBeforeTestFiles(@NotNull QuickFixTestCase testCase) {
        if (testCase == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "testCase", "com/intellij/codeInsight/daemon/quickFix/LightQuickFixTestCase", "getBeforeTestFiles"));
        }
        LightQuickFixTestCase.assertNotNull((String)"getBasePath() should not return null!", (Object)testCase.getBasePath());
        String testDirPath = testCase.getTestDataPath().replace(File.separatorChar, '/') + testCase.getBasePath();
        File testDir = new File(testDirPath);
        File[] files = testDir.listFiles((dir, name) -> name.startsWith(BEFORE_PREFIX));
        if (files == null || files.length == 0) {
            LightQuickFixTestCase.fail((String)("Test files not found in " + testDirPath));
        }
        if (files == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/quickFix/LightQuickFixTestCase", "getBeforeTestFiles"));
        }
        return files;
    }

    protected void doSingleTest(String fileSuffix) {
        LightQuickFixTestCase.doTestFor(fileSuffix, this.createWrapper());
    }

    protected void doSingleTest(String fileSuffix, String testDataPath) {
        LightQuickFixTestCase.doTestFor(fileSuffix, this.createWrapper(testDataPath));
    }

    protected QuickFixTestCase createWrapper() {
        return this.createWrapper(null);
    }

    protected QuickFixTestCase createWrapper(final String testDataPath) {
        return new QuickFixTestCase(){
            public String myTestDataPath;
            {
                this.myTestDataPath = testDataPath;
            }

            @Override
            public String getBasePath() {
                return LightQuickFixTestCase.this.getBasePath();
            }

            @Override
            public String getTestDataPath() {
                if (this.myTestDataPath == null) {
                    this.myTestDataPath = LightQuickFixTestCase.this.getTestDataPath();
                }
                return this.myTestDataPath;
            }

            @Override
            @NotNull
            public Pair<String, Boolean> parseActionHintImpl(@NotNull PsiFile file, @NotNull String contents) {
                if (file == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/daemon/quickFix/LightQuickFixTestCase$1", "parseActionHintImpl"));
                }
                if (contents == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contents", "com/intellij/codeInsight/daemon/quickFix/LightQuickFixTestCase$1", "parseActionHintImpl"));
                }
                Pair<String, Boolean> pair = LightQuickFixTestCase.this.parseActionHintImpl(file, contents);
                if (pair == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/quickFix/LightQuickFixTestCase$1", "parseActionHintImpl"));
                }
                return pair;
            }

            @Override
            public void beforeActionStarted(String testName, String contents) {
                LightQuickFixTestCase.this.beforeActionStarted(testName, contents);
            }

            @Override
            public void afterActionCompleted(String testName, String contents) {
                LightQuickFixTestCase.this.afterActionCompleted(testName, contents);
            }

            @Override
            public void doAction(String text, boolean actionShouldBeAvailable, String testFullPath, String testName) throws Exception {
                LightQuickFixTestCase.this.doAction(text, actionShouldBeAvailable, testFullPath, testName);
            }

            @Override
            public void checkResultByFile(String s, @NotNull String expectedFilePath, boolean b) throws Exception {
                if (expectedFilePath == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expectedFilePath", "com/intellij/codeInsight/daemon/quickFix/LightQuickFixTestCase$1", "checkResultByFile"));
                }
                LightQuickFixTestCase.this.checkResultByFile(s, expectedFilePath, b);
            }

            @Override
            public IntentionAction findActionWithText(String text) {
                return LightQuickFixTestCase.this.findActionWithText(text);
            }

            @Override
            public boolean shouldBeAvailableAfterExecution() {
                return LightQuickFixTestCase.this.shouldBeAvailableAfterExecution();
            }

            @Override
            public void invoke(IntentionAction action) {
                LightQuickFixTestCase.invoke(action);
            }

            @Override
            @NotNull
            public List<HighlightInfo> doHighlighting() {
                List list = LightQuickFixTestCase.this.doHighlighting();
                if (list == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/quickFix/LightQuickFixTestCase$1", "doHighlighting"));
                }
                return list;
            }

            @Override
            @NotNull
            public List<IntentionAction> getAvailableActions() {
                List<IntentionAction> list = LightQuickFixTestCase.this.getAvailableActions();
                if (list == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/quickFix/LightQuickFixTestCase$1", "getAvailableActions"));
                }
                return list;
            }

            @Override
            public void configureFromFileText(String name, String contents) throws IOException {
                LightQuickFixTestCase.configureFromFileText((String)name, (String)contents);
            }

            @Override
            public PsiFile getFile() {
                return LightQuickFixTestCase.getFile();
            }

            @Override
            public Project getProject() {
                return LightPlatformTestCase.getProject();
            }

            @Override
            public void bringRealEditorBack() {
                LightQuickFixTestCase.bringRealEditorBack();
            }
        };
    }

    protected List<IntentionAction> getAvailableActions() {
        this.doHighlighting();
        return LightQuickFixTestCase.getAvailableActions(LightQuickFixTestCase.getEditor(), LightQuickFixTestCase.getFile());
    }

    public static List<IntentionAction> getAvailableActions(@NotNull Editor editor, @NotNull PsiFile file) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/daemon/quickFix/LightQuickFixTestCase", "getAvailableActions"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/daemon/quickFix/LightQuickFixTestCase", "getAvailableActions"));
        }
        return CodeInsightTestFixtureImpl.getAvailableIntentions((Editor)editor, (PsiFile)file);
    }

    @NonNls
    protected String getBasePath() {
        return null;
    }
}

