/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.compiler;

import com.intellij.notification.NotificationGroup;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.compiler.ClassObject;
import com.intellij.openapi.compiler.CompilationException;
import com.intellij.openapi.compiler.CompilationStatusListener;
import com.intellij.openapi.compiler.CompileScope;
import com.intellij.openapi.compiler.CompileStatusNotification;
import com.intellij.openapi.compiler.CompileTask;
import com.intellij.openapi.compiler.Compiler;
import com.intellij.openapi.compiler.CompilerFilter;
import com.intellij.openapi.compiler.TranslatingCompiler;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CompilerManager {
    @Deprecated
    public static final Key<Key> CONTENT_ID_KEY = Key.create((String)"COMPILATION_CONTENT_ID_CUSTOM_KEY");
    public static final NotificationGroup NOTIFICATION_GROUP = NotificationGroup.logOnlyGroup("Compiler");

    public static CompilerManager getInstance(Project project) {
        return ServiceManager.getService(project, CompilerManager.class);
    }

    public abstract boolean isCompilationActive();

    public abstract void addCompiler(@NotNull Compiler var1);

    public abstract void addTranslatingCompiler(@NotNull TranslatingCompiler var1, Set<FileType> var2, Set<FileType> var3);

    public abstract void removeCompiler(@NotNull Compiler var1);

    @NotNull
    public abstract <T extends Compiler> T[] getCompilers(@NotNull Class<T> var1);

    @NotNull
    public abstract <T extends Compiler> T[] getCompilers(@NotNull Class<T> var1, CompilerFilter var2);

    public abstract void addCompilableFileType(@NotNull FileType var1);

    public abstract void removeCompilableFileType(@NotNull FileType var1);

    public abstract boolean isCompilableFileType(@NotNull FileType var1);

    public abstract void addBeforeTask(@NotNull CompileTask var1);

    public abstract void addAfterTask(@NotNull CompileTask var1);

    @NotNull
    public abstract CompileTask[] getBeforeTasks();

    @NotNull
    public abstract CompileTask[] getAfterTasks();

    public abstract void compile(@NotNull VirtualFile[] var1, @Nullable CompileStatusNotification var2);

    public abstract void compile(@NotNull Module var1, @Nullable CompileStatusNotification var2);

    public abstract void compile(@NotNull CompileScope var1, @Nullable CompileStatusNotification var2);

    public abstract void make(@Nullable CompileStatusNotification var1);

    public abstract void make(@NotNull Module var1, @Nullable CompileStatusNotification var2);

    public abstract void make(@NotNull Project var1, @NotNull Module[] var2, @Nullable CompileStatusNotification var3);

    public abstract void make(@NotNull CompileScope var1, @Nullable CompileStatusNotification var2);

    public abstract void make(@NotNull CompileScope var1, CompilerFilter var2, @Nullable CompileStatusNotification var3);

    public abstract boolean isUpToDate(@NotNull CompileScope var1);

    public abstract void rebuild(@Nullable CompileStatusNotification var1);

    public abstract void executeTask(@NotNull CompileTask var1, @NotNull CompileScope var2, String var3, @Nullable Runnable var4);

    public abstract void addCompilationStatusListener(@NotNull CompilationStatusListener var1);

    public abstract void addCompilationStatusListener(@NotNull CompilationStatusListener var1, @NotNull Disposable var2);

    public abstract void removeCompilationStatusListener(@NotNull CompilationStatusListener var1);

    public abstract boolean isExcludedFromCompilation(@NotNull VirtualFile var1);

    @NotNull
    public abstract CompileScope createFilesCompileScope(@NotNull VirtualFile[] var1);

    @NotNull
    public abstract CompileScope createModuleCompileScope(@NotNull Module var1, boolean var2);

    @NotNull
    public abstract CompileScope createModulesCompileScope(@NotNull Module[] var1, boolean var2);

    @NotNull
    public abstract CompileScope createModulesCompileScope(@NotNull Module[] var1, boolean var2, boolean var3);

    @NotNull
    public abstract CompileScope createModuleGroupCompileScope(@NotNull Project var1, @NotNull Module[] var2, boolean var3);

    @NotNull
    public abstract CompileScope createProjectCompileScope(@NotNull Project var1);

    public abstract void setValidationEnabled(ModuleType var1, boolean var2);

    public abstract boolean isValidationEnabled(Module var1);

    public abstract Collection<ClassObject> compileJavaCode(List<String> var1, Collection<File> var2, Collection<File> var3, Collection<File> var4, Collection<File> var5, Collection<File> var6, File var7) throws IOException, CompilationException;

    @Nullable
    public abstract File getJavacCompilerWorkingDir();
}

