/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.actionSystem;

import com.intellij.diagnostic.ThreadDumper;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.util.Alarm;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FreezeLogger {
    private static final Logger LOG = Logger.getInstance(FreezeLogger.class);
    private static final Alarm ALARM = new Alarm(Alarm.ThreadToUse.POOLED_THREAD, ApplicationManager.getApplication());
    private static final int MAX_ALLOWED_TIME = 500;

    public static void runUnderPerformanceMonitor(@Nullable Project project, @NotNull Runnable action) {
        if (action == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "action", "com/intellij/openapi/editor/actionSystem/FreezeLogger", "runUnderPerformanceMonitor"));
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            action.run();
            return;
        }
        ModalityState initial = ModalityState.current();
        ALARM.cancelAllRequests();
        ALARM.addRequest(() -> FreezeLogger.dumpThreads(project, initial), 500);
        try {
            action.run();
        }
        finally {
            ALARM.cancelAllRequests();
        }
    }

    private static void dumpThreads(@Nullable Project project, @NotNull ModalityState initialState) {
        if (initialState == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "initialState", "com/intellij/openapi/editor/actionSystem/FreezeLogger", "dumpThreads"));
        }
        if (!initialState.equals(ModalityState.current())) {
            return;
        }
        String edtTrace = ThreadDumper.dumpEdtStackTrace();
        if (edtTrace.contains("java.lang.ClassLoader.loadClass")) {
            return;
        }
        boolean isInDumbMode = project != null && !project.isDisposed() && DumbService.isDumb(project);
        String dumps = ThreadDumper.dumpThreadsToString();
        String msg = "Typing freeze report, (DumbMode=" + isInDumbMode + ") thread dumps attached. EDT stacktrace:\n" + edtTrace + "\n\n\n";
        LOG.error(msg, new String[]{dumps});
    }
}

